/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module;

import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;

public enum Module {
    COORDINATES("coordinates", ModuleCoordinates.class),
    DESTINATION("destination", ModuleDestination.class),
    DISTANCE("distance", ModuleDistance.class),
    TRACKING("tracking", ModuleTracking.class),
    DIRECTION("direction", ModuleDirection.class),
    WEATHER("weather", ModuleWeather.class),
    TIME("time", ModuleTime.class),
    ANGLE("angle", ModuleAngle.class),
    SPEED("speed", ModuleSpeed.class),
    UNKNOWN("unknown", null);

    private final String name;
    private final Class<? extends BaseModule> moduleClass;

    private Module(String name, Class<? extends BaseModule> moduleClass) {
        this.name = name;
        this.moduleClass = moduleClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends BaseModule> getModuleClass() {
        return this.moduleClass;
    }

    public static Module fromString(String fieldName) {
        for (Module field : Module.values()) {
            if (!field.name.equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return UNKNOWN;
    }

    public static Module fromClass(Class<? extends BaseModule> moduleClass) {
        for (Module field : Module.values()) {
            if (field.moduleClass != moduleClass) continue;
            return field;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.getName();
    }
}

