/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.utils.Helper;

public interface CustomFile<T extends CustomFile<T>> {
    public void reset();

    default public void save() {
        if (!Files.exists(this.getFile().toPath(), new LinkOption[0])) {
            DirectionHUD.LOGGER.info(String.format("Creating new `%s`", this.getFile().getName()));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.getFile().toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(Helper.getGson().toJson((Object)this));
        }
        catch (NoSuchFileException ignored) {
            this.fileNotExist();
        }
        catch (Exception e) {
            DirectionHUD.LOGGER.error(String.format("ERROR SAVING '%s`: %s", this.getFile().getName(), e.getMessage()));
        }
    }

    default public void load() {
        File file = this.getFile();
        if (!Files.exists(this.getFile().toPath(), new LinkOption[0])) {
            this.fileNotExist();
        }
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            this.updateFromReader(reader);
        }
        catch (NoSuchFileException ignored) {
            this.fileNotExist();
        }
        catch (Exception e) {
            DirectionHUD.LOGGER.error(String.format("ERROR LOADING '%s': %s", file.getName(), e.getMessage()));
        }
        this.save();
    }

    default public void updateFromReader(BufferedReader reader) {
        CustomFile file;
        JsonElement json = JsonParser.parseReader((Reader)reader);
        try {
            file = (CustomFile)Helper.getGson().fromJson(json, this.getFileClass());
        }
        catch (Exception e) {
            throw new NullPointerException();
        }
        if (file == null) {
            this.update(json);
        } else {
            file.update(json);
            this.copyFileData(file);
        }
    }

    public Class<T> getFileClass();

    public void copyFileData(T var1);

    public void update(JsonElement var1);

    default public void fileNotExist() {
        try {
            Files.createDirectories(Paths.get(this.getDirectory(), new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            DirectionHUD.LOGGER.error("Failed to create config directory. Canceling all config loading...");
            return;
        }
        this.save();
    }

    public String getFileName();

    public String getDirectory();

    default public File getFile() {
        return new File(this.getDirectory() + this.getFileName());
    }
}

