/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.template;

import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.common.utils.ParticleType;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.utils.CTxT;

public abstract class PlayerTemplate {
    public String toString() {
        return "DirectionHUD Player: " + this.getName();
    }

    public abstract boolean isValid();

    public abstract String getName();

    public CTxT getHighlightedName() {
        return (CTxT)CTxT.of(this.getName()).color(CUtl.s());
    }

    public abstract String getUUID();

    public abstract String getSpawnDimension();

    public abstract String getDimension();

    public abstract int getTimeOfDay();

    public abstract long getWorldTime();

    public abstract boolean hasStorm();

    public abstract boolean hasThunderstorm();

    public abstract float getYaw();

    public abstract float getPitch();

    public abstract Vec getVec();

    public abstract Loc getLoc();

    public abstract int getBlockX();

    public abstract int getBlockY();

    public abstract int getBlockZ();

    public abstract void performCommand(String var1);

    public abstract void sendMessage(CTxT var1);

    public abstract void sendActionBar(CTxT var1);

    public abstract void displayBossBar(CTxT var1);

    public abstract void removeBossBar();

    public abstract PData getPData();

    public abstract CachedPData getPCache();

    public void updateHUD() {
        if (!((Boolean)this.getPCache().getHud().getSetting(Hud.Setting.state)).booleanValue()) {
            if (this.getPCache().getHud().getSetting(Hud.Setting.type).equals(Hud.Setting.DisplayType.actionbar.toString())) {
                this.sendActionBar(CTxT.of(""));
            } else {
                this.removeBossBar();
            }
        }
        if (this.getPCache().getHud().getSetting(Hud.Setting.type).equals(Hud.Setting.DisplayType.actionbar.toString())) {
            this.removeBossBar();
        } else {
            this.sendActionBar(CTxT.of(""));
        }
    }

    public abstract void sendPDataPackets();

    public abstract void sendHUDPackets(ModuleInstructions var1);

    public void displayHUD(CTxT message) {
        if (message.toString().isEmpty()) {
            if (this.getPCache().getMsg("hud.enabled_but_off") == 0) {
                this.getPCache().setMsg("hud.enabled_but_off", 1);
                if (Hud.Setting.DisplayType.get((String)this.getPCache().getHud().getSetting(Hud.Setting.type)).equals((Object)Hud.Setting.DisplayType.actionbar)) {
                    this.sendActionBar(CTxT.of(""));
                } else {
                    this.removeBossBar();
                }
            }
            return;
        }
        if (this.getPCache().getMsg("hud.enabled_but_off") != 0) {
            this.getPCache().setMsg("hud.enabled_but_off", 0);
        }
        if (Hud.Setting.DisplayType.get((String)this.getPCache().getHud().getSetting(Hud.Setting.type)).equals((Object)Hud.Setting.DisplayType.actionbar)) {
            this.sendActionBar(message);
        } else {
            this.displayBossBar(message);
        }
    }

    public abstract void spawnParticle(ParticleType var1, Vec var2);

    public void spawnParticleLine(Vec end, ParticleType particleType) {
        this.spawnParticleLine(this.getVec(), end, particleType);
    }

    public void spawnParticleLine(Vec start, Vec end, ParticleType particleType) {
        Vec playerVec = this.getVec();
        double distance = start.distanceTo(end);
        Vec particlePos = start.add(0.0, -0.2, 0.0);
        double spacing = 1.0;
        Vec segment = end.subtract(start).normalize().multiply(spacing, spacing, spacing);
        double distCovered = 0.0;
        while (distCovered <= distance) {
            distCovered += spacing;
            if (playerVec.distanceTo(particlePos) >= 50.0) break;
            if (!(playerVec.distanceTo(particlePos) < 0.5)) {
                this.spawnParticle(particleType, particlePos);
            }
            particlePos = particlePos.add(segment);
        }
    }
}

