/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

public class Vec {
    private final double x;
    private final double y;
    private final double z;

    public Vec() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec(Vec vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vec add(Vec addVec) {
        return this.add(addVec.x, addVec.y, addVec.z);
    }

    public Vec add(double x, double y, double z) {
        return new Vec(this.x + x, this.y + y, this.z + z);
    }

    public Vec subtract(Vec subVec) {
        return this.add(-subVec.x, -subVec.y, -subVec.z);
    }

    public Vec subtract(double x, double y, double z) {
        return new Vec(this.x - x, this.y - y, this.z - z);
    }

    public Vec multiply(double x, double y, double z) {
        return new Vec(this.x * x, this.y * y, this.z * z);
    }

    public Vec divide(double x, double y, double z) {
        return new Vec(this.x / x, this.y / y, this.z / z);
    }

    public Vec normalize() {
        double magnitude = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (magnitude < 1.0E-5) {
            return new Vec();
        }
        return new Vec(this.x / magnitude, this.y / magnitude, this.z / magnitude);
    }

    public double distanceTo(Vec vec) {
        double xD = vec.x - this.x;
        double yD = vec.y - this.y;
        double zD = vec.z - this.z;
        return Math.sqrt(xD * xD + yD * yD + zD * zD);
    }

    public String toString() {
        return "Vec{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

