/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.utils;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5218;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.DirectionHUDClient;
import one.oth3r.directionhud.commands.ModCommands;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.Events;
import one.oth3r.directionhud.common.LoopManager;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.packet.PacketSender;
import one.oth3r.directionhud.packet.Payloads;
import one.oth3r.directionhud.utils.ModData;
import one.oth3r.directionhud.utils.Player;

public class ModEvents {
    private static void clientConnections() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (client.method_1542()) {
                DirectionHUD.getData().setSingleplayer(true);
            }
            client.execute(() -> new PacketSender(Assets.packets.INITIALIZATION, "Hello from the DirectionHUD client!").sendToServer());
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            DirectionHUD.getData().setSingleplayer(false);
            DirectionHUD.getData().setOnSupportedServer(false);
            if (client.field_1724 == null) {
                return;
            }
            Player player = DirectionHUDClient.getPlayerFromClient(client);
            PlayerData.removePlayerData(player);
            PlayerData.removePlayerCache(player);
        });
    }

    private static void playerConnections() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Events.playerJoin(new Player(handler.field_14140)));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> Events.playerLeave(new Player(handler.field_14140)));
    }

    private static void serverLifecycle() {
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            ModData modData = DirectionHUD.getData();
            modData.setPlayerManager(s.method_3760());
            modData.setServer(s);
            modData.setCommandManager(s.method_3734());
            if (modData.isClient()) {
                modData.setDataDirectory(String.valueOf(DirectionHUD.getData().getServer().method_27050(class_5218.field_24188).normalize()) + "/directionhud/");
            } else {
                modData.setDataDirectory(String.valueOf(FabricLoader.getInstance().getConfigDir().toFile()) + "/directionhud/");
            }
            Events.serverStart();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> Events.serverEnd());
        ServerTickEvents.END_SERVER_TICK.register(s -> s.execute(LoopManager::tick));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            ModCommands.Register.directionhud((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.Register.destination((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.Register.hud((CommandDispatcher<class_2168>)dispatcher);
        });
    }

    private static void clientLifecycle() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ModData modData = DirectionHUD.getData();
            assert (client.field_1724 != null);
            Keybindings.loopLogic(client);
            if (modData.isOnSupportedServer()) {
                modData.getActionBarOverride().tick();
                if (!modData.isSingleplayer()) {
                    LoopManager.tickRainbow();
                }
            }
        });
    }

    public static void registerCommon() {
        ModData modData = DirectionHUD.getData();
        modData.setConfigDirectory(String.valueOf(FabricLoader.getInstance().getConfigDir().toFile()) + "/directionhud/");
        FileData.loadFiles();
        ModEvents.playerConnections();
        ModEvents.serverLifecycle();
        Packet.common();
    }

    public static void registerClient() {
        DirectionHUD.getData().setClient(true);
        ModEvents.clientConnections();
        ModEvents.clientLifecycle();
        Packet.client();
        Keybindings.register();
    }

    private static class Packet {
        private Packet() {
        }

        private static void common() {
            PayloadTypeRegistry.playS2C().register(Payloads.HUD.ID, Payloads.HUD.CODEC);
            PayloadTypeRegistry.playS2C().register(Payloads.SpigotHUD.ID, Payloads.SpigotHUD.CODEC);
            PayloadTypeRegistry.playS2C().register(Payloads.PlayerData.ID, Payloads.PlayerData.CODEC);
            PayloadTypeRegistry.playS2C().register(Payloads.SpigotPlayerData.ID, Payloads.SpigotPlayerData.CODEC);
            PayloadTypeRegistry.playC2S().register(Payloads.Initialization.ID, Payloads.Initialization.CODEC);
            ServerPlayNetworking.registerGlobalReceiver(Payloads.Initialization.ID, (payload, context) -> DirectionHUD.getData().getServer().execute(() -> {
                Player player = new Player(context.player());
                DirectionHUD.LOGGER.info("Received initialization packet from " + player.getName());
                DirectionHUD.getData().getClientPlayers().add(player);
                player.sendPDataPackets();
            }));
        }

        private static void client() {
            ClientPlayNetworking.registerGlobalReceiver(Payloads.PlayerData.ID, (payload, context) -> Packet.playerDataPacketLogic(context.client(), payload.value()));
            ClientPlayNetworking.registerGlobalReceiver(Payloads.SpigotPlayerData.ID, (payload, context) -> Packet.playerDataPacketLogic(context.client(), payload.value()));
            ClientPlayNetworking.registerGlobalReceiver(Payloads.HUD.ID, (payload, context) -> Packet.hudPacketLogic(context.client(), payload.value()));
            ClientPlayNetworking.registerGlobalReceiver(Payloads.SpigotHUD.ID, (payload, context) -> Packet.hudPacketLogic(context.client(), payload.value()));
        }

        public static void playerDataPacketLogic(class_310 client, String packet) {
            client.execute(() -> {
                if (!client.method_1542()) {
                    Player player = DirectionHUDClient.getPlayerFromClient(client);
                    PData pData = (PData)Helper.getGson().fromJson(packet, PData.class);
                    pData.setPlayer(player);
                    PlayerData.setPlayerData(player, pData);
                    PlayerData.setPlayerCache(player, new CachedPData(pData));
                }
                DirectionHUD.getData().setOnSupportedServer(true);
            });
        }

        public static void hudPacketLogic(class_310 client, String packet) {
            client.execute(() -> {
                if (DirectionHUD.getData().getActionBarOverride().canDisplay()) {
                    Player player = DirectionHUDClient.getPlayerFromClient(client);
                    player.sendActionBar(Hud.build.compile(player, (ModuleInstructions)Helper.getGson().fromJson(packet, ModuleInstructions.class)));
                }
            });
        }
    }

    private static class Keybindings {
        private static class_304 keyBinding;

        private Keybindings() {
        }

        private static void register() {
            keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.directionhud.keybind.toggle", class_3675.class_307.field_1668, 72, "category.directionhud.all"));
        }

        private static void loopLogic(class_310 client) {
            while (keyBinding.method_1436()) {
                if (!DirectionHUD.getData().isOnSupportedServer()) continue;
                assert (client.field_1724 != null);
                client.field_1724.field_3944.method_45731("hud toggle");
            }
        }
    }
}

