/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.files.dimension.DimensionEntry;
import one.oth3r.directionhud.common.files.dimension.DimensionSettings;
import one.oth3r.directionhud.common.files.dimension.RatioEntry;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Utl;

public class Dimension {
    public static final DimensionEntry.Time OVERWORLD_TIME_ENTRY = new DimensionEntry.Time(new DimensionEntry.Time.Weather(new DimensionEntry.Time.Weather.NightTicks(new DimensionEntry.Time.TimePair(12542, 0), new DimensionEntry.Time.TimePair(12010, 0), new DimensionEntry.Time.TimePair(0, 24000)), new DimensionEntry.Time.Weather.Icons("\u2600", "\u263d", "\ud83c\udf27", "\u26c8")));
    private static final DimensionSettings dimensionSettings = new DimensionSettings();

    public static void setDimensionSettings(DimensionSettings dimensionSettings, boolean save) {
        Dimension.dimensionSettings.copyFileData(dimensionSettings);
        if (save) {
            dimensionSettings.save();
        }
    }

    public static DimensionSettings getDimensionSettings() {
        return new DimensionSettings(dimensionSettings);
    }

    public static void loadDimensionSettings() {
        dimensionSettings.load();
    }

    public static ArrayList<String> getAllIDs() {
        return dimensionSettings.getDimensions().stream().map(DimensionEntry::getId).collect(Collectors.toCollection(ArrayList::new));
    }

    public static DimensionEntry.Time getTimeSettings(String id) {
        return dimensionSettings.getDimensions().stream().filter(dimension -> dimension.getId().equals(id)).map(DimensionEntry::getTime).findFirst().orElse(new DimensionEntry.Time());
    }

    public static String getName(String id) {
        return dimensionSettings.getDimensions().stream().filter(dimension -> dimension.getId().equals(id)).map(DimensionEntry::getName).findFirst().orElse("unknown");
    }

    public static String getColor(String id) {
        return dimensionSettings.getDimensions().stream().filter(dimension -> dimension.getId().equals(id)).map(DimensionEntry::getColor).findFirst().orElse("#FF0000");
    }

    public static CTxT getBadge(String id) {
        DimensionEntry dim2 = dimensionSettings.getDimensions().stream().filter(dimension -> dimension.getId().equals(id)).findFirst().orElse(null);
        if (dim2 == null) {
            return ((CTxT)CTxT.of("X").btn(true)).hover(CTxT.of("???"));
        }
        return ((CTxT)((CTxT)CTxT.of(String.valueOf(dim2.getName().charAt(0)).toUpperCase()).btn(true)).color(dim2.getColor())).hover((CTxT)CTxT.of(dim2.getName()).color(dim2.getColor()));
    }

    public static ArrayList<Helper.Pair<String, String>> getRatioPairs() {
        return dimensionSettings.getRatios().stream().map(RatioEntry::getDimensionPair).collect(Collectors.toCollection(ArrayList::new));
    }

    public static boolean canConvert(String dimensionA, String dimensionB) {
        if (dimensionA.equalsIgnoreCase(dimensionB)) {
            return false;
        }
        Helper.Pair<String, String> key = new Helper.Pair<String, String>(dimensionA, dimensionB);
        return Dimension.getRatioPairs().contains(key) || Dimension.getRatioPairs().contains(key.getFlipped());
    }

    public static double getRatio(String dimensionFrom, String dimensionTo) {
        ArrayList<Helper.Pair<String, String>> pairs = Dimension.getRatioPairs();
        Helper.Pair<String, String> dimensionPair = new Helper.Pair<String, String>(dimensionFrom, dimensionTo);
        Helper.Pair<String, String> flippedPair = dimensionPair.getFlipped();
        if (pairs.contains(dimensionPair)) {
            return dimensionSettings.getRatios().get(pairs.indexOf(dimensionPair)).getRatio();
        }
        if (pairs.contains(flippedPair)) {
            return 1.0 / dimensionSettings.getRatios().get(pairs.indexOf(flippedPair)).getRatio();
        }
        return 1.0;
    }

    public static boolean checkValid(String id) {
        return dimensionSettings.getDimensions().stream().anyMatch(dimension -> dimension.getId().equals(id));
    }

    public static ArrayList<RatioEntry> convertLegacyRatios(List<String> oldList) {
        ArrayList<RatioEntry> out = new ArrayList<RatioEntry>();
        for (String s : oldList) {
            String[] entries = s.split("\\|");
            if (entries.length != 2) continue;
            String[] entry1 = entries[0].split("=");
            String[] entry2 = entries[1].split("=");
            RatioEntry entry = new RatioEntry();
            entry.setDimension1(new Helper.Pair<String, Double>(Utl.dim.updateLegacy(entry1[0]), Double.parseDouble(entry1[1])));
            entry.setDimension2(new Helper.Pair<String, Double>(Utl.dim.updateLegacy(entry2[0]), Double.parseDouble(entry2[1])));
            out.add(entry);
        }
        return out;
    }

    public static ArrayList<DimensionEntry> convertLegacyDimensions(List<String> oldList) {
        ArrayList<DimensionEntry> list = new ArrayList<DimensionEntry>();
        for (String entry : oldList) {
            String[] entries = entry.split("\\|");
            if (entries.length != 3) continue;
            DimensionEntry data = new DimensionEntry(Utl.dim.updateLegacy(entries[0]), entries[1], entries[2], new DimensionEntry.Time(DirectionHUD.getData().isMod()));
            if (entries[0].contains("overworld")) {
                data.setTime(OVERWORLD_TIME_ENTRY);
            }
            list.add(data);
        }
        return list;
    }
}

