/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module;

import java.util.List;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleLight;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.CTxT;

public enum Module {
    COORDINATES("coordinates", ModuleCoordinates.class, List.of(Loc.class)),
    DESTINATION("destination", ModuleDestination.class, List.of(Dest.class)),
    DISTANCE("distance", ModuleDistance.class, List.of(Integer.class)),
    TRACKING("tracking", ModuleTracking.class, List.of(Double.class, Loc.class, Loc.class)),
    DIRECTION("direction", ModuleDirection.class, List.of(Double.class)),
    WEATHER("weather", ModuleWeather.class, List.of(String.class, String.class)),
    TIME("time", ModuleTime.class, List.of(Integer.class, Integer.class)),
    ANGLE("angle", ModuleAngle.class, List.of(Float.class, Float.class)),
    SPEED("speed", ModuleSpeed.class, List.of(Double.class)),
    LIGHT("light", ModuleLight.class, List.of(Integer.class, Integer.class)),
    UNKNOWN("unknown", null, List.of());

    private final String name;
    private final Class<? extends BaseModule> moduleClass;
    private final List<Class<?>> displayArguments;

    private Module(String name, Class<? extends BaseModule> moduleClass, List<Class<?>> displayArguments) {
        this.name = name;
        this.moduleClass = moduleClass;
        this.displayArguments = displayArguments == null ? List.of() : displayArguments;
    }

    public String getName() {
        return this.name;
    }

    public List<Class<?>> getDisplayArguments() {
        return this.displayArguments;
    }

    public boolean verifyDisplayArguments(List<Object> displayArguments) {
        if (displayArguments.size() != this.displayArguments.size()) {
            return false;
        }
        for (int i = 0; i < displayArguments.size(); ++i) {
            Class<?> actualClass;
            Object actual = displayArguments.get(i);
            if (actual == null) {
                return false;
            }
            Class<?> expected = this.displayArguments.get(i);
            if (expected.isAssignableFrom(actualClass = actual.getClass())) continue;
            return false;
        }
        return true;
    }

    public CTxT getCTxT() {
        return (CTxT)new CTxT(this.name).color(CUtl.s());
    }

    public Class<? extends BaseModule> getModuleClass() {
        return this.moduleClass;
    }

    public static Module fromString(String fieldName) {
        for (Module field : Module.values()) {
            if (!field.name.equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return UNKNOWN;
    }

    public static Module fromClass(Class<? extends BaseModule> moduleClass) {
        for (Module field : Module.values()) {
            if (field.moduleClass != moduleClass) continue;
            return field;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.getName();
    }
}

