/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.display;

import java.util.HashMap;
import java.util.Map;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;

public class DisplayRegistry {
    private static final Map<Module, DisplaySettings> modules = new HashMap<Module, DisplaySettings>();

    public static void registerModuleDisplay(Module module, DisplaySettings display) {
        modules.put(module, display);
    }

    public static DisplaySettings getModuleDisplay(Module module) {
        return modules.get((Object)module);
    }

    public static void updateModules(Map<Module, DisplaySettings> input) {
        for (Map.Entry<Module, DisplaySettings> entry : modules.entrySet()) {
            DisplaySettings moduleDisplay = entry.getValue();
            DisplaySettings inputModuleDisplay = input.get((Object)entry.getKey());
            if (inputModuleDisplay == null) continue;
            moduleDisplay.updateDisplay(inputModuleDisplay);
        }
    }

    public static Map<Module, DisplaySettings> getModules() {
        return new HashMap<Module, DisplaySettings>(modules);
    }

    public static String getDisplayString(Module module, String displayName) {
        DisplaySettings display = modules.get((Object)module);
        if (display == null) {
            return "";
        }
        return display.getDisplay(displayName);
    }

    public static String getFormatted(Module module, String displayName, Object ... args) {
        return String.format(DisplayRegistry.getDisplayString(module, displayName), args);
    }
}

