/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.display;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public class DisplaySettings {
    @SerializedName(value="displays")
    private Map<String, String> displays;
    @SerializedName(value="assets")
    private Assets assets;

    public void addDisplay(String displayID, String display) {
        if (this.displays == null) {
            this.displays = new HashMap<String, String>();
        }
        this.displays.put(displayID, display);
    }

    public void setDisplays(Map<String, String> display) {
        this.displays = display;
    }

    public String getDisplay(String displayID) {
        return this.displays == null ? "" : this.displays.get(displayID);
    }

    public void addAsset(String groupID, String assetID, String asset) {
        if (this.assets == null) {
            this.assets = new Assets();
        }
        this.assets.addAsset(groupID, assetID, asset);
    }

    public void addAssetGroup(String groupID, AssetGroup groupAssets) {
        if (this.assets == null) {
            this.assets = new Assets();
        }
        this.assets.addAssets(groupID, groupAssets);
    }

    public void setAssets(Assets assets) {
        this.assets = new Assets(assets);
    }

    public AssetGroup getAssetGroup(String groupID) {
        return this.assets == null ? null : this.assets.getAssets(groupID);
    }

    public String getAsset(String groupID, String assetID) {
        return this.assets == null ? "" : this.assets.getAsset(groupID, assetID);
    }

    public void updateDisplay(DisplaySettings display) {
        Object inputValue;
        for (Map.Entry<String, String> displayEntry : this.displays.entrySet()) {
            String innerKey = displayEntry.getKey();
            inputValue = display.getDisplay(innerKey);
            if (inputValue == null || ((String)inputValue).isEmpty()) continue;
            this.displays.put(innerKey, (String)inputValue);
        }
        if (this.assets != null && display.assets != null) {
            for (String groupID : this.assets.getGroupIDs()) {
                AssetGroup innerMap = this.assets.getAssets(groupID);
                inputValue = display.getAssetGroup(groupID);
                if (inputValue == null || ((HashMap)inputValue).isEmpty()) continue;
                for (Map.Entry assetEntry : ((HashMap)inputValue).entrySet()) {
                    String innerAssetID = (String)assetEntry.getKey();
                    String innerAsset = (String)assetEntry.getValue();
                    if (innerAsset == null) continue;
                    innerMap.put(innerAssetID, innerAsset);
                }
            }
        }
    }

    public static class Assets
    extends HashMap<String, AssetGroup> {
        public Assets() {
        }

        public Assets(Map<String, AssetGroup> map) {
            super(map != null ? map : new HashMap());
        }

        public void addAsset(String groupID, String assetID, String asset) {
            this.computeIfAbsent(groupID, k -> new AssetGroup()).put(assetID, asset);
        }

        public void addAssets(String groupID, AssetGroup groupAssets) {
            this.put(groupID, new AssetGroup(groupAssets));
        }

        public AssetGroup getAssets(String groupID) {
            return (AssetGroup)this.get(groupID);
        }

        public String getAsset(String groupID, String assetID) {
            AssetGroup group = (AssetGroup)this.get(groupID);
            return group == null ? "" : group.getOrDefault(assetID, "");
        }

        public Iterable<String> getGroupIDs() {
            return this.keySet();
        }
    }

    public static class AssetGroup
    extends HashMap<String, String> {
        public AssetGroup() {
        }

        public AssetGroup(Map<String, String> map) {
            super(map != null ? map : new HashMap());
        }
    }
}

