/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.modules;

import java.text.DecimalFormat;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.BooleanModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingButtonDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingType;

public class ModuleSpeed
extends BaseModule {
    public static final String calculation2DID = "speed_2d-calculation";
    public static final String displayPatternID = "speed_display-pattern";
    public static final String DISPLAY_XYZ = "xyz_speed";
    public static final String DISPLAY_XZ = "xz_speed";

    public ModuleSpeed() {
        super(Module.SPEED);
    }

    public ModuleSpeed(Integer order, boolean state, boolean calculation2D, String displayPattern) {
        super(Module.SPEED, order, state);
        this.registerSetting(calculation2DID, calculation2D, new BooleanModuleSettingHandler(Module.SPEED, calculation2DID, true, false, new ModuleSettingButtonDisplay(true)));
        this.registerSetting(displayPatternID, displayPattern, new ModuleSettingHandler<String>(){

            @Override
            public boolean isValid(String value) {
                try {
                    new DecimalFormat(value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public String convert(String value) throws IllegalArgumentException {
                return value;
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.SPEED, ModuleSpeed.displayPatternID, ModuleSettingType.CUSTOM, true);
            }
        });
    }

    @Override
    protected String[] getSettingOrder() {
        return new String[]{calculation2DID, displayPatternID};
    }

    @Override
    protected String display(Object ... args) {
        double speed = (Double)args[0];
        boolean speed2D = (Boolean)this.getSettingValue(calculation2DID);
        DecimalFormat df = new DecimalFormat((String)this.getSettingValue(displayPatternID));
        String data = df.format(speed);
        if (speed2D) {
            return DisplayRegistry.getFormatted(this.moduleType, DISPLAY_XYZ, data);
        }
        return DisplayRegistry.getFormatted(this.moduleType, DISPLAY_XZ, data);
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        DisplaySettings display = new DisplaySettings();
        display.addDisplay(DISPLAY_XZ, "&2%s &1B/S");
        display.addDisplay(DISPLAY_XYZ, "&2%s &1B/S");
        return display;
    }
}

