/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.modules;

import java.util.Objects;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DirectionAssetGroup;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.BooleanModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingButtonDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingType;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;

public class ModuleTracking
extends BaseModule {
    public static final String hybridID = "tracking_hybrid";
    public static final String targetID = "tracking_target";
    public static final String typeID = "tracking_display";
    public static final String elevationID = "tracking_show-elevation";
    public static final String ASSET_SIMPLE = "simple";
    public static final String ASSET_COMPACT = "compact";
    public static final String ASSET_ELEVATION = "elevation";
    public static final String ELEVATION_ABOVE = "above";
    public static final String ELEVATION_SAME = "same";
    public static final String ELEVATION_BELOW = "below";
    public static final String DISPLAY_TRACKING = "tracking";
    public static final String DISPLAY_ELEVATION_TRACKING = "elevation_tracking";

    public ModuleTracking() {
        super(Module.TRACKING);
    }

    public ModuleTracking(Integer order, boolean state, boolean hybrid, Target target, Type type, boolean elevation) {
        super(Module.TRACKING, order, state);
        this.registerSetting(hybridID, hybrid, new BooleanModuleSettingHandler(Module.TRACKING, hybridID, false, false, new ModuleSettingButtonDisplay().addTrueFalseMapping("\ud83d\udd00")));
        this.registerSetting(targetID, target, new ModuleSettingHandler<Target>(){

            @Override
            public boolean isValid(Target value) {
                return Objects.nonNull((Object)value);
            }

            @Override
            public Target convert(String value) throws IllegalArgumentException {
                return Target.valueOf(value);
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.TRACKING, ModuleTracking.targetID, ModuleSettingType.ENUM_SWITCH, false);
            }
        });
        this.registerSetting(typeID, type, new ModuleSettingHandler<Type>(){

            @Override
            public boolean isValid(Type value) {
                return Objects.nonNull((Object)value);
            }

            @Override
            public Type convert(String value) throws IllegalArgumentException {
                return Type.valueOf(value);
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.TRACKING, ModuleTracking.typeID, ModuleSettingType.ENUM_SWITCH, true, new ModuleSettingButtonDisplay(true).addMapping(ModuleTracking.ASSET_SIMPLE, "\u25b2").addMapping(ModuleTracking.ASSET_COMPACT, "\u2b06"));
            }
        });
        this.registerSetting(elevationID, elevation, new BooleanModuleSettingHandler(Module.TRACKING, elevationID, false, false, new ModuleSettingButtonDisplay().addTrueFalseMapping("\u26f0")));
    }

    @Override
    protected String[] getSettingOrder() {
        return new String[]{hybridID, targetID, typeID, elevationID};
    }

    @Override
    protected String display(Object ... args) {
        int z;
        double originRotation = (Double)args[0];
        Loc originLoc = (Loc)args[1];
        Loc targetLoc = (Loc)args[2];
        boolean simple = this.getSettingValue(typeID).equals((Object)Type.simple);
        boolean hasElevation = (Boolean)this.getSettingValue(elevationID);
        DisplaySettings display = DisplayRegistry.getModuleDisplay(this.moduleType);
        DisplaySettings.AssetGroup arrows2 = display.getAssetGroup(simple ? ASSET_SIMPLE : ASSET_COMPACT);
        DisplaySettings.AssetGroup elevation = display.getAssetGroup(ASSET_ELEVATION);
        int x = targetLoc.getX() - originLoc.getX();
        double target = Math.toDegrees(Math.atan2(x, z = (targetLoc.getZ() - originLoc.getZ()) * -1));
        if (target < 0.0) {
            target += 360.0;
        }
        String data = Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 15.0, 360.0), Helper.Num.wAdd(target, 15.0, 360.0)) ? (String)arrows2.get("north") : (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 65.0, 360.0)) ? (String)arrows2.get("north_west") : (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 115.0, 360.0)) ? (String)arrows2.get("west") : (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 165.0, 360.0)) ? (String)arrows2.get("south_west") : (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 65.0, 360.0), target) ? (String)arrows2.get("north_east") : (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 115.0, 360.0), target) ? (String)arrows2.get("east") : (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 165.0, 360.0), target) ? (String)arrows2.get("south_east") : (String)arrows2.get("south")))))));
        if (hasElevation && targetLoc.hasY()) {
            int originY = originLoc.getY();
            int targetY = targetLoc.getY();
            String elevationID = !targetLoc.hasY() || originY - 2 < targetY && targetY < originY + 2 ? ELEVATION_SAME : (originY > targetY ? ELEVATION_BELOW : ELEVATION_ABOVE);
            return DisplayRegistry.getFormatted(this.moduleType, DISPLAY_ELEVATION_TRACKING, data, elevation.get(elevationID));
        }
        return DisplayRegistry.getFormatted(this.moduleType, DISPLAY_TRACKING, data);
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        DisplaySettings display = new DisplaySettings();
        display.addAssetGroup(ASSET_SIMPLE, DirectionAssetGroup.create("-\u25b2\u25b6", "-\u25b2-", "\u25c0\u25b2-", "\u25c0--", "\u25c0\u25bc-", "-\u25bc-", "-\u25bc\u25b6", "--\u25b6"));
        display.addAssetGroup(ASSET_COMPACT, DirectionAssetGroup.create("\u2b08", "\u2b06", "\u2b09", "\u2b05", "\u2b0b", "\u2b07", "\u2b0a", "\u2b95"));
        display.addAsset(ASSET_ELEVATION, ELEVATION_ABOVE, "\u2b06");
        display.addAsset(ASSET_ELEVATION, ELEVATION_SAME, "-");
        display.addAsset(ASSET_ELEVATION, ELEVATION_BELOW, "\u2b07");
        display.addDisplay(DISPLAY_TRACKING, "&1&s[&r&2%s&1&s]");
        display.addDisplay(DISPLAY_ELEVATION_TRACKING, "&1&s[&r&2%s&1|&2%s&1&s]");
        return display;
    }

    public static enum Type {
        simple,
        compact;

    }

    public static enum Target {
        player,
        dest;

    }
}

