/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.setting;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Method;
import java.util.Objects;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;

public class ModuleSetting<V>
implements Cloneable {
    @SerializedName(value="id")
    protected final String id;
    @SerializedName(value="value")
    protected V value;
    protected transient ModuleSettingHandler<V> validator;

    public ModuleSetting(String id, V defaultValue, ModuleSettingHandler<V> validator) {
        this.id = id;
        this.value = defaultValue;
        this.validator = validator;
    }

    public ModuleSetting(String id, Object value, ModuleSettingHandler<?> validator, boolean isDynamic) {
        this.id = id;
        Object v = value;
        this.value = v;
        ModuleSettingHandler<?> val = validator;
        this.validator = val;
    }

    public String getId() {
        return this.id;
    }

    public V getValue() {
        return this.value;
    }

    public boolean setValue(V value) {
        if (this.validator.isValid(value)) {
            this.value = value;
            return true;
        }
        return false;
    }

    public ModuleSettingHandler<V> getValidator() {
        return this.validator;
    }

    public ModuleSettingDisplay getDisplay() {
        return this.validator.getSettingDisplay();
    }

    public void setValidator(ModuleSettingHandler<?> validator) {
        this.validator = validator;
    }

    public ModuleSetting<V> clone() {
        V clonedValue = this.cloneValue(this.value);
        return new ModuleSetting<V>(this.id, clonedValue, this.validator);
    }

    protected V cloneValue(V original) {
        if (original == null) {
            return null;
        }
        if (original instanceof Cloneable) {
            try {
                Method cloneMethod = original.getClass().getMethod("clone", new Class[0]);
                return (V)cloneMethod.invoke(original, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return original;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleSetting that = (ModuleSetting)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }
}

