/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.setting;

import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.ModuleManager;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingButtonDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandlerRegistry;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingType;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.utils.CTxT;

public class ModuleSettingDisplay {
    protected final Module module;
    protected final String settingID;
    protected final ModuleSettingType settingType;
    protected final boolean showExample;
    protected final ModuleSettingButtonDisplay buttonDisplay;

    public ModuleSettingDisplay(Module module, String settingID, ModuleSettingType settingType, boolean showExample) {
        this.module = module;
        this.settingID = settingID;
        this.settingType = settingType;
        this.showExample = showExample;
        this.buttonDisplay = new ModuleSettingButtonDisplay();
    }

    public ModuleSettingDisplay(Module module, String settingID, ModuleSettingType settingType, boolean showExample, ModuleSettingButtonDisplay buttonDisplay) {
        this.module = module;
        this.settingID = settingID;
        this.settingType = settingType;
        this.showExample = showExample;
        this.buttonDisplay = buttonDisplay;
    }

    public CTxT getSetMsg(String value) {
        return switch (this.settingType) {
            default -> throw new IncompatibleClassChangeError();
            case ModuleSettingType.ENUM_SWITCH -> SetMSG.enumString(this.module, this.settingID, value);
            case ModuleSettingType.BOOLEAN_SWITCH -> SetMSG.customToggle(this.module, this.settingID, Boolean.parseBoolean(value));
            case ModuleSettingType.BOOLEAN_TOGGLE -> SetMSG.toggle(this.module, this.settingID, Boolean.parseBoolean(value));
            case ModuleSettingType.CUSTOM -> SetMSG.custom(this.module, this.settingID, new CTxT(value));
        };
    }

    public <T> CTxT getButton(String value) {
        Lang LANG = ModuleManager.Setting.LANG;
        Lang moduleLang = new Lang(LANG, this.module.getName() + ".");
        String setCMD = "/hud modules setting-r " + this.module.getName() + " ";
        String buttonString = this.buttonDisplay.getText(value);
        CTxT exampleTxT = new CTxT(" - ").append((CTxT)moduleLang.get(this.settingID + "." + value, new Object[0]).color('7'));
        CTxT buttonTxT = buttonString == null ? moduleLang.get(this.settingID + "." + value, new Object[0]) : new CTxT(buttonString);
        ((CTxT)buttonTxT.btn(true)).color(this.buttonDisplay.getColor(value));
        CTxT hover = (CTxT)moduleLang.get(this.settingID + ".ui", new Object[0]).color(CUtl.s());
        if (this.showExample) {
            hover.append(exampleTxT);
        }
        hover.append("\n").append((CTxT)moduleLang.get(this.settingID + (String)(this.buttonDisplay.hasCustomInfo() ? "." + value : "") + ".info", new Object[0]).color('7')).append("\n\n");
        switch (this.settingType) {
            case BOOLEAN_SWITCH: 
            case BOOLEAN_TOGGLE: {
                boolean state = Boolean.parseBoolean(value);
                if (this.settingType.equals((Object)ModuleSettingType.BOOLEAN_TOGGLE) && buttonString == null) {
                    buttonTxT.text((CTxT)CUtl.DLANG.btn(state ? "on" : "off", new Object[0]).color(state ? (char)'a' : 'c')).btn(true);
                }
                if (this.settingType.equals((Object)ModuleSettingType.BOOLEAN_SWITCH)) {
                    hover.append(LANG.hover("set", moduleLang.get(this.settingID, new Object[0]), moduleLang.get(this.settingID + "." + !state, new Object[0]).color(CUtl.s())));
                } else {
                    hover.append(LANG.hover("set.toggle", moduleLang.get(this.settingID, new Object[0]), CUtl.DLANG.get("fill." + (!state ? "on" : "off"), new Object[0]).color(!state ? (char)'a' : 'c')));
                }
                buttonTxT.hover(hover).click(1, setCMD + this.settingID + " " + !state);
                break;
            }
            case ENUM_SWITCH: {
                Object current = ModuleSettingHandlerRegistry.getHandler(this.settingID).convert(value);
                Enum enumValue = (Enum)current;
                Enum next = Helper.Enums.next((Enum)enumValue, enumValue.getClass(), (Enum[])new Enum[0]);
                hover.append(LANG.hover("set", moduleLang.get(this.settingID, new Object[0]), moduleLang.get(this.settingID + "." + String.valueOf(next), new Object[0]).color(CUtl.s())));
                buttonTxT.hover(hover).click(1, setCMD + this.settingID + " " + String.valueOf(next));
                break;
            }
            case CUSTOM: {
                hover = (CTxT)moduleLang.get(this.settingID + ".ui", new Object[0]).color(CUtl.s());
                if (this.showExample) {
                    hover.append(" - ").append((CTxT)new CTxT(value).color('7'));
                }
                hover.append("\n").append((CTxT)moduleLang.get(this.settingID + ".info", new Object[0]).color('7')).append("\n\n");
                if (buttonString == null) {
                    buttonTxT.text(value);
                }
                hover.append(LANG.hover("set.custom", moduleLang.get(this.settingID, new Object[0]), moduleLang.get(this.settingID, new Object[0]).color(CUtl.s())));
                buttonTxT.hover(hover).click(2, setCMD + this.settingID + " ");
            }
        }
        return buttonTxT;
    }

    protected static class SetMSG {
        public static final Lang LANG = ModuleManager.Setting.LANG;

        protected SetMSG() {
        }

        public static CTxT customToggle(Module module, String settingID, boolean state) {
            Lang settingsLang = new Lang(LANG, module.getName() + "." + settingID + ".");
            return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)settingsLang.get(state ? "true" : "false", new Object[0]).color(CUtl.s()));
        }

        public static CTxT toggle(Module module, String settingID, boolean state) {
            return SetMSG.setMSGBuilder("set.toggle", module, settingID, CUtl.toggleTxT(state));
        }

        public static CTxT enumString(Module module, String settingID, String enumString) {
            Lang settingsLang = new Lang(LANG, module.getName() + "." + settingID + ".");
            return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)settingsLang.get(enumString, new Object[0]).color(CUtl.s()));
        }

        public static CTxT custom(Module module, String settingID, CTxT customSetMSG) {
            return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)customSetMSG.color(CUtl.s()));
        }

        private static CTxT setMSGBuilder(String setLang, Module module, String settingID, CTxT setMSG) {
            return LANG.msg(setLang, LANG.get(module.getName() + "." + settingID, new Object[0]).color(CUtl.s()), setMSG);
        }
    }
}

