/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import com.google.gson.Gson;
import java.util.Objects;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public class Dest
extends Loc {
    private String name = null;
    private String color = null;

    public Dest() {
    }

    public Dest(Integer x, Integer y, Integer z, String dimension, String name, String color2) {
        super(x, y, z, dimension);
        this.name = name;
        this.color = color2;
    }

    public Dest(Dest dest2) {
        super(dest2);
        this.name = dest2.name;
        this.color = dest2.color;
    }

    public Dest(Player player, String name, String color2) {
        super(player);
        this.name = name;
        this.color = color2;
    }

    public Dest(Loc loc, String name, String color2) {
        super(loc);
        this.name = name;
        this.color = color2;
    }

    public Dest(String dest2) {
        super((Loc)new Gson().fromJson(dest2, Dest.class));
        Dest data = (Dest)new Gson().fromJson(dest2, Dest.class);
        this.name = data.name;
        this.color = data.color;
    }

    public boolean hasDestRequirements() {
        return this.isValid() && this.name != null && this.color != null;
    }

    @Override
    public CTxT getBadge() {
        CTxT msg = CTxT.of("");
        if (this.getDimension() != null) {
            msg.append(Dimension.getBadge(this.getDimension())).append(" ");
        }
        if (this.name != null) {
            msg.append(((CTxT)CTxT.of(this.name).color(this.color == null ? "#ffffff" : this.color)).hover(CTxT.of(this.getXYZ())));
        } else {
            msg.append(CTxT.of(this.getXYZ()));
        }
        return msg;
    }

    public CTxT getNamelessBadge() {
        CTxT msg = CTxT.of("");
        msg.append(Dimension.getBadge(this.getDimension())).append(" ");
        msg.append(CTxT.of(this.getXYZ()).hover((CTxT)CTxT.of(this.name).color(this.color == null ? "#ffffff" : this.color)));
        return msg;
    }

    @Override
    public String toCMD() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(Helper.Command.Suggester.wrapQuotes(this.name)).append(" ");
        }
        sb.append(super.toCMD());
        if (this.color != null) {
            sb.append(" ").append(Helper.Command.Suggester.wrapQuotes(this.color));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return Helper.getGson().toJson((Object)this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dest dest2 = (Dest)o;
        return Objects.equals(this.name, dest2.name) && Objects.equals(this.color, dest2.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.color);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color2) {
        this.color = color2;
    }
}

