/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.BaseModuleAdapter;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingAdapterFactory;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;
import org.apache.commons.text.similarity.FuzzyScore;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;

public class Helper {
    public static final int MAX_NAME = 16;

    public static Utl.CheckEnabled checkEnabled(Player player) {
        return new Utl.CheckEnabled(player);
    }

    public static String createID() {
        String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            int randomIndex = random.nextInt(CHARS.length());
            char randomChar = CHARS.charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    public static String[] trimStart(String[] arr, int numToRemove) {
        if (numToRemove > arr.length) {
            return new String[0];
        }
        String[] result = new String[arr.length - numToRemove];
        System.arraycopy(arr, numToRemove, result, 0, result.length);
        return result;
    }

    public static <T> void removeDuplicateSubclasses(ArrayList<T> list) {
        HashSet seenClasses = new HashSet();
        list.removeIf(item -> item == null || !seenClasses.add(item.getClass()));
    }

    public static <T> void moveTo(ArrayList<T> list, int currentIndex, int targetIndex) {
        if (currentIndex < 0 || currentIndex >= list.size()) {
            throw new IndexOutOfBoundsException("Current index is out of bounds.");
        }
        T element = list.remove(currentIndex);
        if (targetIndex >= list.size()) {
            list.add(element);
        } else {
            list.add(targetIndex, element);
        }
    }

    public static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(BaseModule.class, (Object)new BaseModuleAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new ModuleSettingAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new LenientTypeAdapterFactory()).disableHtmlEscaping().setPrettyPrinting().create();
    }

    public static class LenientTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, final TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    try {
                        return delegate.read(in);
                    }
                    catch (Exception e) {
                        in.skipValue();
                        Class rawType = type.getRawType();
                        if (List.class.isAssignableFrom(rawType)) {
                            return new ArrayList();
                        }
                        if (Map.class.isAssignableFrom(rawType)) {
                            return new HashMap();
                        }
                        try {
                            Constructor ctor = rawType.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            return ctor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                }
            };
        }
    }

    public static class ListPage<T> {
        private final ArrayList<T> list;
        private final int perPage;

        public ListPage(ArrayList<T> list, int perPage) {
            this.list = list;
            this.perPage = perPage;
        }

        public int getTotalPages() {
            return Math.max(1, (int)Math.ceil((double)this.list.size() / (double)this.perPage));
        }

        public ArrayList<T> getList() {
            return this.list;
        }

        public int getPageOf(T item) {
            return this.getPageOf(this.getIndexOf(item));
        }

        public int getPageOf(int index) {
            return (int)Math.ceil((double)(index + 1) / (double)this.perPage);
        }

        public int getIndexOf(T item) {
            return this.list.indexOf(item);
        }

        public ArrayList<T> getPage(int page) {
            int max = this.getTotalPages();
            if (max < page) {
                page = max;
            }
            if (page <= 0) {
                page = 1;
            }
            ArrayList<T> pageList = new ArrayList<T>();
            for (int i = 0; i < this.perPage; ++i) {
                int index = (page - 1) * this.perPage + i;
                if (this.list.size() <= index) continue;
                pageList.add(this.list.get(index));
            }
            return pageList;
        }

        public CTxT getNavButtons(int page, String command) {
            int max = this.getTotalPages();
            if (page > max) {
                page = max;
            }
            if (page < 2) {
                page = 1;
            }
            CTxT left = CTxT.of("");
            CTxT right = CTxT.of("");
            if (page == 1) {
                left.append((CTxT)((CTxT)CTxT.of("<<").btn(true)).color('7'));
            } else {
                left.append((CTxT)((CTxT)((CTxT)CTxT.of("<<").btn(true)).color(CUtl.s())).click(1, command + (page - 1)));
            }
            if (page == max) {
                right.append((CTxT)((CTxT)CTxT.of(">>").btn(true)).color('7'));
            } else {
                right.append((CTxT)((CTxT)((CTxT)CTxT.of(">>").btn(true)).color(CUtl.s())).click(1, command + (page + 1)));
            }
            return CTxT.of("").append(left).append(" ").append(((CTxT)((CTxT)((CTxT)CTxT.of(String.valueOf(page)).btn(true)).color(CUtl.p())).click(2, command)).hover((CTxT)CUtl.LANG.hover("page_set", new Object[0]).color(CUtl.p()))).append(" ").append(right);
        }
    }

    public record ColorPreset(String name, String color) {
        @Override
        public String toString() {
            return "(" + this.name + ": " + this.color + ")";
        }
    }

    public record Pair<A, B>(A key, B value) {
        @Override
        public String toString() {
            return "(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")";
        }

        public Pair<B, A> getFlipped() {
            return new Pair<B, A>(this.value, this.key);
        }
    }

    public static class Command {
        public static String[] removeTo(String[] target, String ... keywords) {
            String keyword;
            String[] args = target;
            String targetString = String.join((CharSequence)" ", target);
            int index = -1;
            String[] stringArray = keywords;
            int n = stringArray.length;
            for (int i = 0; i < n && (index = targetString.indexOf(keyword = stringArray[i])) == -1; ++i) {
            }
            if (index != -1) {
                targetString = targetString.substring(index).trim();
                args = targetString.split(" ");
                args = Helper.trimStart(args, 1);
            }
            return args;
        }

        public static String[] quoteHandler(String[] args) {
            boolean quote = false;
            ArrayList<String> output = new ArrayList<String>();
            StringBuilder addBuffer = new StringBuilder();
            for (String s : args) {
                if (s.contains("\"")) {
                    int count = s.length() - s.replaceAll("\"", "").length();
                    s = s.replace("\"", "");
                    if (quote) {
                        quote = false;
                        addBuffer.append(" ").append(s);
                    } else {
                        if (count == 1) {
                            quote = true;
                            addBuffer.append(s);
                            continue;
                        }
                        addBuffer.append(s);
                    }
                } else {
                    if (quote) {
                        addBuffer.append(" ").append(s);
                        continue;
                    }
                    addBuffer.append(s);
                }
                output.add(addBuffer.toString());
                addBuffer.setLength(0);
            }
            if (!addBuffer.isEmpty()) {
                output.add(addBuffer.toString());
            }
            String[] arr = new String[output.size()];
            return output.toArray(arr);
        }

        public static class Suggester {
            public static <T> ArrayList<String> wrapQuotes(List<T> list) {
                ArrayList<String> output = new ArrayList<String>();
                for (T entry : list) {
                    output.add(Suggester.wrapQuotes(entry));
                }
                return output;
            }

            public static String wrapQuotes(Object obj) {
                return "\"" + String.valueOf(obj) + "\"";
            }

            public static String getCurrent(String[] args, int pos) {
                if (args.length == pos + 1) {
                    return args[pos];
                }
                return "";
            }

            public static ArrayList<String> xyz(Player player, String current, int type) {
                ArrayList<String> list = new ArrayList<String>();
                Vec vec = player.getVec();
                if (type == 3) {
                    list.add(String.valueOf(vec.getBlockX()));
                    list.add(vec.getBlockX() + " " + vec.getBlockZ());
                    list.add(vec.getBlockX() + " " + vec.getBlockY() + " " + vec.getBlockZ());
                } else if (type == 2) {
                    list.add(String.valueOf(vec.getBlockY()));
                    list.add(vec.getBlockY() + " " + vec.getBlockZ());
                } else if (type == 1) {
                    list.add(String.valueOf(vec.getBlockZ()));
                }
                if (current.isEmpty() || list.get(0).startsWith(current)) {
                    return list;
                }
                return new ArrayList<String>();
            }

            public static ArrayList<String> players(Player player) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player entry : Utl.getPlayers()) {
                    if (entry.equals(player)) continue;
                    list.add(entry.getName());
                }
                return list;
            }

            public static ArrayList<String> dims(String current, boolean displayEmpty) {
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> dimList = Suggester.wrapQuotes(Dimension.getAllIDs());
                if (!current.isEmpty() || displayEmpty) {
                    if (current.isEmpty()) {
                        return dimList;
                    }
                    for (String dim2 : dimList) {
                        if (!dim2.contains(current)) continue;
                        list.add(dim2);
                    }
                }
                return list;
            }

            public static ArrayList<String> colors(Player player, String current, boolean displayEmpty) {
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> presets = new ArrayList<String>();
                for (String name : DHud.preset.custom.getNames(player.getPData().getColorPresets())) {
                    presets.add(String.format("\"preset-%s\"", name));
                }
                if (!current.isEmpty() || displayEmpty) {
                    list.add("ffffff");
                    if (!presets.isEmpty() && Helper.checkEnabled(player).customPresets()) {
                        list.add("preset");
                        if (current.startsWith("pre")) {
                            list.addAll(presets);
                            return list;
                        }
                    }
                    list.add("red");
                    list.add("orange");
                    list.add("yellow");
                    list.add("green");
                    list.add("blue");
                    list.add("purple");
                    list.add("gray");
                }
                return list;
            }

            public static ArrayList<String> filter(ArrayList<String> suggestions, String current) {
                if (current.equalsIgnoreCase("")) {
                    return suggestions;
                }
                if (current.isEmpty()) {
                    return suggestions;
                }
                ArrayList<String> filtered = new ArrayList<String>();
                FuzzyScore fuzzyScore = new FuzzyScore(Locale.ENGLISH);
                double minimumScore = (double)current.length() * 1.5;
                if (current.length() == 1) {
                    minimumScore = 1.0;
                }
                for (String s : suggestions) {
                    int score = fuzzyScore.fuzzyScore((CharSequence)s.toLowerCase(), (CharSequence)current.toLowerCase());
                    if (!((double)score >= minimumScore)) continue;
                    filtered.add(s);
                }
                if (!suggestions.isEmpty() && filtered.isEmpty()) {
                    JaroWinklerSimilarity similarity = new JaroWinklerSimilarity();
                    float minSimilarity = 0.65f;
                    for (String s : suggestions) {
                        if (!(similarity.apply((CharSequence)current, (CharSequence)s) > (double)minSimilarity)) continue;
                        filtered.add(s);
                    }
                }
                return filtered;
            }
        }
    }

    public static class Num {
        public static boolean isInt(String string) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }

        public static Integer toInt(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                try {
                    return (int)Double.parseDouble(s);
                }
                catch (NumberFormatException e2) {
                    return 0;
                }
            }
        }

        public static boolean isNum(String s) {
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e1) {
                try {
                    Double.parseDouble(s);
                    return true;
                }
                catch (NumberFormatException e2) {
                    return false;
                }
            }
        }

        public static boolean inBetween(double num, double min, double max) {
            if (min > max) {
                return num >= min || num <= max;
            }
            return num >= min && num <= max;
        }

        public static double wSubtract(double num, double sub, double max) {
            double output = num - sub;
            if (output < 0.0) {
                output = max - output * -1.0;
            }
            return output;
        }

        public static double wAdd(double num, double add, double max) {
            return (num + add) % max;
        }

        public static String formatToXDigits(int number, int digits) {
            String result = "0".repeat(Math.max(0, digits - 1)) + number;
            return result.substring(result.length() - digits);
        }

        public static String formatToTwoDigits(int number) {
            return Num.formatToXDigits(number, 2);
        }
    }

    public static class Enums {
        public static <T extends Enum<T>> ArrayList<String> toStringList(ArrayList<T> enumList) {
            return (ArrayList)enumList.stream().map(Enum::name).collect(Collectors.toList());
        }

        public static <T extends Enum<T>> ArrayList<String> toStringList(T[] enumArray) {
            return Enums.toStringList(new ArrayList<T>(List.of(enumArray)));
        }

        public static <T extends Enum<T>> ArrayList<T> toEnumList(ArrayList<String> stringList, Class<T> enumType) {
            return Enums.toEnumList(Enum::valueOf, stringList, enumType);
        }

        public static <T extends Enum<T>> ArrayList<T> toEnumList(BiFunction<Class<T>, String, T> function, ArrayList<String> stringList, Class<T> enumType) {
            ArrayList<Enum> moduleList = new ArrayList<Enum>();
            for (String module : stringList) {
                try {
                    Enum enumValue = (Enum)function.apply(enumType, module);
                    moduleList.add(enumValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return moduleList;
        }

        @SafeVarargs
        public static <T extends Enum<T>> T next(T current, Class<T> enumType, T ... exclude) {
            Enum[] values = (Enum[])enumType.getEnumConstants();
            Enum next = values[(current.ordinal() + 1) % values.length];
            if (exclude != null && Arrays.asList(exclude).contains(next)) {
                return (T)Enums.next((Enum)next, enumType, exclude);
            }
            return (T)next;
        }

        public static <T extends Enum<T>> T get(Object enumString, Class<T> enumType) {
            Enum[] values = (Enum[])enumType.getEnumConstants();
            return (T)Enums.search(enumString, enumType).orElse(values[0]);
        }

        public static <T extends Enum<T>> Optional<T> search(Object enumString, Class<T> enumType) {
            Enum[] values = (Enum[])enumType.getEnumConstants();
            return Arrays.stream(values).filter(entry -> entry.toString().equalsIgnoreCase(enumString.toString())).findFirst();
        }

        public static <T extends Enum<T>> boolean contains(Object enumString, Class<T> enumType) {
            return Enums.search(enumString, enumType).isPresent();
        }
    }
}

