/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;

public class Loc {
    private Integer x = null;
    private Integer y = null;
    private Integer z = null;
    private String dimension = null;

    public Loc() {
    }

    public Loc(Loc loc) {
        this.copyFrom(loc);
    }

    public void copyFrom(Loc loc) {
        this.x = loc.getX();
        this.y = loc.getY();
        this.z = loc.getZ();
        this.dimension = loc.getDimension();
    }

    public Loc(Integer x, Integer y, Integer z, String dimension) {
        this.x = this.xzBounds(x);
        this.y = this.yBounds(y);
        this.z = this.xzBounds(z);
        if (Dimension.checkValid(dimension)) {
            this.dimension = dimension;
        }
    }

    public Loc(Integer x, Integer y, Integer z) {
        this.x = this.xzBounds(x);
        this.y = this.yBounds(y);
        this.z = this.xzBounds(z);
    }

    public Loc(Integer x, Integer z, String dimension) {
        this.x = this.xzBounds(x);
        this.z = this.xzBounds(z);
        if (Dimension.checkValid(dimension)) {
            this.dimension = dimension;
        }
    }

    public Loc(Integer x, Integer z) {
        this.x = this.xzBounds(x);
        this.z = this.xzBounds(z);
    }

    public Loc(boolean legacy2, String xyz) {
        if (xyz == null || xyz.equals("null")) {
            return;
        }
        if (xyz.charAt(0) == '{' && xyz.charAt(xyz.length() - 1) == '}') {
            this.copyFrom(new Loc(xyz));
            return;
        }
        if (xyz.charAt(0) == '[' && xyz.charAt(xyz.length() - 1) == ']') {
            String[] list = xyz.substring(1, xyz.length() - 1).split(", ");
            if (list.length >= 3) {
                this.x = Helper.Num.toInt(list[0]);
                if (list[1] != null && !list[1].equals("null")) {
                    this.y = Helper.Num.toInt(list[1]);
                }
                this.z = Helper.Num.toInt(list[2]);
            }
            if (list.length == 4) {
                this.dimension = Utl.dim.updateLegacy(list[3]);
            }
            return;
        }
        ArrayList<String> sp = new ArrayList<String>(Arrays.asList(xyz.split(" ")));
        if (sp.isEmpty()) {
            return;
        }
        if (sp.size() == 1) {
            this.x = 0;
            this.z = 0;
            return;
        }
        if (!Helper.Num.isInt(sp.get(0))) {
            sp.set(0, "0");
        }
        if (!Helper.Num.isInt(sp.get(1))) {
            sp.set(1, "0");
        }
        if (sp.size() == 3 && !Helper.Num.isNum(sp.get(2))) {
            sp.set(2, "0");
        }
        this.x = this.xzBounds(Helper.Num.toInt(sp.get(0)));
        if (sp.size() == 2) {
            this.z = this.xzBounds(Helper.Num.toInt(sp.get(1)));
            return;
        }
        this.y = this.yBounds(Helper.Num.toInt(sp.get(1)));
        this.z = this.xzBounds(Helper.Num.toInt(sp.get(2)));
    }

    public Loc(String loc) {
        if (loc.equals("null") || !loc.contains("{")) {
            return;
        }
        Gson gson = new Gson();
        Loc data = (Loc)gson.fromJson(loc, Loc.class);
        this.x = data.x;
        this.y = data.y;
        this.z = data.z;
        this.dimension = data.dimension;
    }

    public Loc(Player player) {
        Vec vec = player.getVec();
        this.x = this.xzBounds(vec.getBlockX());
        this.y = this.yBounds(vec.getBlockY());
        this.z = this.xzBounds(vec.getBlockZ());
        this.dimension = player.getDimension();
    }

    private Integer yBounds(Integer s) {
        if (s == null) {
            return null;
        }
        if (s > FileData.getConfig().getLocation().getMaxY()) {
            return FileData.getConfig().getLocation().getMaxY();
        }
        return Math.max(s, FileData.getConfig().getLocation().getMaxY() * -1);
    }

    private Integer xzBounds(Integer s) {
        if (s == null) {
            return null;
        }
        if (s > FileData.getConfig().getLocation().getMaxXZ()) {
            return FileData.getConfig().getLocation().getMaxXZ();
        }
        return Math.max(s, FileData.getConfig().getLocation().getMaxXZ() * -1);
    }

    public void convertTo(String toDimension) {
        String fromDimension = this.getDimension();
        if (fromDimension.equalsIgnoreCase(toDimension)) {
            return;
        }
        if (!Dimension.checkValid(toDimension)) {
            return;
        }
        Double ratio = Dimension.getRatio(fromDimension, toDimension);
        this.setDimension(toDimension);
        this.setX((int)((double)this.getX().intValue() * ratio));
        this.setZ((int)((double)this.getZ().intValue() * ratio));
    }

    public boolean hasXYZ() {
        return this.getXYZ() != null;
    }

    public String getXYZ() {
        if (this.x == null || this.z == null) {
            return null;
        }
        if (this.y == null) {
            return this.x + " " + this.z;
        }
        return this.x + " " + this.y + " " + this.z;
    }

    public boolean hasY() {
        return this.y != null;
    }

    public boolean isValid() {
        return this.hasXYZ() && this.dimension != null;
    }

    public Vec getVec(Player player) {
        Integer i = this.y;
        if (i == null) {
            i = player.getVec().getBlockY();
        }
        if (this.x != null && this.z != null) {
            return new Vec((double)this.x.intValue() + 0.5, (double)i.intValue() + 0.5, (double)this.z.intValue() + 0.5);
        }
        return new Vec();
    }

    public CTxT getBadge() {
        CTxT msg = CTxT.of("");
        if (this.dimension != null) {
            msg.append(Dimension.getBadge(this.getDimension())).append(" ");
        }
        return msg.append((CTxT)CTxT.of(this.getXYZ()).color('f'));
    }

    public String toCMD() {
        if (!this.isValid()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.x).append(" ");
        if (this.y != null) {
            sb.append(this.y).append(" ");
        }
        sb.append(this.z).append(" ");
        sb.append(Helper.Command.Suggester.wrapQuotes(this.dimension));
        return sb.toString();
    }

    public String toString() {
        return Helper.getGson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Loc loc = (Loc)o;
        return Objects.equals(this.x, loc.x) && Objects.equals(this.y, loc.y) && Objects.equals(this.z, loc.z) && Objects.equals(this.dimension, loc.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.dimension);
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Integer getZ() {
        return this.z;
    }

    public void setZ(Integer z) {
        this.z = z;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        if (Dimension.checkValid(dimension)) {
            this.dimension = dimension;
        }
    }
}

