/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.template.PlayerTemplate;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.common.utils.ParticleType;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.packet.PacketSender;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Utl;

public class Player
extends PlayerTemplate {
    private final class_1657 player;
    private final class_3222 serverPlayer;
    private final boolean client;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.player, other.player);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }

    public Player() {
        this.player = null;
        this.serverPlayer = null;
        this.client = false;
    }

    public Player(class_1657 playerEntity, boolean cpl) {
        this.player = playerEntity;
        this.serverPlayer = null;
        this.client = cpl;
    }

    public Player(class_3222 serverPlayerEntity) {
        this.player = serverPlayerEntity;
        this.serverPlayer = serverPlayerEntity;
        this.client = false;
    }

    public Player(String identifier) {
        class_3324 playerManager = DirectionHUD.getData().getServer().method_3760();
        this.serverPlayer = identifier.contains("-") ? playerManager.method_14602(UUID.fromString(identifier)) : playerManager.method_14566(identifier);
        this.player = this.serverPlayer;
        this.client = false;
    }

    @Override
    public boolean isValid() {
        return this.serverPlayer != null;
    }

    @Override
    public void performCommand(String cmd) {
        try {
            CommandDispatcher dispatcher = DirectionHUD.getData().getCommandManager().method_9235();
            ParseResults parse = dispatcher.parse(cmd, (Object)this.serverPlayer.method_64396());
            dispatcher.execute(parse);
        }
        catch (CommandSyntaxException e) {
            DirectionHUD.LOGGER.info("ERROR EXECUTING COMMAND - PLEASE REPORT WITH THE ERROR LOG");
            DirectionHUD.LOGGER.info(e.getMessage());
        }
    }

    @Override
    public void sendMessage(CTxT message) {
        this.player.method_7353((class_2561)message.b(), false);
    }

    @Override
    public void sendActionBar(CTxT message) {
        this.player.method_7353((class_2561)message.b(), true);
    }

    @Override
    public void displayBossBar(CTxT message) {
        DirectionHUD.getData().getBossBarManager().display(this, message);
    }

    @Override
    public void removeBossBar() {
        DirectionHUD.getData().getBossBarManager().removePlayer(this);
    }

    @Override
    public PData getPData() {
        return PlayerData.getPData(this);
    }

    @Override
    public CachedPData getPCache() {
        return PlayerData.getPCache(this);
    }

    @Override
    public void sendPDataPackets() {
        if (DirectionHUD.getData().getClientPlayers().contains(this) && !this.client) {
            new PacketSender(Assets.packets.PLAYER_DATA, Helper.getGson().toJson((Object)this.getPData())).sendToPlayer(this.serverPlayer);
        }
    }

    @Override
    public void sendHUDPackets(ModuleInstructions instructions) {
        if (this.client) {
            return;
        }
        new PacketSender(Assets.packets.HUD, Helper.getGson().toJson((Object)instructions)).sendToPlayer(this.serverPlayer);
    }

    @Override
    public String getName() {
        return this.player.method_5477().getString();
    }

    public class_3222 getPlayer() {
        return this.serverPlayer;
    }

    @Override
    public String getUUID() {
        return this.player.method_5845();
    }

    @Override
    public String getDimension() {
        return Utl.dim.format((class_5321<class_1937>)this.player.method_73183().method_27983());
    }

    @Override
    public int getTimeOfDay() {
        return (int)this.player.method_73183().method_8532() % 24000;
    }

    @Override
    public long getWorldTime() {
        return this.player.method_73183().method_8510();
    }

    @Override
    public boolean hasStorm() {
        return this.player.method_73183().method_8419();
    }

    @Override
    public boolean hasThunderstorm() {
        return this.player.method_73183().method_8546();
    }

    @Override
    public String getSpawnDimension() {
        if (this.client) {
            return null;
        }
        class_3222.class_10766 respawn = this.serverPlayer.method_67564();
        if (respawn == null) {
            return Utl.dim.format((class_5321<class_1937>)class_1937.field_25179);
        }
        return Utl.dim.format((class_5321<class_1937>)respawn.comp_4913().method_74894());
    }

    @Override
    public float getYaw() {
        return this.player.method_36454();
    }

    @Override
    public float getPitch() {
        return this.player.method_36455();
    }

    @Override
    public int[] getLightLevels(boolean lookTarget) {
        class_2338 pos = this.player.method_24515();
        if (lookTarget && (pos = Utl.getSideOfBlockPosPlayerIsLookingAt(this.serverPlayer, Utl.getPlayerReach(this.player))) == null) {
            return new int[]{-1, -1};
        }
        return new int[]{this.player.method_73183().method_8314(class_1944.field_9284, pos), this.player.method_73183().method_8314(class_1944.field_9282, pos)};
    }

    @Override
    public Vec getVec() {
        return new Vec(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
    }

    @Override
    public Loc getLoc() {
        if (this.player == null) {
            return new Loc();
        }
        return new Loc(this);
    }

    public class_2390 getParticle(ParticleType particleType) {
        String color2;
        return new class_2390(Color.decode(CUtl.color.format(color2)).getRGB(), switch (particleType) {
            case ParticleType.DEST -> {
                color2 = this.getPCache().getDEST().getDestSettings().getParticles().getDestColor();
                yield 3.0f;
            }
            case ParticleType.LINE -> {
                color2 = this.getPCache().getDEST().getDestSettings().getParticles().getLineColor();
                yield 1.0f;
            }
            case ParticleType.TRACKING -> {
                color2 = this.getPCache().getDEST().getDestSettings().getParticles().getTrackingColor();
                yield 0.5f;
            }
            default -> {
                color2 = "#000000";
                yield 1.0f;
            }
        });
    }

    @Override
    public void spawnParticle(ParticleType particleType, Vec position) {
        this.serverPlayer.method_51469().method_14166(this.serverPlayer, (class_2394)this.getParticle(particleType), true, true, position.getX(), position.getY(), position.getZ(), 1, 0.0, 0.0, 0.0, 1.0);
    }
}

