/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleLight;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;

public class Events {
    public static void init() {
        List<ModuleLight> modules2 = List.of(new ModuleAngle(), new ModuleCoordinates(), new ModuleDestination(), new ModuleDirection(), new ModuleDistance(), new ModuleSpeed(), new ModuleTime(), new ModuleTracking(), new ModuleWeather(), new ModuleLight());
        modules2.forEach(bm -> DisplayRegistry.registerModuleDisplay(bm.getModuleType(), bm.getDisplaySettings()));
    }

    public static void serverStart() {
        DirectionHUD.getData().setServerStarted(true);
        try {
            Files.createDirectories(Paths.get(DirectionHUD.getData().getDataDirectory() + "playerdata/", new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            DirectionHUD.LOGGER.info("Failed to create playerdata directory.");
        }
        FileData.loadFiles();
        DirectionHUD.LOGGER.info("Started server!");
    }

    public static void serverEnd() {
        for (Player player : Utl.getPlayers()) {
            Events.playerLeave(player);
        }
        FileData.clearServerData();
        PlayerData.clearPlayerData();
        PlayerData.clearPlayerCache();
        DirectionHUD.getData().clear();
        DirectionHUD.LOGGER.info("Safely shutdown DirectionHUD server!");
    }

    public static void playerJoin(Player player) {
        PlayerData.addPlayer(player);
        if (player.getPCache().getHud().getSetting().getType().equals(Hud.Setting.DisplayType.bossbar.toString())) {
            DirectionHUD.getData().getBossBarManager().addPlayer(player);
        }
    }

    public static void playerLeave(Player player) {
        Events.playerSoftLeave(player);
        DirectionHUD.getData().getClientPlayers().remove(player);
    }

    public static void playerSoftLeave(Player player) {
        DHud.inbox.removeAllTracking(player);
        PlayerData.removePlayer(player);
        DirectionHUD.getData().getBossBarManager().removePlayer(player);
    }

    public static void playerChangeWorld(Player player, String fromDIM, String toDIM) {
        if (Destination.dest.get(player).hasXYZ()) {
            Dest loc = Destination.dest.get(player);
            if (toDIM.equals(loc.getDimension())) {
                return;
            }
            if (Dimension.canConvert(toDIM, loc.getDimension()) && ((Boolean)player.getPData().getDEST().getSetting(Destination.Setting.autoconvert)).booleanValue()) {
                Dest dest2 = Destination.dest.get(player);
                dest2.convertTo(toDIM);
                Destination.dest.set(player, dest2);
                player.sendMessage(CUtl.tag().append(Destination.LANG.msg("autoconvert.destination", CTxT.of("\n ").append(Destination.LANG.msg("autoconvert.destination.2", ((Loc)loc).getBadge(), dest2.getBadge())))));
            } else if (((Boolean)player.getPData().getDEST().getSetting(Destination.Setting.autoclear)).booleanValue()) {
                Destination.dest.clear(player, 3);
            }
        }
    }

    public static void playerDeath(Player player, Loc deathLoc) {
        if (!Helper.checkEnabled(player).lastdeath()) {
            return;
        }
        Destination.lastdeath.add(player, deathLoc);
        CTxT msg = CUtl.tag().append(Destination.lastdeath.LANG.msg("save", deathLoc.getBadge().append(" ").append(Destination.dest.setButtons(new Dest(deathLoc, null, null), Dimension.canConvert(player.getSpawnDimension(), deathLoc.getDimension())))));
        player.sendMessage(msg);
    }
}

