/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.template.CustomFile;
import one.oth3r.directionhud.common.utils.Helper;
import org.jetbrains.annotations.NotNull;

public class ModuleText
implements CustomFile<ModuleText> {
    @SerializedName(value="version")
    private Double version = 1.1;
    @SerializedName(value="load-missing")
    private Boolean loadMissing = false;
    @SerializedName(value="modules")
    private Map<Module, DisplaySettings> modules = new HashMap<Module, DisplaySettings>();

    @Override
    public void reset() {
        this.copyFileData(new ModuleText());
    }

    @Override
    @NotNull
    public Class<ModuleText> getFileClass() {
        return ModuleText.class;
    }

    @Override
    public void copyFileData(ModuleText newFile) {
        this.version = newFile.version;
        this.loadMissing = newFile.loadMissing;
        this.modules = newFile.modules;
    }

    @Override
    public JsonElement updateJSON(JsonElement json) {
        Gson gson = Helper.getGson();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject == null) {
            return json;
        }
        double version = jsonObject.get("version").getAsDouble();
        if (version == 1.0) {
            String brokenDestinationName = "&2[&1%s&2]";
            String fixedDestinationName = new ModuleDestination().getDisplaySettings().getDisplay("name");
            JsonObject destination = jsonObject.getAsJsonObject("destination");
            if (destination.getAsJsonPrimitive("name").getAsString().equals("&2[&1%s&2]")) {
                destination.addProperty("name", fixedDestinationName);
            }
            if (destination.getAsJsonPrimitive("name_xz").getAsString().equals("&2[&1%s&2]")) {
                destination.addProperty("name_xz", fixedDestinationName);
            }
            jsonObject.addProperty("version", (Number)1.01);
        }
        if (jsonObject.getAsJsonPrimitive("version").getAsDouble() < 1.1) {
            String[] moduleStrings;
            JsonElement newJson = gson.toJsonTree((Object)new ModuleText());
            JsonObject modules2 = newJson.getAsJsonObject().getAsJsonObject("modules");
            JsonObject registeredModuleList = gson.toJsonTree(DisplayRegistry.getModules()).getAsJsonObject();
            for (String moduleString : moduleStrings = new String[]{"coordinates", "destination", "distance", "tracking", "direction", "weather", "time", "angle", "speed"}) {
                JsonObject moduleObject = new JsonObject();
                JsonObject oldModule = jsonObject.getAsJsonObject(moduleString);
                JsonObject registeredModule = registeredModuleList.getAsJsonObject(moduleString);
                JsonObject displays = new JsonObject();
                JsonObject assets = new JsonObject();
                switch (moduleString) {
                    case "coordinates": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"xyz", "xz"});
                        break;
                    }
                    case "destination": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"xyz", "xz", "name", "name_xz"});
                        break;
                    }
                    case "distance": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"number"});
                        break;
                    }
                    case "tracking": {
                        DynamicUpdater.handleModuleWithAssets(registeredModule, oldModule, displays, assets, new String[]{"tracking", "elevation_tracking"}, new String[]{"simple", "compact", "elevation"});
                        break;
                    }
                    case "direction": {
                        DynamicUpdater.handleModuleWithAssets(registeredModule, oldModule, displays, assets, new String[]{"facing"}, new String[]{"cardinal"});
                        break;
                    }
                    case "weather": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"weather", "weather_single"});
                        break;
                    }
                    case "time": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"hour_AM", "hour_PM", "hour_24"});
                        break;
                    }
                    case "angle": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"yaw", "pitch", "both"});
                        break;
                    }
                    case "speed": {
                        DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, new String[]{"xz_speed", "xyz_speed"});
                    }
                }
                if (displays.isEmpty() && assets.isEmpty()) continue;
                if (!displays.isEmpty()) {
                    moduleObject.add("displays", (JsonElement)displays);
                }
                if (!assets.isEmpty()) {
                    moduleObject.add("assets", (JsonElement)assets);
                }
                modules2.add(moduleString, (JsonElement)moduleObject);
            }
            json = newJson;
        }
        return json;
    }

    @Override
    public void updateFileInstance() {
        DisplayRegistry.updateModules(this.modules);
        if (this.loadMissing.booleanValue()) {
            this.modules = DisplayRegistry.getModules();
            this.save();
        }
    }

    @Override
    public String getFileName() {
        return "module-text.json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getConfigDirectory();
    }

    private static class DynamicUpdater {
        private DynamicUpdater() {
        }

        private static void handleSimpleUpdate(JsonObject registeredModule, JsonObject oldModule, JsonObject displays, String[] displayStrings) {
            registeredModule = registeredModule.getAsJsonObject("displays");
            for (String key : displayStrings) {
                String oldString = oldModule.get(key).getAsString();
                if (registeredModule.get(key).getAsString().equals(oldString)) {
                    return;
                }
                displays.addProperty(key, oldString);
            }
        }

        private static void handleModuleWithAssets(JsonObject registeredModule, JsonObject oldModule, JsonObject displays, JsonObject assets, String[] displayStrings, String[] assetStrings) {
            DynamicUpdater.handleSimpleUpdate(registeredModule, oldModule, displays, displayStrings);
            JsonObject registeredAssets = registeredModule.getAsJsonObject("assets");
            JsonObject oldAssets = oldModule.get("assets").getAsJsonObject();
            for (String key : assetStrings) {
                JsonObject assetObject = oldAssets.getAsJsonObject(key);
                if (registeredAssets.getAsJsonObject(key).equals((Object)assetObject)) {
                    return;
                }
                assets.add(key, (JsonElement)assetObject);
            }
        }
    }
}

