/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.dimension;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.stream.Collectors;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.files.dimension.DimensionEntry;
import one.oth3r.directionhud.common.files.dimension.RatioEntry;
import one.oth3r.directionhud.common.template.CustomFile;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.utils.Utl;
import org.jetbrains.annotations.NotNull;

public class DimensionSettings
implements CustomFile<DimensionSettings> {
    @SerializedName(value="version")
    private Double version = 1.0;
    @SerializedName(value="dimensions")
    private ArrayList<DimensionEntry> dimensions = Utl.dim.DEFAULT_DIMENSIONS;
    @SerializedName(value="ratios")
    private ArrayList<RatioEntry> ratios = Utl.dim.DEFAULT_RATIOS;

    public DimensionSettings() {
    }

    public DimensionSettings(DimensionSettings dimensionSettings) {
        this.copyFileData(dimensionSettings);
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public ArrayList<DimensionEntry> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(ArrayList<DimensionEntry> dimensions) {
        this.dimensions = dimensions;
    }

    public ArrayList<RatioEntry> getRatios() {
        return this.ratios;
    }

    public void setRatios(ArrayList<RatioEntry> ratios) {
        this.ratios = ratios;
    }

    @Override
    @NotNull
    public Class<DimensionSettings> getFileClass() {
        return DimensionSettings.class;
    }

    @Override
    public void copyFileData(DimensionSettings newFile) {
        this.version = newFile.version;
        this.dimensions = newFile.dimensions.stream().map(DimensionEntry::new).collect(Collectors.toCollection(ArrayList::new));
        this.ratios = newFile.ratios.stream().map(RatioEntry::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public JsonElement updateJSON(JsonElement json) {
        Gson gson = Helper.getGson();
        if (json.isJsonNull()) {
            return gson.toJsonTree((Object)new DimensionSettings());
        }
        return json;
    }

    @Override
    public void updateFileInstance() {
        Utl.dim.addMissing(this.dimensions);
    }

    @Override
    public String getFileName() {
        return "dimension-settings.json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getConfigDirectory();
    }

    @Override
    public void reset() {
        this.copyFileData(new DimensionSettings());
    }
}

