/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.files.playerdata.PDDestination;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.ModuleManager;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.Helper;

public abstract class BasePData {
    @SerializedName(value="version")
    protected Double version = 2.2;
    @SerializedName(value="hud")
    protected PDHud hud = new PDHud();
    @SerializedName(value="destination")
    protected PDDestination destination = new PDDestination();
    @SerializedName(value="color_presets")
    protected ArrayList<Helper.ColorPreset> colorPresets = new ArrayList();

    public BasePData() {
    }

    public BasePData(BasePData newFile) {
        this.copyBaseFileData(newFile);
    }

    protected void copyBaseFileData(BasePData newFile) {
        this.version = newFile.version;
        this.hud = new PDHud(newFile.hud);
        this.destination = new PDDestination(newFile.destination);
        this.colorPresets = newFile.colorPresets.stream().map(record -> new Helper.ColorPreset(record.name(), record.color())).collect(Collectors.toCollection(ArrayList::new));
    }

    public PDHud getHud() {
        return this.hud;
    }

    public PDDestination getDEST() {
        return this.destination;
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public ArrayList<Helper.ColorPreset> getColorPresets() {
        return this.colorPresets;
    }

    public void setColorPresets(ArrayList<Helper.ColorPreset> colorPresets) {
        this.colorPresets = colorPresets;
    }

    public JsonElement baseJSONUpdater(JsonElement json, boolean factoryDefault) {
        JsonArray modules2;
        JsonObject hud;
        if (json == null || json.isJsonNull()) {
            return new JsonObject().getAsJsonNull();
        }
        Gson gson = Helper.getGson();
        JsonObject jsonObj = json.getAsJsonObject();
        double version = jsonObj.getAsJsonPrimitive("version").getAsDouble();
        if (version == 2.0) {
            ArrayList<BaseModule> newModules = new ArrayList<BaseModule>();
            JsonObject hud2 = jsonObj.getAsJsonObject("hud");
            JsonArray order = hud2.getAsJsonArray("order");
            JsonObject moduleSettings = hud2.getAsJsonObject("setting").getAsJsonObject("module");
            JsonObject modules3 = hud2.getAsJsonObject("module");
            int i = 0;
            for (JsonElement element : order) {
                Module module = Module.fromString(element.getAsString());
                if (module.equals((Object)Module.UNKNOWN)) continue;
                boolean state = modules3.getAsJsonPrimitive(module.getName()).getAsBoolean();
                switch (module) {
                    case COORDINATES: {
                        newModules.add(new ModuleCoordinates(i, state, true));
                        break;
                    }
                    case DESTINATION: {
                        newModules.add(new ModuleDestination(i, state, true));
                        break;
                    }
                    case DISTANCE: {
                        newModules.add(new ModuleDistance(i, state));
                        break;
                    }
                    case TRACKING: {
                        newModules.add(new ModuleTracking(i, state, moduleSettings.getAsJsonPrimitive("tracking_hybrid").getAsBoolean(), moduleSettings.getAsJsonPrimitive("tracking_target").getAsString().equals("player") ? ModuleTracking.Target.player : ModuleTracking.Target.dest, moduleSettings.getAsJsonPrimitive("tracking_type").getAsString().equals("simple") ? ModuleTracking.Type.simple : ModuleTracking.Type.compact, false));
                        break;
                    }
                    case DIRECTION: {
                        newModules.add(new ModuleDirection(i, state));
                        break;
                    }
                    case WEATHER: {
                        newModules.add(new ModuleWeather(i, state));
                        break;
                    }
                    case TIME: {
                        newModules.add(new ModuleTime(i, state, moduleSettings.getAsJsonPrimitive("time_24hr").getAsBoolean()));
                        break;
                    }
                    case ANGLE: {
                        newModules.add(new ModuleAngle(i, state, Helper.Enums.get(moduleSettings.getAsJsonPrimitive("angle_display").getAsString(), ModuleAngle.Display.class)));
                        break;
                    }
                    case SPEED: {
                        newModules.add(new ModuleSpeed(i, state, !moduleSettings.getAsJsonPrimitive("speed_3d").getAsBoolean(), moduleSettings.getAsJsonPrimitive("speed_pattern").getAsString()));
                    }
                }
                ++i;
            }
            ModuleManager.Order.fixOrder(newModules, factoryDefault);
            hud2.add("modules", gson.toJsonTree(newModules));
            jsonObj.addProperty("version", (Number)2.3);
        }
        if (version == 2.1) {
            hud = jsonObj.getAsJsonObject("hud");
            modules2 = hud.getAsJsonArray("modules");
            ArrayList<BaseModule> newModules = new ArrayList<BaseModule>();
            for (JsonElement element : modules2) {
                JsonObject module = element.getAsJsonObject();
                String mod = module.getAsJsonPrimitive("module").getAsString();
                int order = module.getAsJsonPrimitive("order").getAsInt();
                boolean state = module.getAsJsonPrimitive("state").getAsBoolean();
                Module moduleType = Module.fromString(mod);
                if (moduleType.equals((Object)Module.UNKNOWN)) continue;
                newModules.add(switch (moduleType) {
                    case Module.COORDINATES -> {
                        boolean xyzDisplay = module.getAsJsonPrimitive("xyz-display").getAsBoolean();
                        yield new ModuleCoordinates(order, state, xyzDisplay);
                    }
                    case Module.DESTINATION -> new ModuleDestination(order, state, true);
                    case Module.DISTANCE -> new ModuleDistance(order, state);
                    case Module.TRACKING -> {
                        boolean hybrid = module.getAsJsonPrimitive("hybrid").getAsBoolean();
                        ModuleTracking.Target target = Helper.Enums.get(module.getAsJsonPrimitive("target").getAsString(), ModuleTracking.Target.class);
                        ModuleTracking.Type type = Helper.Enums.get(module.getAsJsonPrimitive("display-type").getAsString(), ModuleTracking.Type.class);
                        boolean elevation = module.getAsJsonPrimitive("show-elevation").getAsBoolean();
                        yield new ModuleTracking(order, state, hybrid, target, type, elevation);
                    }
                    case Module.DIRECTION -> new ModuleDirection(order, state);
                    case Module.WEATHER -> new ModuleWeather(order, state);
                    case Module.TIME -> {
                        boolean time24hr = module.getAsJsonPrimitive("24hr-clock").getAsBoolean();
                        yield new ModuleTime(order, state, time24hr);
                    }
                    case Module.ANGLE -> {
                        ModuleAngle.Display display = Helper.Enums.get(module.getAsJsonPrimitive("display").getAsString(), ModuleAngle.Display.class);
                        yield new ModuleAngle(order, state, display);
                    }
                    case Module.SPEED -> {
                        boolean speed2D = module.getAsJsonPrimitive("2d-calculation").getAsBoolean();
                        String speedPattern = module.getAsJsonPrimitive("display-pattern").getAsString();
                        yield new ModuleSpeed(order, state, speed2D, speedPattern);
                    }
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)moduleType));
                });
            }
            ModuleManager.Order.fixOrder(newModules, factoryDefault);
            hud.add("modules", gson.toJsonTree(newModules));
            jsonObj.addProperty("version", (Number)2.3);
        }
        if (version == 2.2) {
            hud = jsonObj.getAsJsonObject("hud");
            modules2 = hud.getAsJsonArray("modules");
            for (JsonElement element : modules2) {
                JsonObject module = element.getAsJsonObject();
                String mod = module.getAsJsonPrimitive("module").getAsString();
                Module moduleType = Module.fromString(mod);
                if (!moduleType.equals((Object)Module.DESTINATION)) continue;
                JsonArray settings2 = module.getAsJsonArray("settings");
                JsonObject showName = new JsonObject();
                showName.addProperty("id", "destination_show-name");
                showName.addProperty("value", Boolean.valueOf(true));
                settings2.add((JsonElement)showName);
            }
            jsonObj.addProperty("version", (Number)2.3);
        }
        return json;
    }
}

