/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import java.util.ArrayList;
import java.util.HashMap;
import one.oth3r.directionhud.common.files.playerdata.BasePData;
import one.oth3r.directionhud.common.files.playerdata.PDDestination;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.common.hud.HudColor;
import one.oth3r.directionhud.common.hud.HudRainbow;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Rainbow;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.utils.Player;

public class CachedPData {
    private PDHud hud;
    private CachedDestination destination;
    private final SpeedData speedData;
    private final HashMap<String, Integer> msgMap = new HashMap();
    private final HudRainbow hudRainbow;
    private Integer socialCooldown;
    private ArrayList<HashMap<String, String>> inbox;

    public CachedPData(PData pData) {
        this.hud = new PDHud(pData.getHud());
        this.destination = new CachedDestination(pData.getDEST());
        this.speedData = new SpeedData(pData.getPlayer());
        this.hudRainbow = new HudRainbow(pData.getPlayer());
        this.inbox = pData.getInbox();
        this.socialCooldown = pData.getSocialCooldown();
    }

    public void update(BasePData pData) {
        this.hud = new PDHud(pData.getHud());
        this.destination = new CachedDestination(pData.getDEST());
    }

    public PDHud getHud() {
        return this.hud;
    }

    public CachedDestination getDEST() {
        return this.destination;
    }

    public SpeedData getSpeedData() {
        return this.speedData;
    }

    public Rainbow getRainbow(HudColor color2) {
        return this.hudRainbow.select(color2);
    }

    public ArrayList<String> getMsgKeys() {
        return new ArrayList<String>(this.msgMap.keySet());
    }

    public int getMsg(String key) {
        return this.msgMap.getOrDefault(key, 0);
    }

    public void setMsg(String key, int value) {
        this.msgMap.put(key, value);
    }

    public ArrayList<HashMap<String, String>> getInbox() {
        return this.inbox;
    }

    public void setInbox(ArrayList<HashMap<String, String>> inbox2) {
        this.inbox = inbox2;
    }

    public Integer getSocialCooldown() {
        return this.socialCooldown;
    }

    public void setSocialCooldown(Integer socialCooldown) {
        this.socialCooldown = socialCooldown;
    }

    public static class CachedDestination {
        private final Dest destination;
        private final PDDestination.Settings destSettings;
        private final String tracking;

        public CachedDestination(PDDestination destination) {
            this.destination = new Dest(destination.getDest());
            this.destSettings = new PDDestination.Settings(destination.getSetting());
            this.tracking = destination.getTracking();
        }

        public Dest getDestination() {
            return this.destination;
        }

        public PDDestination.Settings getDestSettings() {
            return this.destSettings;
        }

        public String getTracking() {
            return this.tracking;
        }
    }

    public static class SpeedData {
        private Vec vec;
        private Long worldTime;
        private Double speed = 0.0;

        public SpeedData(Player player) {
            this.vec = player.getVec();
            this.worldTime = player.getWorldTime();
        }

        public Vec getVec() {
            return this.vec;
        }

        public void setVec(Vec vec) {
            this.vec = vec;
        }

        public Long getWorldTime() {
            return this.worldTime;
        }

        public void setWorldTime(Long worldTime) {
            this.worldTime = worldTime;
        }

        public Double getSpeed() {
            return this.speed;
        }

        public void setSpeed(Double speed) {
            this.speed = speed;
        }
    }
}

