/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.DefaultPData;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.utils.Player;

public class PlayerData {
    private static final DefaultPData defaults = new DefaultPData();
    private static final Map<Player, CachedPData> playerCache = new HashMap<Player, CachedPData>();
    private static final Map<Player, PData> playerData = new HashMap<Player, PData>();

    public static void setDefaults(DefaultPData newDefaults, boolean save) {
        defaults.copyFileData(newDefaults);
        if (save) {
            defaults.save();
        }
    }

    public static void loadDefaults() {
        defaults.load();
    }

    public static DefaultPData getDefaults() {
        return new DefaultPData(defaults);
    }

    public static void clearPlayerCache() {
        playerCache.clear();
    }

    public static void setPlayerCache(Player player, CachedPData pCache) {
        playerCache.put(player, pCache);
    }

    public static void removePlayerCache(Player player) {
        playerCache.remove(player);
    }

    public static CachedPData getPCache(Player player) {
        if (!playerCache.containsKey(player)) {
            PlayerData.setPlayerCache(player, new CachedPData(player.getPData()));
        }
        return playerCache.get(player);
    }

    public static void clearPlayerData() {
        playerData.clear();
    }

    public static void setPlayerData(Player player, PData pData) {
        playerData.put(player, Objects.requireNonNullElseGet(pData, () -> new PData(player)));
    }

    public static void removePlayerData(Player player) {
        playerData.remove(player);
    }

    public static PData getPData(Player player) {
        if (!playerData.containsKey(player)) {
            PlayerData.addPlayer(player);
        }
        Queue.updateExpireTime(player);
        return playerData.get(player);
    }

    public static void addPlayer(Player player) {
        PData pData = new PData(player);
        pData.load();
        playerData.put(player, pData);
    }

    public static void removePlayer(Player player) {
        if (playerData.containsKey(player)) {
            PlayerData.getPData(player).save();
            PlayerData.removePlayerData(player);
        }
        Queue.clearPlayer(player);
        PlayerData.removePlayerCache(player);
    }

    public static class Queue {
        private static final ArrayList<Player> SAVE = new ArrayList();
        private static final ConcurrentHashMap<Player, Integer> EXPIRE = new ConcurrentHashMap();

        public static void addSavePlayer(Player player) {
            if (!SAVE.contains(player)) {
                SAVE.add(player);
            }
        }

        public static void updateExpireTime(Player player) {
            EXPIRE.put(player, 30);
        }

        public static void tick() {
            Player player;
            Iterator<Player> iterator = SAVE.iterator();
            while (iterator.hasNext()) {
                player = iterator.next();
                player.getPData().save();
                iterator.remove();
            }
            iterator = ((ConcurrentHashMap.KeySetView)EXPIRE.keySet()).iterator();
            while (iterator.hasNext()) {
                player = iterator.next();
                EXPIRE.put(player, EXPIRE.get(player) - 1);
                if (EXPIRE.get(player) >= 1) continue;
                PlayerData.removePlayerData(player);
                iterator.remove();
            }
        }

        private static void clearPlayer(Player player) {
            SAVE.remove(player);
            EXPIRE.remove(player);
        }
    }
}

