/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.LoopManager;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.dimension.DimensionEntry;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.HudColor;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.hud.module.ModuleManager;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleLight;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.ActionResult;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.common.utils.Rainbow;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public class Hud {
    public static final Lang LANG = new Lang("hud.");
    public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#29ff69")).click(1, "/hud")).hover(((CTxT)CTxT.of("/hud").color("#29ff69")).append("\n").append(LANG.hover()));

    public static void CMDExecutor(Player player, String[] args) {
        if (!Helper.checkEnabled(player).hud()) {
            return;
        }
        if (args.length == 0) {
            Hud.UI(player, null);
            return;
        }
        String type = args[0].toLowerCase();
        String[] trimmedArgs = Helper.trimStart(args, 1);
        switch (type) {
            case "modules": {
                modules.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "settings": {
                settings.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "color": {
                color.cmdExecutor(player, trimmedArgs);
                break;
            }
            case "toggle": {
                settings.change(player, Setting.state, (Boolean)player.getPCache().getHud().getSetting(Setting.state) != false ? "off" : "on", false);
                break;
            }
            default: {
                player.sendMessage(CUtl.error("command", new Object[0]));
            }
        }
    }

    public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
        ArrayList<String> suggester = new ArrayList<String>();
        if (!Helper.checkEnabled(player).hud()) {
            return suggester;
        }
        if (pos == 1) {
            suggester.add("modules");
            suggester.add("color");
            suggester.add("toggle");
            suggester.add("settings");
        }
        if (pos > 1) {
            String command = args[0].toLowerCase();
            String[] trimmedArgs = Helper.trimStart(args, 1);
            int fixedPos = pos - 2;
            switch (command) {
                case "modules": {
                    suggester.addAll(modules.CMDSuggester(player, fixedPos, trimmedArgs));
                    break;
                }
                case "settings": {
                    suggester.addAll(settings.CMDSuggester(fixedPos, trimmedArgs));
                    break;
                }
                case "color": {
                    suggester.addAll(color.cmdSuggester(player, fixedPos, trimmedArgs));
                }
            }
        }
        return suggester;
    }

    public static void UI(Player player, CTxT aboveTxT) {
        CTxT msg = CTxT.of("");
        CTxT line = (CTxT)CTxT.of("\n                            ").strikethrough(true);
        if (aboveTxT != null) {
            msg.append(aboveTxT).append("\n");
        }
        msg.append(" ").append((CTxT)LANG.ui("commands", new Object[0]).color(CUtl.p())).append(line).append("\n ");
        msg.append(color.button()).append(" ");
        msg.append(settings.button()).append("\n\n ");
        msg.append(modules.button()).append(" ");
        msg.append(CUtl.CButton.back("/dhud"));
        msg.append(line);
        player.sendMessage(msg);
    }

    public static class modules {
        public static final String SETTING_ON = "on";
        public static final String SETTING_OFF = "off";
        public static final List<String> SUGGESTER_ON_OFF = List.of("on", "off");
        public static final Lang LANG = new Lang("directionhud.hud.module.");
        public static final String STATE_GREEN = "#19ff21";
        public static final String STATE_YELLOW = "#fff419";
        public static final String STATE_GRAY = "#8d8d8d";

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#665dff")).click(1, "/hud modules")).hover(((CTxT)CTxT.of("/hud modules (order, toggle, reset)").color("#665dff")).append("\n").append(LANG.hover()));
        }

        public static void CMDExecutor(Player player, String[] args) {
            ActionResult result;
            Module module;
            if (args.length == 0) {
                modules.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.usage("/hud modules reset <all, module> (confirm)"));
                } else {
                    module = Module.fromString(args[1]);
                    if (module.equals((Object)Module.UNKNOWN) && !args[1].equals("all")) {
                        player.sendMessage(ModuleManager.INVALID_MODULE.getChatMessage());
                    }
                    if (args.length == 3 && args[2].equalsIgnoreCase("confirm")) {
                        ActionResult actionResult = result = module.equals((Object)Module.UNKNOWN) ? ModuleManager.Reset.resetEverything(player) : ModuleManager.Reset.resetModule(player, module);
                        if (Return) {
                            if (module.equals((Object)Module.UNKNOWN)) {
                                modules.UI(player, result.getChatMessage());
                            } else {
                                Edit.UI(player, result.getChatMessage(), module);
                            }
                        } else {
                            player.sendMessage(result.getChatMessage());
                        }
                    } else {
                        CUtl.confirmation(player, "/hud modules reset " + (module.equals((Object)Module.UNKNOWN) ? "all" : module.getName()), "reset");
                    }
                }
            }
            if (args[0].equals("enable")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    Integer order = args.length == 2 ? null : Helper.Num.toInt(args[2]);
                    result = ModuleManager.State.enable(player, Module.fromString(args[1]), order);
                    if (Return) {
                        if (order == null) {
                            Disabled.UI(player, result.getChatMessage(), Helper.Num.toInt(result.extraSettings().get("page")));
                        } else {
                            Edit.UI(player, result.getChatMessage(), Module.fromString(args[1]));
                        }
                    } else {
                        player.sendMessage(result.getChatMessage());
                    }
                }
            }
            if (args[0].equals("disable")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                }
                ActionResult result2 = ModuleManager.State.disable(player, Module.fromString(args[1]));
                if (Return) {
                    Edit.UI(player, result2.getChatMessage(), Module.fromString(result2.extraSettings().get("module")));
                } else {
                    player.sendMessage(result2.getChatMessage());
                }
            }
            if (args[0].equals("edit")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else if (Helper.Num.isInt(args[1])) {
                    if (ModuleManager.State.getEnabled(player).isEmpty()) {
                        Edit.UI(player, null, Module.UNKNOWN);
                    } else {
                        Edit.UI(player, null, ModuleManager.State.getEnabled(player).get(Math.max(0, Math.min(ModuleManager.State.getEnabled(player).size() - 1, Helper.Num.toInt(args[1])))).getModuleType());
                    }
                } else {
                    Edit.UI(player, null, Module.fromString(args[1]));
                }
            }
            if (args[0].equals("disabled")) {
                if (args.length < 2) {
                    Disabled.UI(player, null, 1);
                } else {
                    Disabled.UI(player, null, Helper.Num.toInt(args[1]));
                }
            }
            if (args[0].equals("setting")) {
                if (args.length < 4) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    module = Module.fromString(args[1]);
                    result = ModuleManager.Setting.setSetting(player, module, args[2], args[3]);
                    if (Return) {
                        Edit.UI(player, result.getChatMessage(), module);
                    } else {
                        player.sendMessage(result.getChatMessage());
                    }
                }
            }
            if (args[0].equals("order")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else if (args.length == 3 && Helper.Num.isInt(args[2])) {
                    module = Module.fromString(args[1]);
                    result = ModuleManager.Order.move(player, module, Integer.parseInt(args[2]));
                    if (Return) {
                        Edit.UI(player, result.getChatMessage(), module);
                    } else {
                        player.sendMessage(result.getChatMessage());
                    }
                } else {
                    player.sendMessage(CUtl.error("number", new Object[0]));
                }
            }
        }

        public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("order");
                suggester.add("reset");
                suggester.add("setting");
                if (!ModuleManager.State.getEnabled(player).isEmpty()) {
                    suggester.add("disable");
                    suggester.add("edit");
                }
                if (!ModuleManager.State.getDisabled(player).isEmpty()) {
                    suggester.add("enable");
                    suggester.add("disabled");
                }
                return suggester;
            }
            args[0] = args[0].replaceAll("-r", "");
            if (pos == 1) {
                if (args[0].equals("setting")) {
                    suggester.addAll(player.getPCache().getHud().getModules().stream().filter(bm -> bm.hasSettings() && bm.isEnabled()).map(mod -> mod.getModuleType().getName()).toList());
                } else if (args[0].equals("enable")) {
                    suggester.addAll(player.getPCache().getHud().getModules().stream().filter(bm -> !bm.isEnabled()).map(mod -> mod.getModuleType().getName()).toList());
                } else {
                    suggester.addAll(player.getPCache().getHud().getModules().stream().filter(BaseModule::isEnabled).map(mod -> mod.getModuleType().getName()).toList());
                    if (args[0].equals("reset")) {
                        suggester.add("all");
                    }
                }
            }
            if (pos == 2 && args[0].equalsIgnoreCase("order")) {
                suggester.add(String.valueOf(((BaseModule)player.getPCache().getHud().getModule(Module.fromString(args[1]))).getOrder()));
            }
            if (args[0].equalsIgnoreCase("setting")) {
                if (pos == 2) {
                    Module module = Module.fromString(args[1]);
                    if (module.equals((Object)Module.UNKNOWN)) {
                        return suggester;
                    }
                    Object mod2 = player.getPCache().getHud().getModule(module);
                    String[] settingIDs = ((BaseModule)mod2).getSettingIDs();
                    if (settingIDs.length == 0) {
                        return suggester;
                    }
                    suggester.addAll(Arrays.asList(settingIDs));
                }
                if (pos == 3) {
                    String settingID;
                    switch (settingID = args[2]) {
                        case "coordinates_xyz-display": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "angle_display": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleAngle.Display.values()));
                            break;
                        }
                        case "time_24hr": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "speed_2d-calculation": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "speed_display-pattern": {
                            suggester.addAll(List.of("0.00", "0.##", "0.00##"));
                            break;
                        }
                        case "tracking_hybrid": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "tracking_display": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleTracking.Type.values()));
                            break;
                        }
                        case "tracking_target": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleTracking.Target.values()));
                            break;
                        }
                        case "tracking_show-elevation": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                        }
                    }
                }
            }
            return suggester;
        }

        public static CTxT moduleExample(Player player, Module module) {
            Object mod = player.getPCache().getHud().getModule(module);
            Random random = new Random();
            Loc randomLoc = new Loc((Integer)random.nextInt(5000), (Integer)random.nextInt(-64, 200), random.nextInt(5000));
            double randomRotation = random.nextDouble(0.0, 360.0);
            DimensionEntry.Time.Weather.Icons defaultIcons = DimensionEntry.Time.Weather.Icons.defaultIcons();
            return switch (module) {
                case Module.DISTANCE -> ((BaseModule)mod).getDisplayTxT(player, random.nextInt(50, 250));
                case Module.DESTINATION -> ((BaseModule)mod).getDisplayTxT(player, new Dest(randomLoc, "a", "#ffffff"));
                case Module.DIRECTION -> ((BaseModule)mod).getDisplayTxT(player, randomRotation);
                case Module.TRACKING -> ((BaseModule)mod).getDisplayTxT(player, randomRotation, player.getLoc(), randomLoc);
                case Module.TIME -> ((BaseModule)mod).getDisplayTxT(player, random.nextInt(1, 25), random.nextInt(0, 60));
                case Module.WEATHER -> {
                    Object[] v1 = new Object[2];
                    Object v2 = v1[0] = random.nextBoolean() ? defaultIcons.day() : defaultIcons.night();
                    v1[1] = random.nextBoolean() ? "" : (random.nextBoolean() ? defaultIcons.storm() : defaultIcons.thunderstorm());
                    yield ((BaseModule)mod).getDisplayTxT(player, v1);
                }
                case Module.SPEED -> ((BaseModule)mod).getDisplayTxT(player, random.nextDouble(1.0, 12.0));
                case Module.ANGLE -> ((BaseModule)mod).getDisplayTxT(player, Float.valueOf(random.nextFloat(-180.0f, 180.1f)), Float.valueOf(random.nextFloat(-90.0f, 90.1f)));
                case Module.LIGHT -> ((BaseModule)mod).getDisplayTxT(player, random.nextInt(0, 16), random.nextInt(0, 16));
                default -> ((BaseModule)mod).getDisplayTxT(player, randomLoc);
            };
        }

        public static CTxT moduleInfo(Module module) {
            return LANG.get("info." + module.getName(), new Object[0]);
        }

        public static String stateColor(Player player, Module module) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return "#ff4646";
            }
            Object mod = player.getPCache().getHud().getModule(module);
            if (!((BaseModule)mod).isEnabled()) {
                return STATE_GRAY;
            }
            String color2 = STATE_GREEN;
            if (!Destination.dest.get(player).hasXYZ() && (module.equals((Object)Module.DESTINATION) || module.equals((Object)Module.DISTANCE))) {
                color2 = STATE_YELLOW;
            }
            if (module.equals((Object)Module.TRACKING)) {
                boolean hasPlayer = Destination.social.track.getTarget(player).isValid();
                boolean hasDest = Destination.dest.get(player).hasXYZ();
                ModuleTracking.Target target = (ModuleTracking.Target)((Object)((BaseModule)mod).getSettingValue("tracking_target"));
                if (((Boolean)((BaseModule)mod).getSettingValue("tracking_hybrid")).booleanValue()) {
                    if (!hasPlayer && !hasDest) {
                        color2 = STATE_YELLOW;
                    }
                } else if (target.equals((Object)ModuleTracking.Target.player)) {
                    if (!hasPlayer) {
                        color2 = STATE_YELLOW;
                    }
                } else if (target.equals((Object)ModuleTracking.Target.dest) && !hasDest) {
                    color2 = STATE_YELLOW;
                }
            }
            return color2;
        }

        public static CTxT getDisabledButton() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn("disabled", new Object[0]).color('c')).btn(true)).click(1, "/hud modules disabled")).hover(((CTxT)LANG.hover("disabled", new Object[0]).color('c')).append("\n").append(LANG.hover("disabled.click", new Object[0])));
        }

        public static CTxT getEditButton() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn("edit", new Object[0]).color("#665dff")).btn(true)).click(1, "/hud modules edit 0")).hover(((CTxT)Edit.LANG.hover("edit", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("edit.click", new Object[0])));
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            CTxT line = CUtl.makeLine(25);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().color("#665dff")).append(line);
            msg.append("\n ").append(modules.getEditButton()).append(" ").append(modules.getDisabledButton()).append("\n");
            CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
            if (player.getPCache().getHud().getModules().stream().anyMatch(ModuleManager.Reset::canReset)) {
                ((CTxT)((CTxT)reset.color('c')).click(1, "/hud modules reset-r all")).hover(((CTxT)CUtl.LANG.hover("reset", new Object[0]).color('c')).append("\n").append(LANG.hover("reset.all", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), LANG.hover("reset.all.fill", new Object[0]).color(CUtl.s()))));
            }
            msg.append("\n ").append(reset).append("  ").append(CUtl.CButton.back("/hud")).append(line);
            player.sendMessage(msg);
        }

        public static class Edit {
            public static final Lang LANG = new Lang("directionhud.hud.module.edit.");

            public static void UI(Player player, CTxT aboveTxT, Module module) {
                CTxT msg = new CTxT();
                CTxT line = CUtl.makeLine(40);
                CTxT back = CUtl.CButton.back("/hud modules");
                if (aboveTxT != null) {
                    msg.append(aboveTxT).append("\n");
                }
                msg.append(" ").append((CTxT)LANG.ui().color("#665dff")).append(line);
                ArrayList<BaseModule> enabled = ModuleManager.State.getEnabled(player);
                if (enabled.isEmpty()) {
                    msg.append("\n\n ").append(LANG.ui("none", new Object[0])).append("\n ").append(LANG.ui("none_2", modules.getDisabledButton())).append("\n\n ").append(back).append(line);
                    player.sendMessage(msg);
                    return;
                }
                if (module.equals((Object)Module.UNKNOWN)) {
                    player.sendMessage(ModuleManager.INVALID_MODULE.getChatMessage());
                    return;
                }
                Object mod = player.getPCache().getHud().getModule(module);
                if (!((BaseModule)mod).isEnabled()) {
                    player.sendMessage(ModuleManager.DISABLED_MODULE.getChatMessage());
                    return;
                }
                boolean state = ((BaseModule)mod).isEnabled();
                CTxT toggle = ((CTxT)((CTxT)((CTxT)CTxT.of("\u21c4").btn(true)).color(CUtl.toggleColor(state))).click(1, "/hud modules disable-r " + String.valueOf((Object)module))).hover(((CTxT)LANG.hover("toggle", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("toggle.click", CTxT.of(module.getName()).color(CUtl.s()), CUtl.LANG.btn(!state ? modules.SETTING_ON : modules.SETTING_OFF, new Object[0]).color(!state ? (char)'a' : 'c'))));
                msg.append("\n ").append(Edit.createPreviewBar(player, module));
                msg.append(line);
                msg.append("\n ").append(toggle).append(" ").append(Edit.createModuleOrderUI(player, module)).append(" ");
                CTxT extraSettings = ((BaseModule)mod).getSettingButtons();
                if (!extraSettings.isEmpty()) {
                    msg.append("\n\n ").append(extraSettings);
                }
                msg.append("\n\n ").append(Edit.createModuleSwitcher(player, module));
                CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
                if (ModuleManager.Reset.canResetSettings(mod)) {
                    ((CTxT)((CTxT)reset.color('c')).click(1, "/hud modules reset-r " + module.getName())).hover(new CTxT((CTxT)CUtl.LANG.hover("reset", new Object[0]).color('c')).append("\n").append(LANG.hover("reset.click", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), new CTxT(module.getName()).color(CUtl.s()))));
                }
                msg.append("\n\n ").append(reset);
                msg.append("  ").append(back);
                msg.append(line);
                player.sendMessage(msg);
            }

            private static CTxT createPreviewBar(Player player, Module module) {
                CTxT refresh = ((CTxT)((CTxT)((CTxT)new CTxT("\ud83d\udd01").btn(true)).color('a')).click(1, "/hud modules edit " + String.valueOf((Object)module))).hover(((CTxT)LANG.hover("refresh", new Object[0]).color('a')).append("\n").append(LANG.hover("refresh.click", LANG.hover("refresh.click.fill", new Object[0]).color('a'))));
                CTxT preview = modules.moduleExample(player, module).hover(((CTxT)LANG.hover("preview", new Object[0]).color("#665dff")).append("\n").append((CTxT)LANG.hover("preview.info", new Object[0]).color('7')));
                return new CTxT().append(refresh).append(" ").append(preview);
            }

            private static CTxT createModuleSwitcher(Player player, Module module) {
                String stateColor;
                ArrayList<BaseModule> modules2 = ModuleManager.State.getEnabled(player);
                Object mod = player.getPCache().getHud().getModule(module);
                int moduleIndex = ((BaseModule)mod).getOrder() - 1;
                boolean leftEnabled = moduleIndex > 0;
                boolean rightEnabled = moduleIndex < modules2.size() - 1;
                CTxT leftArrow = (CTxT)((CTxT)CTxT.of("\u25c0").btn(true)).color(modules.STATE_GRAY);
                CTxT rightArrow = (CTxT)((CTxT)CTxT.of("\u25b6").btn(true)).color(modules.STATE_GRAY);
                CTxT hover = ((CTxT)LANG.hover().color("#665dff")).append("\n");
                if (leftEnabled) {
                    ((CTxT)leftArrow.color("#665dff")).hover(CTxT.of(hover).append(LANG.hover("cycle", LANG.hover("cycle.previous", new Object[0]).color(CUtl.s())))).click(1, "/hud modules edit " + modules2.get(moduleIndex - 1).getModuleType().getName());
                }
                if (rightEnabled) {
                    ((CTxT)rightArrow.color("#665dff")).hover(CTxT.of(hover).append(LANG.hover("cycle", LANG.hover("cycle.next", new Object[0]).color(CUtl.s())))).click(1, "/hud modules edit " + modules2.get(moduleIndex + 1).getModuleType().getName());
                }
                CTxT status = LANG.hover("status." + (switch (stateColor = modules.stateColor(player, module)) {
                    case modules.STATE_GREEN -> "enabled";
                    case modules.STATE_YELLOW -> "no_data";
                    default -> "disabled";
                }), new Object[0]);
                status.color(stateColor);
                CTxT moduleTxT = (CTxT)((CTxT)((CTxT)CTxT.of(module.getName()).btn(true)).color(modules.stateColor(player, module))).hover(new CTxT().append((CTxT)CTxT.of(module.getName()).color("#665dff")).append("\n").append(LANG.hover("status", status)).append("\n").append((CTxT)LANG.get("info." + module.getName(), new Object[0]).color('7')).append("\n\n").append(LANG.hover("change", new Object[0]))).click(2, "/hud modules edit ");
                return new CTxT().append(leftArrow).append(" ").append(moduleTxT).append(" ").append(rightArrow);
            }

            private static CTxT createOrderMoveButton(String text, boolean enabled, String hoverKey, String hoverKeySecondary, String setCMD) {
                String enabledColor = CUtl.s();
                String disabledColor = modules.STATE_GRAY;
                CTxT button = (CTxT)((CTxT)LANG.btn().text(text).btn(true)).color(enabled ? enabledColor : modules.STATE_GRAY);
                if (!enabled) {
                    return button;
                }
                ((CTxT)button.click(1, setCMD)).hover(((CTxT)LANG.hover("order", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("order.move." + hoverKey, LANG.hover("order.move." + hoverKey + "." + hoverKeySecondary, new Object[0]).color(CUtl.s()))));
                return button;
            }

            private static CTxT createModuleOrderUI(Player player, Module module) {
                int currentOrder = ((BaseModule)player.getPCache().getHud().getModule(module)).getOrder();
                int moduleIndex = currentOrder - 1;
                boolean leftEnabled = moduleIndex > 0;
                boolean rightEnabled = moduleIndex < ModuleManager.State.getEnabled(player).size() - 1;
                String cmd = "/hud modules order-r " + module.getName() + " ";
                CTxT moveLeftMost = Edit.createOrderMoveButton("\u23ee", leftEnabled, "most", "first", cmd + "1");
                CTxT moveLeft = Edit.createOrderMoveButton("\u25c0", leftEnabled, "one", "up", cmd + (currentOrder - 1));
                CTxT moveRight = Edit.createOrderMoveButton("\u25b6", rightEnabled, "one", "down", cmd + (currentOrder + 1));
                CTxT moveRightMost = Edit.createOrderMoveButton("\u23ed", rightEnabled, "most", "last", cmd + "100");
                CTxT currentPosition = (CTxT)((CTxT)((CTxT)new CTxT(String.valueOf(currentOrder)).btn(true)).color("#665dff")).hover(((CTxT)LANG.hover("order", new Object[0]).color("#665dff")).append("\n").append((CTxT)LANG.hover("order.info", new Object[0]).color('7')).append("\n\n").append(LANG.hover("order.set", new Object[0]))).click(2, cmd);
                return new CTxT().append(moveLeftMost).append(moveLeft).append(currentPosition).append(moveRight).append(moveRightMost);
            }
        }

        public static class Disabled {
            private static final int PER_PAGE = 6;
            public static final Lang LANG = new Lang("directionhud.hud.module.disabled.");

            public static Helper.ListPage<BaseModule> getList(Player player) {
                return new Helper.ListPage<BaseModule>(ModuleManager.State.getDisabled(player), 6);
            }

            public static void UI(Player player, CTxT aboveTxT, int pg) {
                Helper.ListPage<BaseModule> listPage = Disabled.getList(player);
                CTxT msg = new CTxT();
                CTxT line = CUtl.makeLine(30);
                if (aboveTxT != null) {
                    msg.append(aboveTxT).append("\n");
                }
                msg.append(" ").append((CTxT)LANG.ui().color("#665dff")).append(line).append("\n");
                for (BaseModule mod : listPage.getPage(pg)) {
                    Module module = mod.getModuleType();
                    CTxT enable = ((CTxT)((CTxT)((CTxT)CTxT.of("\u21c4").btn(true)).color(CUtl.toggleColor(false))).click(1, "/hud modules enable-r " + String.valueOf((Object)module))).hover(((CTxT)LANG.hover("enable", new Object[0]).color(CUtl.toggleColor(false))).append("\n").append(LANG.hover("enable.click", CTxT.of(module.getName()).color(CUtl.s()))));
                    CTxT moduleText = new CTxT(module.getName()).hover(new CTxT().append(new CTxT(modules.moduleExample(player, module)).append("\n").append((CTxT)new CTxT(module.getName()).color("#665dff")).append("\n").append((CTxT)modules.moduleInfo(module).color('7'))));
                    msg.append(" ").append(enable).append(" ").append(moduleText).append("\n");
                }
                if (listPage.getPage(0).isEmpty()) {
                    msg.append("\n ").append(LANG.ui("none", new Object[0])).append("\n ").append(LANG.ui("none_2", modules.getEditButton())).append("\n");
                }
                msg.append("\n ").append(listPage.getNavButtons(pg, "/hud modules disabled ")).append(" ").append(CUtl.CButton.back("/hud modules")).append(line);
                player.sendMessage(msg);
            }
        }
    }

    public static class settings {
        public static final Lang LANG = new Lang("hud.setting.");

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("settings", new Object[0]).btn(true)).color("#e9e9e9")).click(1, "/hud settings")).hover(((CTxT)CTxT.of("/hud settings").color("#e9e9e9")).append("\n").append(CUtl.LANG.hover("settings", CUtl.LANG.get("hud", new Object[0]))));
        }

        public static void CMDExecutor(Player player, String[] args) {
            if (args.length == 0) {
                settings.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 1) {
                    settings.reset(player, Setting.none, Return);
                } else {
                    settings.reset(player, Setting.get(args[1]), Return);
                }
            }
            if (args[0].equals("set")) {
                if (args.length != 3) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                }
                settings.change(player, Setting.get(args[1]), args[2], Return);
            }
        }

        public static ArrayList<String> CMDSuggester(int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("set");
                suggester.add("reset");
                return suggester;
            }
            args[0] = args[0].replaceAll("-[rm]", "");
            if (pos == 1) {
                for (Setting s : Setting.values()) {
                    suggester.add(s.toString());
                }
                suggester.remove(Setting.none.toString());
                if (args[0].equals("reset")) {
                    suggester.remove(Setting.bossbar__distance_max.toString());
                }
            }
            if (pos == 2 && args[0].equalsIgnoreCase("set")) {
                if (Helper.Enums.toStringList(Setting.boolSettings()).contains(args[1])) {
                    suggester.add("on");
                    suggester.add("off");
                }
                if (args[1].equalsIgnoreCase(Setting.type.toString())) {
                    suggester.addAll(Helper.Enums.toStringList((Enum[])Setting.DisplayType.values()));
                }
                if (args[1].equalsIgnoreCase(Setting.bossbar__color.toString())) {
                    suggester.addAll(Helper.Enums.toStringList((Enum[])Setting.BarColor.values()));
                }
                if (args[1].equalsIgnoreCase(Setting.bossbar__distance_max.toString())) {
                    suggester.add("0");
                }
            }
            return suggester;
        }

        public static Object getConfig(Setting setting) {
            return PlayerData.getDefaults().getHud().getSetting(setting);
        }

        public static void reset(Player player, Setting setting, boolean Return) {
            if (setting.equals((Object)Setting.bossbar__distance_max)) {
                return;
            }
            if (setting.equals((Object)Setting.none)) {
                for (Setting s : Setting.baseSettings()) {
                    player.getPData().getHud().setSetting(s, settings.getConfig(s));
                }
            } else {
                player.getPData().getHud().setSetting(setting, settings.getConfig(setting));
            }
            if (setting.equals((Object)Setting.bossbar__distance)) {
                player.getPData().getHud().setSetting(Setting.get(String.valueOf((Object)setting) + "_max"), settings.getConfig(Setting.get(String.valueOf((Object)setting) + "_max")));
            }
            player.updateHUD();
            CTxT msg = CUtl.tag().append(LANG.msg("reset", LANG.get("category", LANG.get("category." + (setting.toString().startsWith("bossbar") ? "bossbar" : "hud"), new Object[0]), LANG.get(setting.toString(), new Object[0]).color(CUtl.s()))));
            if (setting.equals((Object)Setting.none)) {
                msg = CUtl.tag().append(LANG.msg("reset_all", CUtl.LANG.btn("all", new Object[0]).color('c')));
            }
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void change(Player player, Setting setting, String state, boolean Return) {
            boolean bool = state.equals("on");
            CTxT setTxT = CTxT.of("");
            if (setting.equals((Object)Setting.bossbar__distance) || setting.equals((Object)Setting.state)) {
                player.getPData().getHud().setSetting(setting, bool);
                setTxT.append(CUtl.toggleTxT(bool));
            }
            if (setting.equals((Object)Setting.type)) {
                Setting.DisplayType displayType = Setting.DisplayType.get(state);
                player.getPData().getHud().setSetting(setting, (Object)displayType);
                setTxT.append((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)displayType), new Object[0]).color(CUtl.s()));
            }
            if (setting.equals((Object)Setting.bossbar__color)) {
                Setting.BarColor barColor = Helper.Enums.get(state, Setting.BarColor.class);
                player.getPData().getHud().setSetting(setting, (Object)barColor);
                setTxT.append((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)barColor), new Object[0]).color(Assets.barColor(barColor)));
            }
            if (setting.equals((Object)Setting.bossbar__distance_max)) {
                int i = Math.max(Helper.Num.toInt(state), 0);
                player.getPData().getHud().setSetting(setting, i);
                setTxT.append((CTxT)CTxT.of(String.valueOf(i)).color((Boolean)player.getPData().getHud().getSetting(Setting.bossbar__distance) != false ? (char)'a' : 'c'));
            }
            player.updateHUD();
            CTxT msg = CUtl.tag();
            CTxT typeTxT = (CTxT)LANG.get(setting.toString(), new Object[0]).color(CUtl.s());
            String extra = "";
            if (Setting.boolSettings().contains((Object)setting)) {
                extra = ".toggle";
            }
            if (setting.toString().startsWith("bossbar.")) {
                typeTxT = LANG.get("category", LANG.get("category.bossbar", new Object[0]), typeTxT);
            } else if (!setting.toString().startsWith("module.")) {
                typeTxT = LANG.get("category", LANG.get("category.hud", new Object[0]), typeTxT);
            }
            msg.append(LANG.msg("set" + extra, typeTxT, setTxT));
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static boolean canBeReset(Player player, Setting setting) {
            boolean output = false;
            if (setting.equals((Object)Setting.none) || setting.equals((Object)Setting.bossbar__distance_max)) {
                return false;
            }
            if (!player.getPCache().getHud().getSetting(setting).equals(settings.getConfig(setting))) {
                output = true;
            }
            if (setting.equals((Object)Setting.bossbar__distance) && ((Integer)player.getPCache().getHud().getSetting(Setting.bossbar__distance_max)).intValue() != ((Integer)settings.getConfig(Setting.bossbar__distance_max)).intValue()) {
                output = true;
            }
            return output;
        }

        public static CTxT resetBtn(Player player, Setting setting) {
            CTxT msg = (CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color('7');
            if (settings.canBeReset(player, setting)) {
                ((CTxT)((CTxT)msg.color('c')).click(1, "/hud settings reset-r " + String.valueOf((Object)setting))).hover(LANG.hover("reset", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), LANG.get("category." + (setting.toString().startsWith("bossbar") ? "bossbar" : "hud"), new Object[0]), LANG.get(setting.toString(), new Object[0]).color(CUtl.s())));
            }
            return msg;
        }

        public static CTxT getButtons(Player player, Setting setting) {
            CTxT button = CTxT.of("");
            if (setting.equals((Object)Setting.state)) {
                button.append(CUtl.toggleBtn((Boolean)player.getPCache().getHud().getSetting(setting), "/hud settings set-r " + String.valueOf((Object)setting) + " ")).append(" ");
            }
            if (setting.equals((Object)Setting.type)) {
                Setting.DisplayType nextType = Setting.DisplayType.valueOf((String)player.getPCache().getHud().getSetting(setting)).next();
                button.append(((CTxT)((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf(player.getPCache().getHud().getSetting(setting)), new Object[0]).btn(true)).color(CUtl.s())).click(1, "/hud settings set-r " + String.valueOf((Object)setting) + " " + String.valueOf((Object)nextType))).hover(LANG.hover("set", LANG.get("category", LANG.get("category.hud", new Object[0]), LANG.get(setting.toString(), new Object[0])), LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)nextType), new Object[0]).color(CUtl.s()))));
            }
            if (setting.equals((Object)Setting.bossbar__color)) {
                button.append(((CTxT)((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf(player.getPCache().getHud().getSetting(setting)), new Object[0]).btn(true)).color(Assets.barColor(Setting.BarColor.valueOf((String)player.getPCache().getHud().getSetting(setting))))).click(2, "/hud settings set-r " + String.valueOf((Object)setting) + " ")).hover(LANG.hover("set.custom", LANG.get("category", LANG.get("category.bossbar", new Object[0]), LANG.get(setting.toString(), new Object[0])))));
            }
            if (setting.equals((Object)Setting.bossbar__distance)) {
                boolean state = (Boolean)player.getPCache().getHud().getSetting(setting);
                button.append(CUtl.toggleBtn(state, "/hud settings set-r " + String.valueOf((Object)setting) + " ")).append(" ");
                button.append(((CTxT)((CTxT)((CTxT)CTxT.of(String.valueOf((Integer)player.getPCache().getHud().getSetting(Setting.bossbar__distance_max))).btn(true)).color((Boolean)player.getPCache().getHud().getSetting(setting) != false ? (char)'a' : 'c')).click(2, "/hud settings set-r " + String.valueOf((Object)Setting.bossbar__distance_max) + " ")).hover(LANG.hover("set.custom", LANG.get("category", LANG.get("category.bossbar", new Object[0]), LANG.get(Setting.bossbar__distance_max.toString(), new Object[0]))).append("\n").append((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "_max.hover", new Object[0]).italic(true)).color('7'))));
            }
            return button;
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().color("#e9e9e9")).append((CTxT)CTxT.of("\n                              \n").strikethrough(true));
            msg.append(" ").append((CTxT)LANG.get("category.hud", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.state)).append(" ").append(LANG.get(String.valueOf((Object)Setting.state) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.state) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info.toggle", LANG.get("category.hud", new Object[0]), LANG.get(Setting.state.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.state)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.type)).append(" ").append(LANG.get(String.valueOf((Object)Setting.type) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.type) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info", LANG.get("category.hud", new Object[0]), LANG.get(Setting.type.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.type)).append("\n");
            msg.append(" ").append((CTxT)LANG.get("category.bossbar", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.bossbar__color)).append(" ").append(LANG.get(String.valueOf((Object)Setting.bossbar__color) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.bossbar__color) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info", LANG.get("category.bossbar", new Object[0]), LANG.get(Setting.bossbar__color.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.bossbar__color)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.bossbar__distance)).append(" ").append(LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".info", new Object[0]).color('7')).append("\n").append(LANG.get(String.valueOf((Object)Setting.bossbar__distance_max) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".info.2", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.bossbar__distance)).append("\n");
            CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
            boolean resetOn = false;
            for (Setting t : Setting.baseSettings()) {
                if (resetOn) break;
                resetOn = settings.canBeReset(player, t);
            }
            if (resetOn) {
                ((CTxT)((CTxT)reset.color('c')).click(1, "/hud settings reset-r all")).hover(CUtl.LANG.hover("reset.settings", CUtl.LANG.hover("reset.fill", new Object[0]), CUtl.LANG.btn("all", new Object[0]).color(CUtl.s())));
            }
            msg.append("\n    ").append(reset).append("  ").append(CUtl.CButton.back("/hud")).append("\n").append((CTxT)CTxT.of("                              ").strikethrough(true));
            player.sendMessage(msg);
        }
    }

    public static class color {
        public static final Lang LANG = new Lang("hud.color.");

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).rainbow(new Rainbow(15.0f, 45.0f))).click(1, "/hud color")).hover(new CTxT().append(((CTxT)CTxT.of("/hud color").rainbow(new Rainbow(15.0f, 45.0f))).b()).append("\n").append(LANG.hover()));
        }

        public static void cmdExecutor(Player player, String[] args) {
            if (args.length == 0) {
                color.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 2) {
                    color.reset(player, null, args[1], Return);
                }
                if (args.length == 3) {
                    color.reset(player, args[2], args[1], Return);
                }
            }
            if (Helper.Enums.contains(args[0], HudColor.class)) {
                if (args.length == 1) {
                    color.changeUI(player, "normal", HudColor.fromName(args[0]), null);
                    return;
                }
                if (args[1].equals("edit")) {
                    color.changeUI(player, args.length == 3 ? args[2] : "normal", HudColor.fromName(args[0]), null);
                    return;
                }
                if (args.length < 3) {
                    return;
                }
                if (args[1].equals("set")) {
                    color.setColor(player, null, args[0], args[2], false);
                } else {
                    color.setToggle(player, args.length == 4 ? args[3] : "normal", args[0], ColorToggle.get(args[1]), args[2].equals("on"), Return);
                }
            }
        }

        public static ArrayList<String> cmdSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("reset");
                suggester.add("primary");
                suggester.add("secondary");
                return suggester;
            }
            args[0] = args[0].replaceAll("-r", "");
            if (pos == 1) {
                if (args[0].equals("reset")) {
                    suggester.add("all");
                    suggester.add("primary");
                    suggester.add("secondary");
                } else {
                    suggester.add("set");
                    suggester.add("bold");
                    suggester.add("italics");
                    suggester.add("rainbow");
                }
            }
            if (pos == 2) {
                if (args[1].equals("set")) {
                    return Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true);
                }
                if (Helper.Enums.contains(args[0], HudColor.class)) {
                    suggester.add("on");
                    suggester.add("off");
                }
            }
            return suggester;
        }

        public static PDHud.Color defaultEntry(Player player, int typ) {
            PDHud.Color color2 = typ == 1 ? PlayerData.getDefaults().getHud().getPrimary() : PlayerData.getDefaults().getHud().getSecondary();
            color2.setPlayer(player);
            return color2;
        }

        public static PDHud.Color getEntry(Player player, int typ) {
            if (typ == 1) {
                return player.getPCache().getHud().getPrimary();
            }
            return player.getPCache().getHud().getSecondary();
        }

        public static void setEntry(Player player, int typ, PDHud.Color entry) {
            if (typ == 1) {
                player.getPData().getHud().setPrimary(entry);
            } else {
                player.getPData().getHud().setSecondary(entry);
            }
        }

        public static void reset(Player player, String UISettings, String type, boolean Return) {
            switch (type) {
                case "all": {
                    player.getPData().getHud().setPrimary(color.defaultEntry(player, 1));
                    player.getPData().getHud().setSecondary(color.defaultEntry(player, 2));
                    break;
                }
                case "primary": {
                    player.getPData().getHud().setPrimary(color.defaultEntry(player, 1));
                    break;
                }
                case "secondary": {
                    player.getPData().getHud().setSecondary(color.defaultEntry(player, 2));
                    break;
                }
                default: {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                    return;
                }
            }
            CTxT msg = CUtl.tag().append(LANG.msg("reset", LANG.get(type, new Object[0]).color('c')));
            if (Return && type.equals("all")) {
                color.UI(player, msg);
            } else if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(type), msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void setColor(Player player, String UISettings, String type, String color2, boolean Return) {
            int typ = type.equals("primary") ? 1 : 2;
            PDHud.Color colorEntry = color.getEntry(player, typ);
            colorEntry.setColor(CUtl.color.colorHandler(player, color2, color.defaultEntry(player, typ).getColor()));
            color.setEntry(player, typ, colorEntry);
            if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(type), null);
            } else {
                player.sendMessage(CUtl.tag().append(LANG.msg("set", LANG.get(type, new Object[0]), CUtl.color.getBadge(colorEntry.getColor()))));
            }
        }

        public static void setToggle(Player player, String UISettings, String colorType, ColorToggle colorToggle, boolean state, boolean Return) {
            int typ = colorType.equals("primary") ? 1 : 2;
            PDHud.Color colorEntry = color.getEntry(player, typ);
            switch (colorToggle.ordinal()) {
                case 0: {
                    colorEntry.setBold(state);
                    break;
                }
                case 1: {
                    colorEntry.setItalics(state);
                    break;
                }
                case 2: {
                    colorEntry.setRainbow(state);
                    break;
                }
                case 3: {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                    return;
                }
            }
            color.setEntry(player, typ, colorEntry);
            CTxT msg = CUtl.tag().append(LANG.msg("toggle", CUtl.toggleTxT(state), LANG.get(colorType, new Object[0]), LANG.get(colorToggle.toString(), new Object[0])));
            if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(colorType), msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static CTxT addColor(Player player, String txt, HudColor color2, Rainbow rainbow) {
            PDHud.Color colorSettings = color2.getSettings(player);
            CTxT output = (CTxT)((CTxT)CTxT.of(txt).italic(colorSettings.getItalics())).bold(colorSettings.getBold());
            if (colorSettings.getRainbow().booleanValue()) {
                return (CTxT)output.rainbow(rainbow);
            }
            return (CTxT)output.color(colorSettings.getColor());
        }

        public static CTxT addColor(Player player, CTxT txt, HudColor color2, Rainbow rainbow) {
            return color.addColor(player, txt.toString(), color2, rainbow);
        }

        public static void changeUI(Player player, String setting, HudColor color2, CTxT aboveTxT) {
            if (color2 == null) {
                player.sendMessage(CUtl.error("args", new Object[0]));
                return;
            }
            CTxT msg = CTxT.of("");
            CTxT line = CUtl.makeLine(31);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            PDHud.Color colorData = color2.getSettings(player);
            msg.append(" ").append(color.addColor(player, LANG.btn(color2.toString(), new Object[0]), color2, new Rainbow(15.0f, 20.0f))).append(line).append("\n");
            CTxT reset = ((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('c')).click(1, String.format("/hud color reset-r %s %s", new Object[]{color2, setting}))).hover(LANG.hover("reset", color.addColor(player, LANG.get(setting, new Object[0]), color2, new Rainbow(15.0f, 20.0f))));
            CTxT boldButton = ((CTxT)((CTxT)((CTxT)LANG.btn("bold", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getBold()))).click(1, String.format("/hud color %s-r bold %s %s", new Object[]{color2, colorData.getBold() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getBold() == false), LANG.get("bold", new Object[0]).bold(true)));
            CTxT italicsButton = ((CTxT)((CTxT)((CTxT)LANG.btn("italics", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getItalics()))).click(1, String.format("/hud color %s-r italics %s %s", new Object[]{color2, colorData.getItalics() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getItalics() == false), LANG.get("italics", new Object[0]).italic(true)));
            CTxT rgbButton = ((CTxT)((CTxT)((CTxT)LANG.btn("rgb", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getRainbow()))).click(1, String.format("/hud color %s-r rainbow %s %s", new Object[]{color2, colorData.getRainbow() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getRainbow() == false), LANG.get("rainbow", new Object[0]).rainbow(new Rainbow(15.0f, 20.0f))));
            msg.append(DHud.preset.colorEditor(colorData.getColor(), setting, DHud.preset.Type.hud, color2.toString(), "/hud color " + String.valueOf((Object)color2) + " edit %s")).append("\n\n ").append(boldButton).append(" ").append(italicsButton).append(" ").append(rgbButton).append("\n\n     ").append(reset).append(" ").append(CUtl.CButton.back("/hud color")).append(line);
            player.sendMessage(msg);
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            CTxT line = (CTxT)CTxT.of("\n                                ").strikethrough(true);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().rainbow(new Rainbow(15.0f, 45.0f))).append(line).append("\n ").append(((CTxT)((CTxT)color.addColor(player, LANG.btn("primary", new Object[0]), HudColor.PRIMARY, new Rainbow(15.0f, 20.0f)).btn(true)).click(1, "/hud color primary edit")).hover(LANG.hover("edit", color.addColor(player, LANG.get("primary", new Object[0]), HudColor.PRIMARY, new Rainbow(15.0f, 20.0f))))).append(" ").append(((CTxT)((CTxT)color.addColor(player, LANG.btn("secondary", new Object[0]), HudColor.SECONDARY, new Rainbow(15.0f, 20.0f)).btn(true)).click(1, "/hud color secondary edit")).hover(LANG.hover("edit", color.addColor(player, LANG.get("secondary", new Object[0]), HudColor.SECONDARY, new Rainbow(15.0f, 20.0f))))).append("\n\n      ").append(((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('c')).click(1, "/hud color reset-r all")).hover(LANG.hover("reset", LANG.get("all", new Object[0]).color('c')))).append("  ").append(CUtl.CButton.back("/hud")).append(line);
            player.sendMessage(msg);
        }

        public static enum ColorToggle {
            bold,
            italics,
            rainbow,
            unknown;


            public static ColorToggle get(String s) {
                try {
                    return ColorToggle.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    return unknown;
                }
            }
        }
    }

    public static enum Setting {
        state,
        type,
        bossbar__color,
        bossbar__distance,
        bossbar__distance_max,
        none;


        public String toString() {
            return this.name().replace("__", ".");
        }

        public static Setting get(String s) {
            try {
                return Setting.valueOf(s.replace(".", "__"));
            }
            catch (IllegalArgumentException e) {
                return none;
            }
        }

        public static ArrayList<Setting> baseSettings() {
            ArrayList<Setting> list = new ArrayList<Setting>(Arrays.asList(Setting.values()));
            list.remove((Object)none);
            return list;
        }

        public static ArrayList<Setting> boolSettings() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            list.add(state);
            list.add(bossbar__distance);
            return list;
        }

        public static enum BarColor {
            pink,
            blue,
            red,
            green,
            yellow,
            purple,
            white;

        }

        public static enum DisplayType {
            actionbar,
            bossbar;

            private static final DisplayType[] values;

            public DisplayType next() {
                return values[(this.ordinal() + 1) % values.length];
            }

            public static DisplayType get(String s) {
                try {
                    return DisplayType.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    return DisplayType.valueOf(PlayerData.getDefaults().getHud().getSetting().getType());
                }
            }

            static {
                values = DisplayType.values();
            }
        }
    }

    public static class build {
        public static CTxT compile(Player player, ModuleInstructions instructions) {
            player.getPCache().getRainbow(HudColor.PRIMARY).setPosition(LoopManager.rainbowF);
            CTxT msg = CTxT.of("");
            int count = 0;
            for (BaseModule mod : ModuleManager.State.getEnabled(player)) {
                Module module = mod.getModuleType();
                ++count;
                if (instructions.get(module).isEmpty()) continue;
                msg.append(CUtl.parse(player, instructions.get(module)));
                if (count >= ModuleManager.State.getEnabled(player).size()) continue;
                msg.append(" ");
            }
            if (msg.isEmpty()) {
                return msg;
            }
            msg.click(3, "https://modrinth.com/mod/directionhud");
            return msg;
        }

        public static ModuleInstructions getModuleInstructions(Player player) {
            ModuleInstructions instructions = new ModuleInstructions();
            if (build.isEnabled(Module.COORDINATES)) {
                instructions.put(Module.COORDINATES, build.getCoordinatesModule(player));
            }
            if (build.isEnabled(Module.DESTINATION)) {
                instructions.put(Module.DESTINATION, build.getDestinationModule(player));
            }
            if (build.isEnabled(Module.DISTANCE)) {
                instructions.put(Module.DISTANCE, build.getDistanceModule(player));
            }
            if (build.isEnabled(Module.TRACKING)) {
                instructions.put(Module.TRACKING, build.getTrackingModule(player));
            }
            if (build.isEnabled(Module.DIRECTION)) {
                instructions.put(Module.DIRECTION, build.getDirectionModule(player));
            }
            if (build.isEnabled(Module.WEATHER)) {
                instructions.put(Module.WEATHER, build.getWeatherModule(player));
            }
            if (build.isEnabled(Module.TIME)) {
                instructions.put(Module.TIME, build.getTimeModule(player));
            }
            if (build.isEnabled(Module.ANGLE)) {
                instructions.put(Module.ANGLE, build.getAngleModule(player));
            }
            if (build.isEnabled(Module.SPEED)) {
                instructions.put(Module.SPEED, build.getSpeedModule(player));
            }
            if (build.isEnabled(Module.LIGHT)) {
                instructions.put(Module.LIGHT, build.getLightModule(player));
            }
            return instructions;
        }

        private static boolean isEnabled(Module module) {
            return Boolean.TRUE.equals(FileData.getConfig().getHud().getEnabledModules().get((Object)module));
        }

        public static String getCoordinatesModule(Player player) {
            ModuleCoordinates module = (ModuleCoordinates)player.getPCache().getHud().getModule(Module.COORDINATES);
            if (!module.isEnabled()) {
                return "";
            }
            return module.getDisplayString(player.getLoc());
        }

        public static String getDestinationModule(Player player) {
            ModuleDestination module = (ModuleDestination)player.getPCache().getHud().getModule(Module.DESTINATION);
            if (!module.isEnabled()) {
                return "";
            }
            Dest dest2 = Destination.dest.get(player);
            if (!dest2.hasXYZ()) {
                return "";
            }
            return module.getDisplayString(dest2);
        }

        public static String getDistanceModule(Player player) {
            ModuleDistance module = (ModuleDistance)player.getPCache().getHud().getModule(Module.DISTANCE);
            if (!module.isEnabled()) {
                return "";
            }
            int distance = Destination.dest.getDist(player);
            if (distance == -1) {
                return "";
            }
            return module.getDisplayString(distance);
        }

        public static String getTrackingModule(Player player) {
            Player target;
            ModuleTracking module = (ModuleTracking)player.getPCache().getHud().getModule(Module.TRACKING);
            if (!module.isEnabled()) {
                return "";
            }
            Loc pointLoc = null;
            ModuleTracking.Target trackingTarget = (ModuleTracking.Target)((Object)module.getSettingValue("tracking_target"));
            boolean hybrid = (Boolean)module.getSettingValue("tracking_hybrid");
            if ((trackingTarget.equals((Object)ModuleTracking.Target.player) || hybrid) && (target = Destination.social.track.getTarget(player)).isValid()) {
                Loc plLoc = new Loc(target);
                if (!player.getDimension().equals(target.getDimension())) {
                    if (Dimension.canConvert(player.getDimension(), target.getDimension()) && player.getPCache().getDEST().getDestSettings().getAutoconvert().booleanValue()) {
                        plLoc.convertTo(player.getDimension());
                    } else {
                        plLoc = null;
                    }
                }
                pointLoc = plLoc;
            }
            if ((trackingTarget.equals((Object)ModuleTracking.Target.dest) || hybrid && pointLoc == null) && Destination.dest.get(player).hasXYZ()) {
                pointLoc = Destination.dest.get(player);
            }
            if (pointLoc == null) {
                return "";
            }
            double rotation = player.getYaw() + 180.0f;
            return module.getDisplayString(rotation, player.getLoc(), pointLoc);
        }

        public static String getDirectionModule(Player player) {
            ModuleDirection module = (ModuleDirection)player.getPCache().getHud().getModule(Module.DIRECTION);
            if (!module.isEnabled()) {
                return "";
            }
            double rotation = player.getYaw() + 180.0f;
            return module.getDisplayString(rotation);
        }

        public static String getWeatherModule(Player player) {
            boolean night;
            ModuleWeather module = (ModuleWeather)player.getPCache().getHud().getModule(Module.WEATHER);
            DimensionEntry.Time timeSettings = Dimension.getTimeSettings(player.getDimension());
            DimensionEntry.Time.Weather weatherSettings = timeSettings.getWeather();
            if (!(module.isEnabled() && timeSettings.getEnabled().booleanValue() && weatherSettings.getEnabled().booleanValue())) {
                return "";
            }
            int timeTicks = player.getTimeOfDay();
            DimensionEntry.Time.Weather.NightTicks nightTicks = weatherSettings.getNightTicks();
            DimensionEntry.Time.Weather.Icons weatherIcons = weatherSettings.getIcons();
            String extraIcons = "";
            if (player.hasThunderstorm()) {
                extraIcons = weatherIcons.thunderstorm();
                night = Helper.Num.inBetween(timeTicks, nightTicks.thunderstorm().startTick().intValue(), nightTicks.thunderstorm().endTick().intValue());
            } else if (player.hasStorm()) {
                extraIcons = weatherIcons.storm();
                night = Helper.Num.inBetween(timeTicks, nightTicks.storm().startTick().intValue(), nightTicks.storm().endTick().intValue());
            } else {
                night = Helper.Num.inBetween(timeTicks, nightTicks.normal().startTick().intValue(), nightTicks.normal().endTick().intValue());
            }
            String weatherIcon = night ? weatherIcons.night() : weatherIcons.day();
            return module.getDisplayString(weatherIcon, extraIcons);
        }

        public static String getTimeModule(Player player) {
            ModuleTime module = (ModuleTime)player.getPCache().getHud().getModule(Module.TIME);
            DimensionEntry.Time timeSettings = Dimension.getTimeSettings(player.getDimension());
            if (!module.isEnabled() || !timeSettings.getEnabled().booleanValue()) {
                return "";
            }
            int timeTicks = player.getTimeOfDay();
            int hour = (timeTicks / 1000 + 6) % 24;
            int minute = timeTicks % 1000 * 60 / 1000;
            return module.getDisplayString(hour, minute);
        }

        public static String getAngleModule(Player player) {
            ModuleAngle module = (ModuleAngle)player.getPCache().getHud().getModule(Module.ANGLE);
            if (!module.isEnabled()) {
                return "";
            }
            return module.getDisplayString(Float.valueOf(player.getYaw()), Float.valueOf(player.getPitch()));
        }

        public static String getSpeedModule(Player player) {
            ModuleSpeed module = (ModuleSpeed)player.getPCache().getHud().getModule(Module.SPEED);
            if (!module.isEnabled()) {
                return "";
            }
            return module.getDisplayString(player.getPCache().getSpeedData().getSpeed());
        }

        public static String getLightModule(Player player) {
            ModuleLight module = (ModuleLight)player.getPCache().getHud().getModule(Module.LIGHT);
            if (!module.isEnabled()) {
                return "";
            }
            int[] lightLevel = player.getLightLevels(module.getSettingValue("light_target").equals((Object)ModuleLight.Target.eye));
            return module.getDisplayString(lightLevel[0], lightLevel[1]);
        }
    }
}

