/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.modules;

import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.BooleanModuleSettingHandler;
import one.oth3r.directionhud.common.utils.Helper;

public class ModuleTime
extends BaseModule {
    public static final String hour24ID = "time_24hr";
    public static final String DISPLAY_AM = "hour_AM";
    public static final String DISPLAY_PM = "hour_PM";
    public static final String DISPLAY_24 = "hour_24";

    public ModuleTime() {
        super(Module.TIME);
    }

    public ModuleTime(Integer order, boolean state, boolean hour24) {
        super(Module.TIME, order, state);
        this.registerSetting(hour24ID, hour24, new BooleanModuleSettingHandler(Module.TIME, hour24ID, true, false));
    }

    @Override
    protected String display(Object ... args) {
        int hourMod;
        boolean time12;
        int hour = (Integer)args[0];
        int minute = (Integer)args[1];
        boolean bl = time12 = (Boolean)this.getSettingValue(hour24ID) == false;
        String hr = time12 ? ((hourMod = hour % 12) == 0 ? String.valueOf(12) : String.valueOf(hourMod)) : Helper.Num.formatToTwoDigits(hour);
        String min = Helper.Num.formatToTwoDigits(minute);
        String formatString = time12 ? (hour >= 12 ? DISPLAY_PM : DISPLAY_AM) : DISPLAY_24;
        return DisplayRegistry.getFormatted(this.moduleType, formatString, hr, min);
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        DisplaySettings display = new DisplaySettings();
        display.addDisplay(DISPLAY_AM, "&2%s&1:&2%s &1AM");
        display.addDisplay(DISPLAY_PM, "&2%s&1:&2%s &1PM");
        display.addDisplay(DISPLAY_24, "&2%s&1:&2%s");
        return display;
    }
}

