/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.setting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSetting;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandlerRegistry;

final class DynamicModuleSettingTypeAdapter
extends TypeAdapter<ModuleSetting<?>> {
    private final Gson gson;

    DynamicModuleSettingTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, ModuleSetting<?> setting) throws IOException {
        out.beginObject();
        out.name("id").value(setting.getId());
        out.name("value");
        if (setting.getValue() == null) {
            out.nullValue();
        } else {
            this.gson.toJson(setting.getValue(), setting.getValue().getClass(), out);
        }
        out.endObject();
    }

    public ModuleSetting<?> read(JsonReader in) throws IOException {
        String id = null;
        JsonElement valueElement = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("id")) {
                id = in.nextString();
                continue;
            }
            if (name.equals("value")) {
                valueElement = JsonParser.parseReader((JsonReader)in);
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        if (id == null) {
            throw new JsonParseException("ModuleSetting missing 'id'");
        }
        ModuleSettingHandler validator = ModuleSettingHandlerRegistry.getHandler(id);
        if (validator == null) {
            throw new JsonParseException("No validator found for setting '" + id + "'. Make sure to load the modules first to register the correct validators.");
        }
        Class<?> valueClass = DynamicModuleSettingTypeAdapter.getValidatorValueClass(validator);
        if (valueClass == null) {
            throw new JsonParseException("Could not determine value type for setting id: " + id);
        }
        Object value = valueElement != null ? this.gson.fromJson(valueElement, valueClass) : null;
        return new ModuleSetting(id, value, validator, true);
    }

    private static Class<?> getValidatorValueClass(ModuleSettingHandler<?> validator) {
        ParameterizedType pt;
        Type arg;
        Type[] genericInterfaces;
        for (Type t : genericInterfaces = validator.getClass().getGenericInterfaces()) {
            Type arg2;
            Class raw;
            ParameterizedType pt2;
            Type type;
            if (!(t instanceof ParameterizedType) || !((type = (pt2 = (ParameterizedType)t).getRawType()) instanceof Class) || !ModuleSettingHandler.class.isAssignableFrom(raw = (Class)type) || !((arg2 = pt2.getActualTypeArguments()[0]) instanceof Class)) continue;
            Class c = (Class)arg2;
            return c;
        }
        Type superType = validator.getClass().getGenericSuperclass();
        if (superType instanceof ParameterizedType && (arg = (pt = (ParameterizedType)superType).getActualTypeArguments()[0]) instanceof Class) {
            Class c = (Class)arg;
            return c;
        }
        return null;
    }
}

