/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import java.awt.Color;
import one.oth3r.directionhud.utils.CTxT;

public class Rainbow {
    protected boolean enabled = false;
    protected float position = 0.0f;
    protected float stepSize = 5.0f;
    protected float brightness = 1.0f;
    protected float saturation = 1.0f;

    public Rainbow(boolean enabled, float position, float stepSize, float brightness, float saturation) {
        this.enabled = enabled;
        this.position = position;
        this.stepSize = stepSize;
        this.brightness = brightness;
        this.saturation = saturation;
    }

    public Rainbow(float position, float stepSize) {
        this.enabled = true;
        this.position = position;
        this.stepSize = stepSize;
    }

    public Rainbow() {
    }

    public Rainbow(Rainbow rainbow) {
        this.enabled = rainbow.enabled;
        this.position = rainbow.position;
        this.stepSize = rainbow.stepSize;
        this.brightness = rainbow.brightness;
        this.saturation = rainbow.saturation;
    }

    public Rainbow(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public CTxT colorize(String target, CTxT settings2) {
        if (!this.enabled) {
            return CTxT.of(target);
        }
        float hue = this.position;
        CTxT rainbow = CTxT.of("");
        for (int i = 0; i < target.codePointCount(0, target.length()); ++i) {
            if (target.charAt(i) == ' ') {
                rainbow.append(" ");
                continue;
            }
            Color color2 = Color.getHSBColor(hue / 360.0f, this.saturation, this.brightness);
            String hexColor = String.format("#%02x%02x%02x", color2.getRed(), color2.getGreen(), color2.getBlue());
            rainbow.append(((CTxT)((CTxT)((CTxT)((CTxT)((CTxT)((CTxT)((CTxT)CTxT.of(Character.toString(target.codePointAt(i))).color(hexColor)).bold(settings2.isBold())).italic(settings2.isItalic())).strikethrough(settings2.isStrikethrough())).underline(settings2.isUnderline())).obfuscate(settings2.isObfuscated())).click(settings2.getClick())).hover((CTxT)settings2.getHover()));
            hue = (hue + this.stepSize) % 360.0f;
        }
        this.position = hue;
        return rainbow;
    }
}

