/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks;

import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.EntityUtil;
import com.tacz.guns.util.TacHitResult;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.muksc.tacztweaks.compat.pillagers_gun.PillagersGunCompat;
import me.muksc.tacztweaks.data.BulletInteractionManager;
import me.muksc.tacztweaks.data.BulletParticlesManager;
import me.muksc.tacztweaks.data.BulletSoundsManager;
import me.muksc.tacztweaks.mixin.accessor.EntityKineticBulletAccessor;
import me.muksc.tacztweaks.mixininterface.features.EntityKineticBulletExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020!*\u00020\u001fH\u0002J\f\u0010\"\u001a\u00020#*\u00020\u001fH\u0002J\f\u0010$\u001a\u00020%*\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006&"}, d2={"Lme/muksc/tacztweaks/BulletRayTracer;", "", "entity", "Lcom/tacz/guns/entity/EntityKineticBullet;", "level", "Lnet/minecraft/server/level/ServerLevel;", "context", "Lnet/minecraft/world/level/ClipContext;", "<init>", "(Lcom/tacz/guns/entity/EntityKineticBullet;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/ClipContext;)V", "getEntity", "()Lcom/tacz/guns/entity/EntityKineticBullet;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "getContext", "()Lnet/minecraft/world/level/ClipContext;", "accessor", "Lme/muksc/tacztweaks/mixin/accessor/EntityKineticBulletAccessor;", "ext", "Lme/muksc/tacztweaks/mixininterface/features/EntityKineticBulletExtension;", "findEntitiesStart", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/phys/Vec3;", "handle", "Lnet/minecraft/world/phys/BlockHitResult;", "original", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "toBlockParticleType", "Lme/muksc/tacztweaks/data/BulletParticlesManager$EBlockParticleType;", "Lme/muksc/tacztweaks/data/BulletInteractionManager$InteractionResult;", "toEntityParticleType", "Lme/muksc/tacztweaks/data/BulletParticlesManager$EEntityParticleType;", "toBlockSoundType", "Lme/muksc/tacztweaks/data/BulletSoundsManager$EBlockSoundType;", "toEntitySoundType", "Lme/muksc/tacztweaks/data/BulletSoundsManager$EEntitySoundType;", "tacz-tweaks"})
@SourceDebugExtension(value={"SMAP\nBulletRayTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BulletRayTracer.kt\nme/muksc/tacztweaks/BulletRayTracer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1053#2:81\n*S KotlinDebug\n*F\n+ 1 BulletRayTracer.kt\nme/muksc/tacztweaks/BulletRayTracer\n*L\n33#1:81\n*E\n"})
public final class BulletRayTracer {
    @NotNull
    private final EntityKineticBullet entity;
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final ClipContext context;
    @NotNull
    private final EntityKineticBulletAccessor accessor;
    @NotNull
    private final EntityKineticBulletExtension ext;
    private Vec3 findEntitiesStart;

    public BulletRayTracer(@NotNull EntityKineticBullet entity, @NotNull ServerLevel level, @NotNull ClipContext context) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.entity = entity;
        this.level = level;
        this.context = context;
        EntityKineticBullet entityKineticBullet = this.entity;
        Intrinsics.checkNotNull((Object)entityKineticBullet, (String)"null cannot be cast to non-null type me.muksc.tacztweaks.mixin.accessor.EntityKineticBulletAccessor");
        this.accessor = (EntityKineticBulletAccessor)entityKineticBullet;
        EntityKineticBullet entityKineticBullet2 = this.entity;
        Intrinsics.checkNotNull((Object)entityKineticBullet2, (String)"null cannot be cast to non-null type me.muksc.tacztweaks.mixininterface.features.EntityKineticBulletExtension");
        this.ext = (EntityKineticBulletExtension)entityKineticBullet2;
        this.findEntitiesStart = this.context.m_45702_();
    }

    @NotNull
    public final EntityKineticBullet getEntity() {
        return this.entity;
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final ClipContext getContext() {
        return this.context;
    }

    @Nullable
    public final BlockHitResult handle(@NotNull BlockHitResult original, @Nullable BlockState state) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        List list = EntityUtil.findEntitiesOnPath((Projectile)((Projectile)this.entity), (Vec3)this.findEntitiesStart, (Vec3)original.m_82450_());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findEntitiesOnPath(...)");
        List entities = list;
        Iterable $this$sortedBy$iv = entities;
        boolean $i$f$sortedBy = false;
        for (EntityKineticBullet.EntityResult result : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ BulletRayTracer this$0;
            {
                this.this$0 = bulletRayTracer;
            }

            public final int compare(T a, T b) {
                EntityKineticBullet.EntityResult it = (EntityKineticBullet.EntityResult)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(BulletRayTracer.access$getFindEntitiesStart$p(this.this$0).m_82554_(it.getHitPos()));
                it = (EntityKineticBullet.EntityResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(BulletRayTracer.access$getFindEntitiesStart$p(this.this$0).m_82554_(it.getHitPos())));
            }
        })) {
            Entity owner = this.entity.m_19749_();
            if (owner != null) {
                Entity entity = result.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
                if (PillagersGunCompat.INSTANCE.shouldIgnore(entity, owner)) continue;
            }
            this.ext.tacztweaks$setPosition(result.getHitPos());
            BulletInteractionManager.InteractionResult interactionResult = BulletInteractionManager.INSTANCE.handleEntityInteraction(this.entity, new TacHitResult(result), this.context);
            BulletParticlesManager.EEntityParticleType eEntityParticleType = this.toEntityParticleType(interactionResult);
            Vec3 vec3 = result.getHitPos();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getHitPos(...)");
            Entity entity = result.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
            BulletParticlesManager.INSTANCE.handleEntityParticle(eEntityParticleType, this.level, this.entity, vec3, entity);
            BulletSoundsManager.EEntitySoundType eEntitySoundType = this.toEntitySoundType(interactionResult);
            Vec3 vec32 = result.getHitPos();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getHitPos(...)");
            Entity entity2 = result.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
            BulletSoundsManager.INSTANCE.handleEntitySound(eEntitySoundType, this.level, this.entity, vec32, entity2);
            if (interactionResult.getPierce()) continue;
            this.entity.m_146870_();
            return original;
        }
        this.ext.tacztweaks$setPosition(original.m_82450_());
        this.findEntitiesStart = original.m_82450_();
        if (original.m_6662_() == HitResult.Type.MISS || state == null) {
            return original;
        }
        BulletInteractionManager.InteractionResult interactionResult = BulletInteractionManager.INSTANCE.handleBlockInteraction(this.entity, original, state);
        BulletParticlesManager.INSTANCE.handleBlockParticle(this.toBlockParticleType(interactionResult), this.level, this.entity, original, state);
        BulletSoundsManager.INSTANCE.handleBlockSound(this.toBlockSoundType(interactionResult), this.level, this.entity, original, state);
        if (interactionResult.getPierce()) {
            return null;
        }
        this.accessor.invokeOnHitBlock(original, this.context.m_45702_(), this.context.m_45693_());
        return original;
    }

    private final BulletParticlesManager.EBlockParticleType toBlockParticleType(BulletInteractionManager.InteractionResult $this$toBlockParticleType) {
        return $this$toBlockParticleType.getCondition() ? BulletParticlesManager.EBlockParticleType.BREAK : ($this$toBlockParticleType.getPierce() ? BulletParticlesManager.EBlockParticleType.PIERCE : BulletParticlesManager.EBlockParticleType.HIT);
    }

    private final BulletParticlesManager.EEntityParticleType toEntityParticleType(BulletInteractionManager.InteractionResult $this$toEntityParticleType) {
        return $this$toEntityParticleType.getCondition() ? BulletParticlesManager.EEntityParticleType.KILL : ($this$toEntityParticleType.getPierce() ? BulletParticlesManager.EEntityParticleType.PIERCE : BulletParticlesManager.EEntityParticleType.HIT);
    }

    private final BulletSoundsManager.EBlockSoundType toBlockSoundType(BulletInteractionManager.InteractionResult $this$toBlockSoundType) {
        return $this$toBlockSoundType.getCondition() ? BulletSoundsManager.EBlockSoundType.BREAK : ($this$toBlockSoundType.getPierce() ? BulletSoundsManager.EBlockSoundType.PIERCE : BulletSoundsManager.EBlockSoundType.HIT);
    }

    private final BulletSoundsManager.EEntitySoundType toEntitySoundType(BulletInteractionManager.InteractionResult $this$toEntitySoundType) {
        return $this$toEntitySoundType.getCondition() ? BulletSoundsManager.EEntitySoundType.KILL : ($this$toEntitySoundType.getPierce() ? BulletSoundsManager.EEntitySoundType.PIERCE : BulletSoundsManager.EEntitySoundType.HIT);
    }

    public static final /* synthetic */ Vec3 access$getFindEntitiesStart$p(BulletRayTracer $this) {
        return $this.findEntitiesStart;
    }
}

