/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks.compat.soundphysics;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.muksc.tacztweaks.compat.soundphysics.SoundPhysicsTriggerSoundInstance;
import me.muksc.tacztweaks.compat.soundphysics.network.message.ServerMessageAirspaceSounds;
import me.muksc.tacztweaks.data.BulletSoundsManager;
import me.muksc.tacztweaks.network.CustomPacketPayload;
import me.muksc.tacztweaks.network.NetworkHandler;
import me.muksc.tacztweaks.network.StreamCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0012J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat;", "", "<init>", "()V", "enabled", "", "pendingSounds", "", "Ljava/util/UUID;", "Lme/muksc/tacztweaks/compat/soundphysics/network/message/ServerMessageAirspaceSounds;", "processingSound", "Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat$ProcessingSound;", "getProcessingSound", "()Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat$ProcessingSound;", "setProcessingSound", "(Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat$ProcessingSound;)V", "isEnabled", "initialize", "", "play", "minecraft", "Lnet/minecraft/client/Minecraft;", "packet", "onSoundEvaluationComplete", "runProcessing", "sound", "Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsTriggerSoundInstance;", "block", "Ljava/lang/Runnable;", "ProcessingSound", "tacz-tweaks"})
@SourceDebugExtension(value={"SMAP\nSoundPhysicsCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundPhysicsCompat.kt\nme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat\n+ 2 NetworkHandler.kt\nme/muksc/tacztweaks/network/NetworkHandler\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n83#2:66\n295#3,2:67\n*S KotlinDebug\n*F\n+ 1 SoundPhysicsCompat.kt\nme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat\n*L\n19#1:66\n36#1:67,2\n*E\n"})
public final class SoundPhysicsCompat {
    @NotNull
    public static final SoundPhysicsCompat INSTANCE = new SoundPhysicsCompat();
    private static boolean enabled;
    @NotNull
    private static final Map<UUID, ServerMessageAirspaceSounds> pendingSounds;
    @Nullable
    private static ProcessingSound processingSound;

    private SoundPhysicsCompat() {
    }

    @Nullable
    public final ProcessingSound getProcessingSound() {
        return processingSound;
    }

    public final void setProcessingSound(@Nullable ProcessingSound processingSound) {
        SoundPhysicsCompat.processingSound = processingSound;
    }

    public final boolean isEnabled() {
        return enabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize() {
        void codec$iv;
        void type$iv;
        void this_$iv;
        if (ModList.get().isLoaded("sound_physics_remastered")) {
            enabled = true;
        }
        NetworkHandler networkHandler = NetworkHandler.INSTANCE;
        CustomPacketPayload.Type<ServerMessageAirspaceSounds> type = ServerMessageAirspaceSounds.Companion.getTYPE();
        StreamCodec<ServerMessageAirspaceSounds> streamCodec = ServerMessageAirspaceSounds.Companion.getSTREAM_CODEC();
        ServerMessageAirspaceSounds.Companion companion = ServerMessageAirspaceSounds.Companion;
        NetworkHandler.ClientHandler handler$iv = new NetworkHandler.ClientHandler(companion){
            final /* synthetic */ ServerMessageAirspaceSounds.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(ServerMessageAirspaceSounds p0, Minecraft p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.handle(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, ServerMessageAirspaceSounds.Companion.class, "handle", "handle(Lme/muksc/tacztweaks/compat/soundphysics/network/message/ServerMessageAirspaceSounds;Lnet/minecraft/client/Minecraft;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof NetworkHandler.ClientHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        boolean $i$f$registerS2C = false;
        this_$iv.registerS2C(ServerMessageAirspaceSounds.class, type$iv, codec$iv, handler$iv);
    }

    public final void play(@NotNull Minecraft minecraft, @NotNull ServerMessageAirspaceSounds packet) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        UUID uuid = UUID.randomUUID();
        pendingSounds.put(uuid, packet);
        SoundManager soundManager = minecraft.m_91106_();
        Intrinsics.checkNotNull((Object)uuid);
        soundManager.m_120367_((SoundInstance)new SoundPhysicsTriggerSoundInstance(uuid, packet.getX(), packet.getY(), packet.getZ()));
    }

    public final void onSoundEvaluationComplete() {
        Object v5;
        block8: {
            ProcessingSound processingSound = SoundPhysicsCompat.processingSound;
            if (processingSound == null) {
                return;
            }
            ProcessingSound processing = processingSound;
            ServerMessageAirspaceSounds serverMessageAirspaceSounds = pendingSounds.get(processing.getSound().getUuid());
            if (serverMessageAirspaceSounds == null) {
                return;
            }
            ServerMessageAirspaceSounds pending = serverMessageAirspaceSounds;
            Float f = processing.getAirspace();
            if (f == null) {
                return;
            }
            float airspace = f.floatValue();
            Double d = processing.getOcclusionAccumulation();
            if (d == null) {
                return;
            }
            double occlusionAccumulation = d;
            Float f2 = processing.getReflectivity();
            if (f2 == null) {
                return;
            }
            float reflectivity = f2.floatValue() / (float)processing.getReflectivityDivider();
            BulletSoundsManager.INSTANCE.debug((Function0<String>)((Function0)() -> SoundPhysicsCompat.onSoundEvaluationComplete$lambda$0(airspace, occlusionAccumulation, reflectivity)));
            Iterable $this$firstOrNull$iv = pending.getSounds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ServerMessageAirspaceSounds.AirspaceSound it = (ServerMessageAirspaceSounds.AirspaceSound)element$iv;
                boolean bl = false;
                if (!(it.canPlayAtAirspace(airspace) && it.canPlayAtOcclusion(occlusionAccumulation) && it.canPlayAtReflectivity(reflectivity))) continue;
                v5 = element$iv;
                break block8;
            }
            v5 = null;
        }
        ServerMessageAirspaceSounds.AirspaceSound airspaceSound = v5;
        if (airspaceSound == null) {
            return;
        }
        ServerMessageAirspaceSounds.AirspaceSound sound = airspaceSound;
        ClientboundSoundPacket clientboundSoundPacket = sound.getPacket();
        if (clientboundSoundPacket == null) {
            return;
        }
        ClientboundSoundPacket packet = clientboundSoundPacket;
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> SoundPhysicsCompat.onSoundEvaluationComplete$lambda$2(minecraft, packet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runProcessing(@NotNull SoundPhysicsTriggerSoundInstance sound, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)((Object)sound), (String)"sound");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        try {
            processingSound = new ProcessingSound(sound);
            block.run();
        }
        finally {
            processingSound = null;
            pendingSounds.remove(sound.getUuid());
        }
    }

    private static final String onSoundEvaluationComplete$lambda$0(float $airspace, double $occlusionAccumulation, float $reflectivity) {
        return "airspace: " + $airspace + ", occlusion: " + $occlusionAccumulation + ", reflectivity: " + $reflectivity;
    }

    private static final void onSoundEvaluationComplete$lambda$2(Minecraft $minecraft, ClientboundSoundPacket $packet) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
            ClientPacketListener clientPacketListener = $minecraft.m_91403_();
            if (clientPacketListener == null) break block0;
            clientPacketListener.m_8068_($packet);
        }
    }

    static {
        pendingSounds = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsCompat$ProcessingSound;", "", "sound", "Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsTriggerSoundInstance;", "<init>", "(Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsTriggerSoundInstance;)V", "getSound", "()Lme/muksc/tacztweaks/compat/soundphysics/SoundPhysicsTriggerSoundInstance;", "airspace", "", "getAirspace", "()Ljava/lang/Float;", "setAirspace", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "occlusionAccumulation", "", "getOcclusionAccumulation", "()Ljava/lang/Double;", "setOcclusionAccumulation", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "reflectivity", "getReflectivity", "setReflectivity", "reflectivityDivider", "", "getReflectivityDivider", "()I", "setReflectivityDivider", "(I)V", "tacz-tweaks"})
    public static final class ProcessingSound {
        @NotNull
        private final SoundPhysicsTriggerSoundInstance sound;
        @Nullable
        private Float airspace;
        @Nullable
        private Double occlusionAccumulation;
        @Nullable
        private Float reflectivity;
        private int reflectivityDivider;

        public ProcessingSound(@NotNull SoundPhysicsTriggerSoundInstance sound) {
            Intrinsics.checkNotNullParameter((Object)((Object)sound), (String)"sound");
            this.sound = sound;
            this.reflectivityDivider = 1;
        }

        @NotNull
        public final SoundPhysicsTriggerSoundInstance getSound() {
            return this.sound;
        }

        @Nullable
        public final Float getAirspace() {
            return this.airspace;
        }

        public final void setAirspace(@Nullable Float f) {
            this.airspace = f;
        }

        @Nullable
        public final Double getOcclusionAccumulation() {
            return this.occlusionAccumulation;
        }

        public final void setOcclusionAccumulation(@Nullable Double d) {
            this.occlusionAccumulation = d;
        }

        @Nullable
        public final Float getReflectivity() {
            return this.reflectivity;
        }

        public final void setReflectivity(@Nullable Float f) {
            this.reflectivity = f;
        }

        public final int getReflectivityDivider() {
            return this.reflectivityDivider;
        }

        public final void setReflectivityDivider(int n) {
            this.reflectivityDivider = n;
        }
    }
}

