/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks.mixin.tweaks;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.tacz.guns.client.sound.GunSoundInstance;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import me.muksc.tacztweaks.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={GunSoundInstance.class}, remap=false)
public abstract class GunSoundInstanceMixin {
    @WrapOperation(method={"getSoundBuffer"}, at={@At(value="INVOKE", target="Ljavax/sound/sampled/AudioFormat;getFrameSize()I")})
    private int tacztweaks$getSoundBuffer$monoFrameSize(AudioFormat instance, Operation<Integer> original) {
        if (!Config.Tweaks.INSTANCE.betterMonoConversion()) {
            return (Integer)original.call(new Object[]{instance});
        }
        if (!GunSoundInstanceMixin.tacztweaks$isBetterMonoCompatible(instance)) {
            return (Integer)original.call(new Object[]{instance});
        }
        return instance.getSampleSizeInBits() / 8;
    }

    @ModifyExpressionValue(method={"getSoundBuffer"}, at={@At(value="INVOKE", target="Lcom/tacz/guns/client/resource/manager/SoundAssetsManager$SoundData;byteBuffer()Ljava/nio/ByteBuffer;", ordinal=0)})
    private ByteBuffer tacztweaks$getSoundBuffer$betterMono(ByteBuffer original, @Local(ordinal=0) AudioFormat rawFormat) {
        if (!Config.Tweaks.INSTANCE.betterMonoConversion()) {
            return original;
        }
        if (!GunSoundInstanceMixin.tacztweaks$isBetterMonoCompatible(rawFormat)) {
            return original;
        }
        int sampleSizeInBits = rawFormat.getSampleSizeInBits();
        ByteBuffer monoBuffer = ByteBuffer.allocateDirect(original.remaining() / 2);
        monoBuffer.order(original.order());
        if (sampleSizeInBits == 16) {
            ShortBuffer stereoShortBuffer = original.asShortBuffer();
            while (stereoShortBuffer.hasRemaining()) {
                short left = stereoShortBuffer.get();
                short right = stereoShortBuffer.get();
                short mono = (short)((left + right) / 2);
                monoBuffer.putShort(mono);
            }
        } else if (sampleSizeInBits == 8) {
            while (original.hasRemaining()) {
                byte left = original.get();
                byte right = original.get();
                byte mono = (byte)((left + right) / 2);
                monoBuffer.put(mono);
            }
        } else {
            throw new AssertionError((Object)("Somehow better mono incompatible audio got through: " + sampleSizeInBits));
        }
        monoBuffer.flip();
        return monoBuffer;
    }

    @Unique
    private static boolean tacztweaks$isBetterMonoCompatible(AudioFormat format) {
        int sampleSizeInBits = format.getSampleSizeInBits();
        return sampleSizeInBits == 16 || sampleSizeInBits == 8;
    }
}

