/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.hooks;

import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface CustomBarDisplayModifierHook {
    public String barId(IToolStackView var1, ModifierEntry var2, int var3);

    public boolean showBar(IToolStackView var1, ModifierEntry var2, int var3);

    public Vec2 getBarXYSize(IToolStackView var1, ModifierEntry var2, int var3);

    default public Vec2 getBarXYPos(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return new Vec2(2.0f, (float)(13 - barsHadBeenShown));
    }

    public int getBarRGB(IToolStackView var1, ModifierEntry var2, int var3);

    default public RenderType getRenderType(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return RenderType.m_286086_();
    }

    default public boolean showShadow(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return true;
    }

    default public Vec2 getShadowXYSize(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return barsHadBeenShown > 0 ? new Vec2(13.0f, 1.0f) : new Vec2(13.0f, 2.0f);
    }

    default public Vec2 getShadowXYOffset(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return new Vec2(0.0f, 0.0f);
    }

    public record FirstMerger(Collection<CustomBarDisplayModifierHook> modules) implements CustomBarDisplayModifierHook
    {
        @Override
        public String barId(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            String s = null;
            for (CustomBarDisplayModifierHook modules : this.modules) {
                s = modules.barId(tool, entry, barsHadBeenShown);
                if (s == null) continue;
                return s;
            }
            return s;
        }

        @Override
        public boolean showBar(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            for (CustomBarDisplayModifierHook modules : this.modules) {
                if (!modules.showBar(tool, entry, barsHadBeenShown)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Vec2 getBarXYSize(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            Vec2 vec2 = null;
            for (CustomBarDisplayModifierHook modules : this.modules) {
                vec2 = modules.getBarXYSize(tool, entry, barsHadBeenShown);
            }
            return vec2;
        }

        @Override
        public Vec2 getBarXYPos(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            Vec2 vec2 = null;
            for (CustomBarDisplayModifierHook modules : this.modules) {
                vec2 = modules.getBarXYPos(tool, entry, barsHadBeenShown);
            }
            return vec2;
        }

        @Override
        public int getBarRGB(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            int col = 0;
            for (CustomBarDisplayModifierHook modules : this.modules) {
                col = modules.getBarRGB(tool, entry, barsHadBeenShown);
            }
            return col;
        }

        @Override
        public boolean showShadow(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            Iterator<CustomBarDisplayModifierHook> iterator = this.modules.iterator();
            if (iterator.hasNext()) {
                CustomBarDisplayModifierHook modules = iterator.next();
                return modules.showShadow(tool, entry, barsHadBeenShown);
            }
            return true;
        }

        @Override
        public Vec2 getShadowXYSize(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            Vec2 vec2 = barsHadBeenShown > 0 ? new Vec2(13.0f, 1.0f) : new Vec2(13.0f, 2.0f);
            for (CustomBarDisplayModifierHook modules : this.modules) {
                vec2 = modules.getShadowXYSize(tool, entry, barsHadBeenShown);
            }
            return vec2;
        }

        @Override
        public Vec2 getShadowXYOffset(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            Vec2 vec2 = new Vec2(0.0f, 0.0f);
            for (CustomBarDisplayModifierHook modules : this.modules) {
                vec2 = modules.getShadowXYOffset(tool, entry, barsHadBeenShown);
            }
            return vec2;
        }

        @Override
        public RenderType getRenderType(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
            RenderType renderType = RenderType.m_286086_();
            for (CustomBarDisplayModifierHook modules : this.modules) {
                renderType = modules.getRenderType(tool, entry, barsHadBeenShown);
            }
            return renderType;
        }
    }
}

