/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.hooks;

import com.c2h6s.etstlib.content.misc.vibration.ToolVibrationAcceptor;
import com.c2h6s.etstlib.content.misc.vibration.ToolVibrationListener;
import com.c2h6s.etstlib.content.misc.vibration.VibrationContext;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface VibrationListeningModifierHook
extends EquipmentChangeModifierHook {
    public static void handleVibration(Player player, ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, @Nullable Entity directEntity, @Nullable Entity projectileOwner, float pDistance, int frequency, ToolVibrationAcceptor acceptor) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(slot);
            if (!(stack.m_41720_() instanceof IModifiable)) continue;
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            VibrationContext context = new VibrationContext(pLevel, pPos, pGameEvent, directEntity, projectileOwner, pDistance, frequency, acceptor);
            toolStack.getModifierList().forEach(modifier -> {
                if (((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).canReceiveVibration((IToolStackView)toolStack, (ModifierEntry)modifier, player, pLevel, slot, context)) {
                    ((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).onReceivingVibration((IToolStackView)toolStack, (ModifierEntry)modifier, player, pLevel, slot, context);
                }
            });
        }
    }

    public static boolean validateVibration(Player player, ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, GameEvent.Context pContext, float distance, ToolVibrationAcceptor acceptor) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(slot);
            if (!(stack.m_41720_() instanceof IModifiable)) continue;
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            VibrationContext context = new VibrationContext(pLevel, pPos, pGameEvent, new VibrationInfo(pGameEvent, distance, new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), pContext.f_223711_()), acceptor);
            for (ModifierEntry modifier : toolStack.getModifierList()) {
                if (!((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).canReceiveVibration((IToolStackView)toolStack, modifier, player, pLevel, slot, context)) continue;
                return true;
            }
        }
        return false;
    }

    public UUID getAcceptorUUID(IToolStackView var1, ModifierEntry var2, Player var3, Level var4, EquipmentSlot var5);

    default public void onAcceptorTick(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, int acceptorLevel) {
    }

    public int listenRange(IToolStackView var1, ModifierEntry var2, Player var3, Level var4, EquipmentSlot var5, int var6);

    public boolean canReceiveVibration(IToolStackView var1, ModifierEntry var2, Player var3, ServerLevel var4, EquipmentSlot var5, VibrationContext var6);

    public void onReceivingVibration(IToolStackView var1, ModifierEntry var2, Player var3, ServerLevel var4, EquipmentSlot var5, VibrationContext var6);

    default public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = context.getLevel();
            if (livingEntity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                UUID acceptorUUID = ((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).getAcceptorUUID(tool, modifier, player, (Level)serverLevel, context.getChangedSlot());
                if (acceptorUUID != null) {
                    boolean noListener;
                    int range = ((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).listenRange(tool, modifier, player, (Level)serverLevel, context.getChangedSlot(), 16);
                    ToolVibrationListener listener = ToolVibrationListener.listenerMap.get(player);
                    boolean bl = noListener = listener == null;
                    if (noListener) {
                        listener = new ToolVibrationListener(player);
                    }
                    ToolVibrationAcceptor acceptor = new ToolVibrationAcceptor(range, acceptorUUID, modifier.getLevel());
                    listener.addAcceptor(acceptor);
                    ToolVibrationListener.listenerMap.put(player, listener);
                    if (noListener) {
                        player.m_213651_(DynamicGameEventListener::m_223617_);
                    }
                }
            }
        }
    }

    default public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = context.getLevel();
            if (livingEntity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                UUID acceptorUUID = ((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).getAcceptorUUID(tool, modifier, player, (Level)serverLevel, context.getChangedSlot());
                if (acceptorUUID != null) {
                    ToolVibrationListener.decreaseLevel(player, acceptorUUID, modifier.getLevel());
                }
            }
        }
    }

    public record AllMerger(Collection<VibrationListeningModifierHook> modules) implements VibrationListeningModifierHook
    {
        @Override
        public UUID getAcceptorUUID(IToolStackView tool, ModifierEntry modifier, Player player, Level level, EquipmentSlot slot) {
            for (VibrationListeningModifierHook module : this.modules) {
                UUID uuid = module.getAcceptorUUID(tool, modifier, player, level, slot);
                if (uuid == null) continue;
                return uuid;
            }
            return null;
        }

        @Override
        public int listenRange(IToolStackView tool, ModifierEntry modifier, Player player, Level level, EquipmentSlot slot, int range) {
            for (VibrationListeningModifierHook module : this.modules) {
                range = module.listenRange(tool, modifier, player, level, slot, range);
            }
            return range;
        }

        @Override
        public boolean canReceiveVibration(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, VibrationContext context) {
            for (VibrationListeningModifierHook module : this.modules) {
                if (!module.canReceiveVibration(tool, modifier, player, level, slot, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onReceivingVibration(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, VibrationContext context) {
            for (VibrationListeningModifierHook module : this.modules) {
                if (!module.canReceiveVibration(tool, modifier, player, level, slot, context)) continue;
                module.onReceivingVibration(tool, modifier, player, level, slot, context);
            }
        }

        @Override
        public void onAcceptorTick(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, int acceptorLevel) {
            for (VibrationListeningModifierHook module : this.modules) {
                module.onAcceptorTick(tool, modifier, player, level, slot, acceptorLevel);
            }
        }
    }
}

