/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class EntityInRangeUtil {
    public static ToDoubleFunction<? super Entity> toManhattanDistance(Entity entity) {
        return value -> Math.abs(value.m_20185_() - entity.m_20185_() + value.m_20186_() - entity.m_20186_());
    }

    public static ToDoubleFunction<? super Entity> toReverseManhattanDistance(Entity entity) {
        return value -> -Math.abs(value.m_20185_() - entity.m_20185_() + value.m_20186_() - entity.m_20186_());
    }

    public static ToDoubleFunction<? super Entity> toActualDistance(Entity entity) {
        return e -> e.m_20270_(entity);
    }

    public static Entity getNearestEntity(@NotNull Entity centerEntity, float range, @NotNull IntOpenHashSet ignoreEntityIds, @NotNull Predicate<Entity> predicate) {
        List list = centerEntity.m_9236_().m_45976_(Entity.class, new AABB(centerEntity.m_20183_()).m_82400_((double)range));
        list.sort(Comparator.comparingDouble(EntityInRangeUtil.toActualDistance(centerEntity)));
        for (Entity entity : list) {
            if (ignoreEntityIds.contains(entity.m_19879_()) || !predicate.test(entity) || entity == centerEntity) continue;
            return entity;
        }
        return null;
    }

    public static LivingEntity getNearestLivingEntity(@NotNull Entity centerEntity, float range, @NotNull IntOpenHashSet ignoreEntityIds, @NotNull Predicate<Entity> predicate) {
        List list = centerEntity.m_9236_().m_45976_(LivingEntity.class, new AABB(centerEntity.m_20183_()).m_82400_((double)range));
        list.sort(Comparator.comparingDouble(EntityInRangeUtil.toActualDistance(centerEntity)));
        for (LivingEntity entity : list) {
            if (ignoreEntityIds.contains(entity.m_19879_()) || !predicate.test((Entity)entity) || entity == centerEntity) continue;
            return entity;
        }
        return null;
    }

    public static LivingEntity getNearestNotFriendlyLivingEntity(@NotNull Entity centerEntity, float range, @NotNull IntOpenHashSet ignoreEntityIds, @NotNull Predicate<Entity> predicate) {
        List list = centerEntity.m_9236_().m_45976_(LivingEntity.class, new AABB(centerEntity.m_20183_()).m_82400_((double)range));
        list.sort(Comparator.comparingDouble(EntityInRangeUtil.toActualDistance(centerEntity)));
        for (LivingEntity entity : list) {
            if (ignoreEntityIds.contains(entity.m_19879_()) || !predicate.test((Entity)entity) || entity.m_6095_().m_20674_().m_21609_() || entity == centerEntity) continue;
            return entity;
        }
        return null;
    }
}

