/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.Integration.PnCIntegration;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.tool.modifiers.base.BasicPressurizableModifier;
import com.c2h6s.etstlib.tool.modifiers.capabilityProvider.PnCIntegration.AirStorageProvider;
import com.c2h6s.etstlib.util.EquipmentUtil;
import com.c2h6s.etstlib.util.UUIDUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class AerialReinforced
extends BasicPressurizableModifier
implements BreakSpeedModifierHook,
ProjectileLaunchModifierHook,
AttributesModifierHook {
    public static final ResourceLocation KEY_DAMAGE = EtSTLib.getResourceLocation("arrow_multiplier_aerial");

    @Override
    protected void registerHooks(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.ATTRIBUTES});
    }

    @Override
    public int getBaseVolume(ModifierEntry entry) {
        return 5000 * entry.getLevel();
    }

    @Override
    public float getMaxPressure(ModifierEntry entry) {
        return 10 * entry.getLevel();
    }

    @Override
    public int onDamageTool(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, int amount, @Nullable LivingEntity livingEntity) {
        if (100 * amount < AirStorageProvider.getAir(tool)) {
            AirStorageProvider.addAir(tool, -100 * amount);
            return 0;
        }
        if (AirStorageProvider.getAir(tool) > 100) {
            int minus = AirStorageProvider.getAir(tool) / 100;
            AirStorageProvider.addAir(tool, -100 * minus);
            return amount - minus;
        }
        return amount;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction direction, boolean isEffective, float miningSpeedModifier) {
        Optional pos = event.getPosition();
        if (!isEffective || pos.isEmpty()) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * (1.0f + this.getBonus(tool, modifier)));
    }

    public float getBonus(IToolStackView tool, ModifierEntry modifier) {
        return AirStorageProvider.getPressure(tool) > 0.0f ? AirStorageProvider.getPressure(tool) / 40.0f : 0.0f;
    }

    @Override
    public float getMeleeDamage(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, @NotNull ToolAttackContext context, float baseDamage, float damage) {
        float multiplier = 1.0f + this.getBonus(tool, modifier);
        if (AirStorageProvider.getAir(tool) > 100) {
            AirStorageProvider.addAir(tool, -((int)(100.0f * multiplier)));
            return damage * multiplier;
        }
        return damage;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        super.addTooltip(tool, modifierEntry, player, list, tooltipKey, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"tooltip.etstlib.pressure_bonus").m_130946_(" +").m_130946_(String.format("%.1f", Float.valueOf(this.getBonus(tool, modifierEntry) * 100.0f))).m_130946_("%").m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public void onProjectileLaunch(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, @NotNull LivingEntity shooter, @NotNull Projectile projectile, @javax.annotation.Nullable AbstractArrow arrow, @NotNull ModDataNBT persistentData, boolean primary) {
        float multiplier = this.getBonus(tool, modifier);
        if (AirStorageProvider.getAir(tool) > 100 && arrow != null) {
            AirStorageProvider.addAir(tool, -((int)(100.0f * multiplier)));
            persistentData.putFloat(KEY_DAMAGE, multiplier);
        }
    }

    @Override
    public float onGetArrowDamage(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull Entity target, float baseDamage, float damage) {
        return damage += baseDamage * persistentData.getFloat(KEY_DAMAGE);
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        if (this.getBonus(tool, modifier) > 0.0f) {
            UUID uuid = UUIDUtil.getUUIDFromTool(tool, modifier.getId(), equipmentSlot);
            if (EquipmentUtil.ARMOR.contains(equipmentSlot)) {
                biConsumer.accept(Attributes.f_22284_, new AttributeModifier(uuid, Attributes.f_22284_.m_22087_(), (double)(this.getBonus(tool, modifier) * ((Float)tool.getStats().get((IToolStat)ToolStats.ARMOR)).floatValue()), AttributeModifier.Operation.ADDITION));
                biConsumer.accept(Attributes.f_22285_, new AttributeModifier(uuid, Attributes.f_22285_.m_22087_(), (double)(this.getBonus(tool, modifier) * ((Float)tool.getStats().get((IToolStat)ToolStats.ARMOR_TOUGHNESS)).floatValue()), AttributeModifier.Operation.ADDITION));
                biConsumer.accept(Attributes.f_22278_, new AttributeModifier(uuid, Attributes.f_22278_.m_22087_(), (double)(this.getBonus(tool, modifier) * ((Float)tool.getStats().get((IToolStat)ToolStats.KNOCKBACK_RESISTANCE)).floatValue()), AttributeModifier.Operation.ADDITION));
            } else if (EquipmentUtil.HAND.contains(equipmentSlot)) {
                biConsumer.accept(Attributes.f_22283_, new AttributeModifier(uuid, Attributes.f_22283_.m_22087_(), (double)(this.getBonus(tool, modifier) * ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue()), AttributeModifier.Operation.ADDITION));
            }
        }
    }
}

