/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.DistExecutor;

public class DynamicComponentUtil {

    public static class BreathColorfulText {
        public static Component getColorfulText(String translatableText, @Nullable String append, int color, int totalSteps, int durationMs, boolean isTranslatable) {
            return (Component)DistExecutor.unsafeRunForDist(() -> () -> BreathColorfulText.buildBreathText(translatableText, append, color, totalSteps, durationMs, isTranslatable), () -> () -> Component.m_237115_((String)translatableText));
        }

        private static MutableComponent buildBreathText(String textKey, @Nullable String append, int color, int totalSteps, int durationMs, boolean isTranslatable) {
            String fullText = BreathColorfulText.getLocalizedText(textKey, isTranslatable) + Optional.ofNullable(append).orElse("");
            int[] breathColors = BreathColorfulText.generateRGBBreathWave(color, totalSteps);
            long cyclePosition = System.currentTimeMillis() % (long)durationMs;
            int colorIndex = (int)(cyclePosition * (long)totalSteps / (long)durationMs) % totalSteps;
            return BreathColorfulText.buildColoredComponents(fullText, breathColors[colorIndex]);
        }

        private static String getLocalizedText(String key, boolean translatable) {
            return translatable ? Language.m_128107_().m_6834_(key) : key;
        }

        private static MutableComponent buildColoredComponents(String text, int color) {
            MutableComponent component = Component.m_237119_();
            TextColor textColor = TextColor.m_131266_((int)(color & 0xFFFFFF));
            for (char c : text.toCharArray()) {
                component.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_131148_(textColor)));
            }
            return component;
        }

        private static int[] generateRGBBreathWave(int baseColor, int totalSteps) {
            int r = baseColor >> 16 & 0xFF;
            int g = baseColor >> 8 & 0xFF;
            int b = baseColor & 0xFF;
            int[] wave = new int[totalSteps];
            for (int i = 0; i < totalSteps; ++i) {
                float ratio = 0.8f * (float)Math.abs(Math.sin(Math.PI * (double)i / (double)totalSteps)) + 0.2f;
                int dr = Mth.m_14045_((int)((int)((float)r * ratio)), (int)0, (int)255);
                int dg = Mth.m_14045_((int)((int)((float)g * ratio)), (int)0, (int)255);
                int db = Mth.m_14045_((int)((int)((float)b * ratio)), (int)0, (int)255);
                wave[i] = dr << 16 | dg << 8 | db;
            }
            return wave;
        }
    }

    public static class ScrollColorfulText {
        public static Component getColorfulText(String translatableText, String append, int[] colors, int step, int durationMs, boolean isTranslatable) {
            return (Component)DistExecutor.unsafeRunForDist(() -> () -> ScrollColorfulText.buildGradientText(translatableText, append, colors, step, durationMs, isTranslatable), () -> () -> Component.m_237115_((String)translatableText));
        }

        private static MutableComponent buildGradientText(String textKey, @Nullable String append, int[] colors, int step, int durationMs, boolean isTranslatable) {
            String safeAppend = append != null ? append : "";
            String localizedText = isTranslatable ? Language.m_128107_().m_6834_(textKey) : textKey;
            String fullText = localizedText + safeAppend;
            int effectiveDuration = Math.max(1, durationMs);
            int[] gradientColors = ScrollColorfulText.generateLinearGradient(colors, step);
            if (gradientColors.length < 2) {
                gradientColors = new int[]{0xFFFFFF, 0};
            }
            int cycleLength = 2 * (gradientColors.length - 1);
            long timestamp = System.currentTimeMillis();
            MutableComponent result = Component.m_237119_();
            for (int i = 0; i < fullText.length(); ++i) {
                long timeStep = timestamp / (long)effectiveDuration;
                long rawProgress = (long)i + timeStep;
                int progress = Math.floorMod(rawProgress, cycleLength);
                int colorIndex = gradientColors.length - 1 - Math.abs(progress - (gradientColors.length - 1));
                if (colorIndex < 0 || colorIndex >= gradientColors.length) {
                    colorIndex = Math.max(0, Math.min(colorIndex, gradientColors.length - 1));
                }
                result.m_7220_((Component)Component.m_237113_((String)String.valueOf(fullText.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)gradientColors[colorIndex]))));
            }
            return result;
        }

        private static int[] generateLinearGradient(int[] colors, int totalSteps) {
            if (colors == null || colors.length == 0) {
                throw new IllegalArgumentException("Colors array must not be null or empty");
            }
            if (totalSteps <= 0) {
                return new int[0];
            }
            if (colors.length == 1) {
                int[] gradient = new int[totalSteps];
                Arrays.fill(gradient, colors[0]);
                return gradient;
            }
            int[] gradient = new int[totalSteps];
            int segments = colors.length - 1;
            int stepsPerSegment = totalSteps / segments;
            int remainder = totalSteps % segments;
            int startIndex = 0;
            for (int i = 0; i < segments; ++i) {
                int currentSteps = stepsPerSegment + (i == segments - 1 ? remainder : 0);
                int startColor = colors[i];
                int endColor = colors[i + 1];
                float r1 = startColor >> 16 & 0xFF;
                float g1 = startColor >> 8 & 0xFF;
                float b1 = startColor & 0xFF;
                float r2 = endColor >> 16 & 0xFF;
                float g2 = endColor >> 8 & 0xFF;
                float b2 = endColor & 0xFF;
                for (int j = 0; j < currentSteps; ++j) {
                    float t = currentSteps == 1 ? 0.0f : (float)j / (float)(currentSteps - 1);
                    int r = (int)(r1 + (r2 - r1) * t);
                    int g = (int)(g1 + (g2 - g1) * t);
                    int b = (int)(b1 + (b2 - b1) * t);
                    int index = startIndex + j;
                    if (index >= totalSteps) continue;
                    gradient[index] = r << 16 | g << 8 | b;
                }
                startIndex += currentSteps;
            }
            return gradient;
        }
    }
}

