/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

public class MathUtil {
    public static String getUnitInt(int amount) {
        int a = (int)Math.log10(amount);
        int b = a / 3;
        switch (b) {
            case 1: {
                return String.format("%.2f", (double)amount / 1000.0) + " k";
            }
            case 2: {
                return String.format("%.2f", (double)amount / 1000000.0) + " M";
            }
            case 3: {
                return String.format("%.2f", (double)amount / 1.0E9) + " G";
            }
        }
        return amount + " ";
    }

    public static String getUnitFloat(double amount) {
        String unit;
        double bitRaw;
        bitRaw += (bitRaw = Math.log10(Math.abs(amount))) <= 0.0 ? -3.0 : 0.0;
        int bits = (int)(bitRaw /= 3.0);
        if (bits > 5) {
            unit = " P";
            amount *= (double)1.0E-15f;
        } else if (bits < -5) {
            unit = " f";
            amount *= (double)1.0E15f;
        } else {
            unit = switch (bits) {
                case -4 -> " p";
                case -3 -> " n";
                case -2 -> " \u03bc";
                case -1 -> " m";
                case 0 -> " ";
                case 1 -> " k";
                case 2 -> " M";
                case 3 -> " G";
                case 4 -> " T";
                case 5 -> " P";
                default -> " f";
            };
            amount *= (double)((float)Math.pow(1000.0, -bits));
        }
        return String.format("%.2f", amount) + unit;
    }

    public static String getUnitForFluid(int amount) {
        int a = (int)Math.log10(amount);
        int b = a / 3;
        switch (b) {
            case 1: {
                return String.format("%.2f", (double)amount / 1000.0) + " B";
            }
            case 2: {
                return String.format("%.2f", (double)amount / 1000000.0) + " kB";
            }
            case 3: {
                return String.format("%.2f", (double)amount / 1.0E9) + " MB";
            }
        }
        return amount + " mB";
    }

    public static double getDecimal(double number) {
        return number - (double)((int)number);
    }

    public static double limitsNumber(double number, int limit) {
        if (limit < 0) {
            limit = 0;
        }
        double scale = Math.pow(10.0, limit);
        return (double)Math.round(number * scale) / scale;
    }

    public static String getEnergyString(int amount) {
        return MathUtil.getUnitInt(amount) + "FE";
    }

    public static String toPercentage(double number, int limit) {
        return MathUtil.limitsNumber(number, limit + 2) * 100.0 + "%";
    }
}

