/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.fluid.fluidEffect;

import com.c2h6s.etstlib.util.MathUtil;
import com.c2h6s.etstlib.util.ModListConstants;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record RadiateEntityFluidEffect(LevelingValue amount) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<RadiateEntityFluidEffect> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("radiation_amount", RadiateEntityFluidEffect::amount), RadiateEntityFluidEffect::new);

    @NotNull
    public RecordLoadable<? extends FluidEffect<FluidEffectContext.Entity>> getLoader() {
        return LOADER;
    }

    public float apply(FluidStack fluidStack, EffectLevel effectLevel, FluidEffectContext.Entity context, IFluidHandler.FluidAction fluidAction) {
        if (!ModListConstants.MekLoaded) {
            throw new IllegalStateException("Mekanism mod is needed for RadiateEntityFluidEffect to work.");
        }
        float value = this.amount.compute(effectLevel.value());
        if (value == 0.0f) {
            return 0.0f;
        }
        if (fluidAction.execute()) {
            RadiationManager manager = RadiationManager.get();
            if (context.getLivingTarget() != null) {
                manager.radiate(context.getLivingTarget(), (double)value);
            } else {
                return 0.0f;
            }
        }
        return this.amount.isFlat() ? 1.0f : effectLevel.value();
    }

    public Component getDescription(RegistryAccess registryAccess) {
        return FluidEffect.makeTranslation(LOADER, (Object[])new Object[]{MathUtil.getUnitFloat(this.amount.computeForLevel(1.0f)) + "Sv"});
    }
}

