/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.Common;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.etstlib.util.EquipmentUtil;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class MomentumAccelerate
extends EtSTBaseModifier
implements ToolStatsModifierHook,
AttributesModifierHook,
BreakSpeedModifierHook,
BlockBreakModifierHook {
    public static final ResourceLocation LOCATION_ACCEL = EtSTLib.getResourceLocation("momentum_accelerate");

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (tool.getPersistentData().getFloat(LOCATION_ACCEL) > 0.0f && !world.f_46443_ && world.m_46467_() % 10L == 0L) {
            tool.getPersistentData().putFloat(LOCATION_ACCEL, tool.getPersistentData().getFloat(LOCATION_ACCEL) - 0.01f * (float)modifier.getLevel());
        }
    }

    @Override
    protected void registerHooks(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_STATS, ModifierHooks.ATTRIBUTES, ModifierHooks.BREAK_SPEED, ModifierHooks.BLOCK_BREAK});
    }

    @Override
    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(LOCATION_ACCEL);
        return null;
    }

    @Override
    public void postMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player;
        LivingEntity livingEntity;
        if (tool.getPersistentData().getFloat(LOCATION_ACCEL) < (float)modifier.getLevel() * 0.5f && (livingEntity = context.getAttacker()) instanceof Player && (double)(player = (Player)livingEntity).m_36403_(0.0f) >= 0.25) {
            tool.getPersistentData().putFloat(LOCATION_ACCEL, tool.getPersistentData().getFloat(LOCATION_ACCEL) + 0.05f * (float)modifier.getLevel());
        }
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        ToolStats.ATTACK_SPEED.multiply(modifierStatsBuilder, 0.8);
        ToolStats.MINING_SPEED.multiply(modifierStatsBuilder, 0.8);
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifierEntry, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        if (tool.getPersistentData().getFloat(LOCATION_ACCEL) > 0.0f && EquipmentUtil.HAND.contains(equipmentSlot)) {
            biConsumer.accept(Attributes.f_22283_, new AttributeModifier(UUID.fromString("c7b04ef1-4130-fe3d-cb56-fbe7ea4be5fa"), Attributes.f_22283_.m_22087_(), (double)tool.getPersistentData().getFloat(LOCATION_ACCEL), AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifierEntry, PlayerEvent.BreakSpeed event, Direction direction, boolean b, float v) {
        if (tool.getPersistentData().getFloat(LOCATION_ACCEL) > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + tool.getPersistentData().getFloat(LOCATION_ACCEL)));
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext toolHarvestContext) {
        if (tool.getPersistentData().getFloat(LOCATION_ACCEL) < (float)modifier.getLevel() * 0.5f) {
            tool.getPersistentData().putFloat(LOCATION_ACCEL, tool.getPersistentData().getFloat(LOCATION_ACCEL) + 0.05f * (float)modifier.getLevel());
        }
    }
}

