/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.capabilityProvider.MekIntegration;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.api.interfaces.IToolProvider;
import com.c2h6s.etstlib.register.EtSTLibToolStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public abstract class ToolBasicChemicalTankProvider<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IToolProvider,
IEmptyStackProvider<CHEMICAL, STACK>,
IChemicalHandler<CHEMICAL, STACK> {
    public final IToolStackView tool;

    public static ResourceLocation getKeyForTank(int tanks) {
        return EtSTLib.getResourceLocation("chemical_tank_" + tanks);
    }

    public static ResourceLocation getKeyForType(int tanks) {
        return EtSTLib.getResourceLocation("chemical_type_" + tanks);
    }

    public ToolBasicChemicalTankProvider(IToolStackView tool) {
        this.tool = tool;
    }

    @Override
    @NotNull
    public IToolStackView getTool() {
        return this.tool;
    }

    public abstract STACK createStack(CHEMICAL var1, long var2);

    public int getChemicalTanks(IToolStackView tool) {
        return tool.getStats().getInt((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_COUNT);
    }

    public void setChemicalForTank(int tank, ChemicalStack<?> stack) {
        ModDataNBT data = this.getTool().getPersistentData();
        if (stack.isEmpty()) {
            data.remove(ToolBasicChemicalTankProvider.getKeyForTank(tank));
            data.remove(ToolBasicChemicalTankProvider.getKeyForType(tank));
            return;
        }
        CompoundTag nbt = data.getCompound(ToolBasicChemicalTankProvider.getKeyForTank(tank));
        stack.write(nbt);
        data.put(ToolBasicChemicalTankProvider.getKeyForTank(tank), (Tag)nbt);
        ResourceLocation name = stack.getTypeRegistryName();
        data.putString(ToolBasicChemicalTankProvider.getKeyForType(tank), name.toString());
    }

    public boolean isChemicalTypeValid(int tank, ChemicalStack<?> stack) {
        ModDataNBT data = this.getTool().getPersistentData();
        return data.getString(ToolBasicChemicalTankProvider.getKeyForTank(tank)).equals(stack.getTypeRegistryName().toString());
    }

    public boolean isEmpty(int tank) {
        return !this.getTool().getPersistentData().contains(ToolBasicChemicalTankProvider.getKeyForType(tank));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insertChemicalToTank(int tank, IChemicalHandler<CHEMICAL, STACK> handler, ToolBasicChemicalTankProvider<CHEMICAL, STACK> provider, STACK toInsert, Action action) {
        if (tank > handler.getTanks() - 1) {
            return toInsert;
        }
        STACK insertCopy = provider.createStack(toInsert.getType(), toInsert.getAmount());
        if (!toInsert.isEmpty() && handler.isValid(tank, toInsert)) {
            ChemicalStack existing = handler.getChemicalInTank(tank);
            long needed = handler.getTankCapacity(tank) - existing.getAmount();
            if (needed <= 0L) {
                return toInsert;
            }
            long toAdd = Math.min(toInsert.getAmount(), needed);
            if (action.execute()) {
                if (!existing.isEmpty()) {
                    existing.grow(toAdd);
                    handler.setChemicalInTank(tank, existing);
                } else {
                    STACK stackToCreate = provider.createStack(toInsert.getType(), toAdd);
                    handler.setChemicalInTank(tank, stackToCreate);
                }
            }
            insertCopy.shrink(toAdd);
        }
        return insertCopy;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extractChemicalFromTank(int tank, IChemicalHandler<CHEMICAL, STACK> handler, ToolBasicChemicalTankProvider<CHEMICAL, STACK> provider, long toExtract, Action action) {
        ChemicalStack existing = handler.getChemicalInTank(tank);
        if (!existing.isEmpty() && toExtract >= 1L) {
            long size = Math.min(toExtract, existing.getAmount());
            if (size == 0L) {
                return (STACK)provider.getEmptyStack();
            }
            STACK ret = provider.createStack(existing.getType(), size);
            if (!ret.isEmpty() && action.execute()) {
                existing.shrink(ret.getAmount());
                handler.setChemicalInTank(tank, existing);
            }
            return ret;
        }
        return (STACK)provider.getEmptyStack();
    }

    public STACK findChemical(CHEMICAL chemical) {
        return this.findChemical(this.createStack(chemical, 1L));
    }

    public STACK findChemical(STACK stack) {
        return (STACK)this.findChemical(stack1 -> stack1.isStackIdentical(stack));
    }

    public abstract STACK findChemical(Predicate<STACK> var1);

    public Optional<STACK> findChemicalNotEmpty(CHEMICAL chemical) {
        return this.findChemicalNotEmpty(this.createStack(chemical, 1L));
    }

    public Optional<STACK> findChemicalNotEmpty(STACK stack) {
        return this.findChemicalNotEmpty(stack1 -> stack1.isStackIdentical(stack));
    }

    public Optional<STACK> findChemicalNotEmpty(Predicate<STACK> predicate) {
        STACK stack = this.findChemical(predicate);
        return Optional.ofNullable(stack.isEmpty() ? null : (Object)stack);
    }

    public abstract Collection<STACK> findChemicals(Predicate<STACK> var1);

    public static class CapabilityProvider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (((Float)tool.getStats().get((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_COUNT)).longValue() <= 0L) {
                return LazyOptional.empty();
            }
            if (cap == Capabilities.GAS_HANDLER) {
                return LazyOptional.of(() -> new Gas(tool)).cast();
            }
            if (cap == Capabilities.INFUSION_HANDLER) {
                return LazyOptional.of(() -> new Infuse(tool)).cast();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                return LazyOptional.of(() -> new Slurry(tool)).cast();
            }
            if (cap == Capabilities.PIGMENT_HANDLER) {
                return LazyOptional.of(() -> new Pigment(tool)).cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class Pigment
    extends ToolBasicChemicalTankProvider<mekanism.api.chemical.pigment.Pigment, PigmentStack>
    implements IPigmentHandler {
        public Pigment(IToolStackView tool) {
            super(tool);
        }

        @Override
        public PigmentStack createStack(mekanism.api.chemical.pigment.Pigment chemical, long amount) {
            return new PigmentStack(() -> chemical, amount);
        }

        @Override
        public PigmentStack findChemical(Predicate<PigmentStack> predicate) {
            for (int i = 0; i < this.getTanks(); ++i) {
                PigmentStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
            return this.getEmptyStack();
        }

        @Override
        public Collection<PigmentStack> findChemicals(Predicate<PigmentStack> predicate) {
            ArrayList<PigmentStack> list = new ArrayList<PigmentStack>(List.of());
            for (int i = 0; i < this.getTanks(); ++i) {
                PigmentStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return list;
        }

        public int getTanks() {
            return this.getChemicalTanks(this.getTool());
        }

        @NotNull
        public PigmentStack getChemicalInTank(int i) {
            CompoundTag nbt = this.getTool().getPersistentData().getCompound(Pigment.getKeyForTank(i));
            return PigmentStack.readFromNBT((CompoundTag)nbt);
        }

        public void setChemicalInTank(int i, PigmentStack stack) {
            this.setChemicalForTank(i, (ChemicalStack<?>)stack);
        }

        public long getTankCapacity(int i) {
            return ((Float)this.getTool().getStats().get((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_CAPACITY)).longValue();
        }

        public boolean isValid(int i, PigmentStack stack) {
            return this.isEmpty(i) || this.isChemicalTypeValid(i, (ChemicalStack<?>)stack) && stack.isStackIdentical((ChemicalStack)this.getChemicalInTank(i));
        }

        @NotNull
        public PigmentStack insertChemical(int i, PigmentStack stack, Action action) {
            return Pigment.insertChemicalToTank(i, this, this, stack, action);
        }

        @NotNull
        public PigmentStack extractChemical(int i, long l, Action action) {
            return Pigment.extractChemicalFromTank(i, this, this, l, action);
        }
    }

    public static class Slurry
    extends ToolBasicChemicalTankProvider<mekanism.api.chemical.slurry.Slurry, SlurryStack>
    implements ISlurryHandler {
        public Slurry(IToolStackView tool) {
            super(tool);
        }

        @Override
        public SlurryStack createStack(mekanism.api.chemical.slurry.Slurry chemical, long amount) {
            return new SlurryStack(() -> chemical, amount);
        }

        @Override
        public SlurryStack findChemical(Predicate<SlurryStack> predicate) {
            for (int i = 0; i < this.getTanks(); ++i) {
                SlurryStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
            return this.getEmptyStack();
        }

        @Override
        public Collection<SlurryStack> findChemicals(Predicate<SlurryStack> predicate) {
            ArrayList<SlurryStack> list = new ArrayList<SlurryStack>(List.of());
            for (int i = 0; i < this.getTanks(); ++i) {
                SlurryStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return list;
        }

        public int getTanks() {
            return this.getChemicalTanks(this.getTool());
        }

        @NotNull
        public SlurryStack getChemicalInTank(int i) {
            CompoundTag nbt = this.getTool().getPersistentData().getCompound(Slurry.getKeyForTank(i));
            return SlurryStack.readFromNBT((CompoundTag)nbt);
        }

        public void setChemicalInTank(int i, SlurryStack stack) {
            this.setChemicalForTank(i, (ChemicalStack<?>)stack);
        }

        public long getTankCapacity(int i) {
            return ((Float)this.getTool().getStats().get((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_CAPACITY)).longValue();
        }

        public boolean isValid(int i, SlurryStack stack) {
            return this.isEmpty(i) || this.isChemicalTypeValid(i, (ChemicalStack<?>)stack) && stack.isStackIdentical((ChemicalStack)this.getChemicalInTank(i));
        }

        @NotNull
        public SlurryStack insertChemical(int i, SlurryStack stack, Action action) {
            return Slurry.insertChemicalToTank(i, this, this, stack, action);
        }

        @NotNull
        public SlurryStack extractChemical(int i, long l, Action action) {
            return Slurry.extractChemicalFromTank(i, this, this, l, action);
        }
    }

    public static class Infuse
    extends ToolBasicChemicalTankProvider<InfuseType, InfusionStack>
    implements IInfusionHandler {
        public Infuse(IToolStackView tool) {
            super(tool);
        }

        @Override
        public InfusionStack createStack(InfuseType chemical, long amount) {
            return new InfusionStack(() -> chemical, amount);
        }

        @Override
        public InfusionStack findChemical(Predicate<InfusionStack> predicate) {
            for (int i = 0; i < this.getTanks(); ++i) {
                InfusionStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
            return this.getEmptyStack();
        }

        @Override
        public Collection<InfusionStack> findChemicals(Predicate<InfusionStack> predicate) {
            ArrayList<InfusionStack> list = new ArrayList<InfusionStack>(List.of());
            for (int i = 0; i < this.getTanks(); ++i) {
                InfusionStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return list;
        }

        public int getTanks() {
            return this.getChemicalTanks(this.getTool());
        }

        @NotNull
        public InfusionStack getChemicalInTank(int i) {
            CompoundTag nbt = this.getTool().getPersistentData().getCompound(Infuse.getKeyForTank(i));
            return InfusionStack.readFromNBT((CompoundTag)nbt);
        }

        public void setChemicalInTank(int i, InfusionStack stack) {
            this.setChemicalForTank(i, (ChemicalStack<?>)stack);
        }

        public long getTankCapacity(int i) {
            return ((Float)this.getTool().getStats().get((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_CAPACITY)).longValue();
        }

        public boolean isValid(int i, InfusionStack stack) {
            return this.isEmpty(i) || this.isChemicalTypeValid(i, (ChemicalStack<?>)stack) && stack.isStackIdentical((ChemicalStack)this.getChemicalInTank(i));
        }

        @NotNull
        public InfusionStack insertChemical(int i, InfusionStack stack, Action action) {
            return Infuse.insertChemicalToTank(i, this, this, stack, action);
        }

        @NotNull
        public InfusionStack extractChemical(int i, long l, Action action) {
            return Infuse.extractChemicalFromTank(i, this, this, l, action);
        }
    }

    public static class Gas
    extends ToolBasicChemicalTankProvider<mekanism.api.chemical.gas.Gas, GasStack>
    implements IGasHandler {
        public Gas(IToolStackView tool) {
            super(tool);
        }

        @Override
        public GasStack createStack(mekanism.api.chemical.gas.Gas chemical, long amount) {
            return new GasStack(() -> chemical, amount);
        }

        @Override
        public GasStack findChemical(Predicate<GasStack> predicate) {
            for (int i = 0; i < this.getTanks(); ++i) {
                GasStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
            return this.getEmptyStack();
        }

        @Override
        public Collection<GasStack> findChemicals(Predicate<GasStack> predicate) {
            ArrayList<GasStack> list = new ArrayList<GasStack>(List.of());
            for (int i = 0; i < this.getTanks(); ++i) {
                GasStack stack = this.getChemicalInTank(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return list;
        }

        public int getTanks() {
            return this.getChemicalTanks(this.getTool());
        }

        @NotNull
        public GasStack getChemicalInTank(int i) {
            CompoundTag nbt = this.getTool().getPersistentData().getCompound(Gas.getKeyForTank(i));
            return GasStack.readFromNBT((CompoundTag)nbt);
        }

        public void setChemicalInTank(int i, GasStack stack) {
            this.setChemicalForTank(i, (ChemicalStack<?>)stack);
        }

        public long getTankCapacity(int i) {
            return ((Float)this.getTool().getStats().get((IToolStat)EtSTLibToolStat.CHEMICAL_TANK_CAPACITY)).longValue();
        }

        public boolean isValid(int i, GasStack stack) {
            return this.isEmpty(i) || this.isChemicalTypeValid(i, (ChemicalStack<?>)stack) && stack.isStackIdentical((ChemicalStack)this.getChemicalInTank(i));
        }

        @NotNull
        public GasStack insertChemical(int i, GasStack stack, Action action) {
            return Gas.insertChemicalToTank(i, this, this, stack, action);
        }

        @NotNull
        public GasStack extractChemical(int i, long l, Action action) {
            return Gas.extractChemicalFromTank(i, this, this, l, action);
        }
    }
}

