/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

import com.c2h6s.etstlib.capability.EtSTLibCapabilities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface IToolUuidGetter {
    @Nullable
    default public UUID getUuid(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("etstlib_tool_uuid", 8)) {
            return UUID.fromString(nbt.m_128461_("etstlib_tool_uuid"));
        }
        return null;
    }

    default public void setUuid(ItemStack stack, UUID uuid) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128359_("etstlib_tool_uuid", uuid.toString());
        }
    }

    public static Optional<UUID> getUuidOrRandomize(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !nbt.m_128425_("etstlib_tool_uuid", 8)) {
            nbt.m_128359_("etstlib_tool_uuid", UUID.randomUUID().toString());
            return Optional.of(UUID.fromString(nbt.m_128461_("etstlib_tool_uuid")));
        }
        return Optional.empty();
    }

    public static void forceSetUuid(ItemStack stack, UUID uuid) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128359_("etstlib_tool_uuid", uuid.toString());
        }
    }

    @NotNull
    public static Optional<UUID> getUuidForItem(ItemStack stack) {
        LazyOptional optional = stack.getCapability(EtSTLibCapabilities.TOOL_UUID);
        return Optional.ofNullable(optional.isPresent() ? ((IToolUuidGetter)optional.orElse(null)).getUuid(stack) : null);
    }

    @NotNull
    public static Optional<UUID> getUuidForTool(ToolStack stack) {
        return IToolUuidGetter.getUuidForItem(stack.createStack());
    }

    @NotNull
    public static Optional<UUID> getUuidForTool(IToolStackView tool) {
        return IToolUuidGetter.getUuidForTool((ToolStack)tool);
    }

    @Nullable
    default public UUID etstlib$getUuid() {
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Optional<UUID> getUuid(IToolStackView tool) {
        if (IToolUuidGetter.getUuidForTool(tool).isPresent()) {
            return IToolUuidGetter.getUuidForTool(tool);
        }
        ToolStack toolStack = (ToolStack)tool;
        if (toolStack instanceof IToolUuidGetter) {
            IToolUuidGetter uuidGetter = (IToolUuidGetter)toolStack;
            return Optional.ofNullable(uuidGetter.getUuid(((ToolStack)tool).createStack()));
        }
        return Optional.empty();
    }
}

