/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

import com.c2h6s.etstlib.network.EtSTLibPacketHandler;
import com.c2h6s.etstlib.network.packets.PAddParticleS2C;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record ParticleContext(ParticleOptions options, boolean pForceAlwaysRender, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
    public void toByteBuf(FriendlyByteBuf byteBuf) {
        byteBuf.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)this.options.m_6012_());
        this.options.m_7711_(byteBuf);
        byteBuf.writeBoolean(this.pForceAlwaysRender);
        byteBuf.writeDouble(this.pX);
        byteBuf.writeDouble(this.pY);
        byteBuf.writeDouble(this.pZ);
        byteBuf.writeDouble(this.pXSpeed);
        byteBuf.writeDouble(this.pYSpeed);
        byteBuf.writeDouble(this.pZSpeed);
    }

    public static ParticleContext fromByteBuf(FriendlyByteBuf byteBuf) {
        return ParticleContext.buildParticle(ParticleContext.readParticleOption((ParticleType)byteBuf.m_236816_((IdMap)BuiltInRegistries.f_257034_), byteBuf)).setAlwaysRender(byteBuf.readBoolean()).setPos(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble()).setVelocity(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble()).build();
    }

    public static <T extends ParticleOptions> T readParticleOption(ParticleType<T> particleType, FriendlyByteBuf byteBuf) {
        return (T)particleType.m_123743_().m_6507_(particleType, byteBuf);
    }

    public static Builder buildParticle(@NotNull ParticleOptions options) {
        return new Builder(options);
    }

    public void addToLevel(Level level) {
        level.m_6493_(this.options, this.pForceAlwaysRender, this.pX, this.pY, this.pZ, this.pXSpeed, this.pYSpeed, this.pZSpeed);
    }

    public void sendToClient(ServerLevel serverLevel) {
        serverLevel.m_6907_().forEach(serverPlayer -> EtSTLibPacketHandler.sendToPlayer(new PAddParticleS2C(this), serverPlayer));
    }

    public static class Builder {
        ParticleOptions options;
        boolean pForceAlwaysRender;
        Vec3 pos;
        Vec3 velocity;

        public Builder(@NotNull ParticleOptions options) {
            this.options = options;
        }

        public Builder setAlwaysRender(boolean forceAlwaysRender) {
            this.pForceAlwaysRender = forceAlwaysRender;
            return this;
        }

        public Builder setPos(Vec3 pos) {
            this.pos = pos;
            return this;
        }

        public Builder setPos(double x, double y, double z) {
            this.pos = new Vec3(x, y, z);
            return this;
        }

        public Builder randomizePos(double offset, RandomSource source) {
            this.pos.m_82549_(new Vec3(source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0).m_82490_(offset));
            return this;
        }

        public Builder setVelocity(Vec3 velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder setVelocity(double x, double y, double z) {
            this.velocity = new Vec3(x, y, z);
            return this;
        }

        public Builder setVelocity(double speed, RandomSource source) {
            this.velocity = new Vec3(source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0).m_82490_(speed);
            return this;
        }

        public Builder randomizeVelocity(double offset, RandomSource source) {
            this.velocity.m_82549_(new Vec3(source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0, source.m_188500_() * 2.0 - 1.0).m_82490_(offset));
            return this;
        }

        public ParticleContext build() {
            Objects.requireNonNull(this.pos, String.format("Particle position not set for particle context of particle type %s", this.options.m_5942_()));
            Objects.requireNonNull(this.velocity, String.format("Particle velocity not set for particle context of particle type %s", this.options.m_5942_()));
            return new ParticleContext(this.options, this.pForceAlwaysRender, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, this.velocity.f_82479_, this.velocity.f_82480_, this.velocity.f_82481_);
        }
    }
}

