/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.content.misc.vibration;

import com.c2h6s.etstlib.content.misc.vibration.ToolVibrationAcceptor;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.VibrationListeningModifierHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolVibrationListener
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem {
    public final Player playerHolder;
    public static Map<Player, ToolVibrationListener> listenerMap = new HashMap<Player, ToolVibrationListener>();
    private Map<UUID, ToolVibrationAcceptor> acceptorMap = new HashMap<UUID, ToolVibrationAcceptor>();
    private final VibrationSystem.Data vibrationData;
    private final VibrationSystem.User vibrationUser;
    private final VibrationSystem.Listener vibrationListener;
    private int listenRadius;
    private boolean cachedCanListen;

    public ToolVibrationListener(Player playerHolder) {
        this.playerHolder = playerHolder;
        this.vibrationData = new VibrationSystem.Data();
        this.vibrationUser = new VibrationUser();
        this.vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    }

    public void tick() {
        if (this.playerHolder.m_21224_() || !this.playerHolder.m_6084_()) {
            ToolVibrationListener.removeAllAcceptor(this.playerHolder);
            return;
        }
        if (!this.playerHolder.m_9236_().f_46443_) {
            VibrationSystem.Ticker.m_280259_((Level)this.playerHolder.m_9236_(), (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        this.acceptorMap.forEach((uuid, acceptor) -> acceptor.tickAcceptor(this.playerHolder));
    }

    public void addAcceptor(ToolVibrationAcceptor acceptor) {
        if (!this.acceptorMap.containsKey(acceptor.acceptorUUID)) {
            this.listenRadius = acceptor.listenRange;
            this.acceptorMap.put(acceptor.acceptorUUID, acceptor);
        } else {
            ToolVibrationAcceptor existingAcceptor = this.acceptorMap.get(acceptor.acceptorUUID);
            if (existingAcceptor != null) {
                this.acceptorMap.put(acceptor.acceptorUUID, existingAcceptor.mergeAcceptor(acceptor));
            } else {
                this.acceptorMap.put(acceptor.acceptorUUID, acceptor);
            }
        }
        this.updateRange();
    }

    public void updateRange() {
        this.listenRadius = 0;
        this.acceptorMap.forEach((uuid, acceptor) -> {
            this.listenRadius = Math.max(this.listenRadius, acceptor.listenRange);
        });
    }

    public static void tickIfPresent(ServerPlayer player) {
        ToolVibrationListener listener = listenerMap.get(player);
        if (listener != null) {
            listener.tick();
        }
    }

    public static void validate(Player player) {
        ArrayList listExistingAcceptors = new ArrayList(List.of());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(slot);
            if (!(stack.m_41720_() instanceof IModifiable)) continue;
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            toolStack.getModifierList().forEach(modifier -> {
                UUID uuid = ((VibrationListeningModifierHook)modifier.getHook(EtSTLibHooks.VIBRATION_LISTENING)).getAcceptorUUID((IToolStackView)toolStack, (ModifierEntry)modifier, player, player.m_9236_(), slot);
                if (uuid != null) {
                    listExistingAcceptors.add(uuid);
                }
            });
        }
        ToolVibrationListener listener = listenerMap.get(player);
        if (listener == null) {
            return;
        }
        if (listener.acceptorMap.isEmpty()) {
            return;
        }
        ArrayList<UUID> uuids = new ArrayList<UUID>(listener.acceptorMap.keySet());
        for (UUID uuid : uuids) {
            if (listExistingAcceptors.contains(uuid)) continue;
            ToolVibrationListener.removeAcceptor(player, uuid);
        }
    }

    public static void decreaseLevel(Player player, UUID uuid, int toDecrease) {
        if (listenerMap.get(player) != null) {
            ToolVibrationListener listener = listenerMap.get(player);
            HashMap<UUID, ToolVibrationAcceptor> acceptors = new HashMap<UUID, ToolVibrationAcceptor>(listener.acceptorMap);
            ArrayList uuids = new ArrayList(acceptors.keySet());
            for (UUID acceptorUUID : uuids) {
                if (acceptorUUID != uuid) continue;
                ToolVibrationAcceptor acceptor = (ToolVibrationAcceptor)acceptors.get(acceptorUUID);
                acceptor.totalLevel -= toDecrease;
                if (acceptor.totalLevel > 0) continue;
                acceptors.remove(acceptorUUID);
            }
            listener.acceptorMap = acceptors;
        }
    }

    public static void removeAcceptor(Player player, UUID uuid) {
        if (listenerMap.get(player) != null) {
            ToolVibrationListener listener = listenerMap.get(player);
            HashMap<UUID, ToolVibrationAcceptor> acceptors = new HashMap<UUID, ToolVibrationAcceptor>(listener.acceptorMap);
            ArrayList uuids = new ArrayList(acceptors.keySet());
            for (UUID acceptorUUID : uuids) {
                if (acceptorUUID != uuid) continue;
                acceptors.remove(acceptorUUID);
            }
            listener.acceptorMap = acceptors;
            if (listener.acceptorMap.isEmpty()) {
                listenerMap.remove(listener.playerHolder);
            }
        }
    }

    public static void removeAllAcceptor(Player player) {
        listenerMap.remove(player);
    }

    public static void putOrMerge(@NotNull Player player, @NotNull ToolVibrationAcceptor acceptor) {
        if (listenerMap.get(player) == null || ToolVibrationListener.listenerMap.get((Object)player).acceptorMap.isEmpty()) {
            ToolVibrationListener listener = new ToolVibrationListener(player);
            listener.addAcceptor(acceptor);
            listenerMap.put(player, listener);
        } else {
            ToolVibrationListener listener = listenerMap.get(player);
            listener.addAcceptor(acceptor);
            listenerMap.put(player, listener);
        }
    }

    @NotNull
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    @NotNull
    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    private void onVibrationReceived(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, Entity pEntity, Entity projectileOwner, float pDistance, int gameEventFrequency) {
        ArrayList<UUID> uuids = new ArrayList<UUID>(this.acceptorMap.keySet());
        for (UUID uuid : uuids) {
            ToolVibrationAcceptor acceptor = this.acceptorMap.get(uuid);
            if (!this.cachedCanListen) continue;
            acceptor.onVibrationReceived(pLevel, this.playerHolder, pPos, pGameEvent, pEntity, projectileOwner, pDistance, gameEventFrequency);
            this.cachedCanListen = false;
        }
    }

    private boolean canReceiveVibration(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, GameEvent.Context pContext) {
        BlockPos userPos = this.vibrationUser.m_280010_().m_142502_((Level)pLevel).map(BlockPos::m_274446_).orElse(pPos);
        ArrayList<UUID> uuids = new ArrayList<UUID>(this.acceptorMap.keySet());
        for (UUID uuid : uuids) {
            ToolVibrationAcceptor acceptor = this.acceptorMap.get(uuid);
            if (!acceptor.canReceiveVibration(pLevel, this.playerHolder, userPos, pPos, pGameEvent, pContext)) continue;
            this.cachedCanListen = true;
            return true;
        }
        return false;
    }

    public int getListenRadius() {
        return this.listenRadius;
    }

    public void setListenRadius(int listenRadius) {
        this.listenRadius = listenRadius;
    }

    class VibrationUser
    implements VibrationSystem.User {
        VibrationUser() {
        }

        public int m_280351_() {
            return ToolVibrationListener.this.listenRadius;
        }

        public PositionSource m_280010_() {
            return new EntityPositionSource((Entity)ToolVibrationListener.this.playerHolder, ToolVibrationListener.this.playerHolder.m_20192_());
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_144302_;
        }

        public boolean m_280080_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, GameEvent.Context pContext) {
            return ToolVibrationListener.this.canReceiveVibration(pLevel, pPos, pGameEvent, pContext);
        }

        public void m_280271_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, @Nullable Entity pEntity, @Nullable Entity projectileOwner, float pDistance) {
            ToolVibrationListener.this.onVibrationReceived(pLevel, pPos, pGameEvent, pEntity, projectileOwner, pDistance, VibrationSystem.m_280122_((GameEvent)pGameEvent));
        }
    }
}

