/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib;

import com.c2h6s.etstlib.EtSTLibConfig;
import com.c2h6s.etstlib.EtstLibClientConfig;
import com.c2h6s.etstlib.data.predicate.LivingEntityWithHealth;
import com.c2h6s.etstlib.event.eventHandler.PlayerEvents;
import com.c2h6s.etstlib.network.EtSTLibPacketHandler;
import com.c2h6s.etstlib.register.EtSTLibEffects;
import com.c2h6s.etstlib.register.EtSTLibEntityTickers;
import com.c2h6s.etstlib.register.EtSTLibModifier;
import com.c2h6s.etstlib.tool.fluid.fluidEffect.AddEntityTickerFluidEffect;
import com.c2h6s.etstlib.tool.fluid.fluidEffect.ClearChunkRadiationFluidEffect;
import com.c2h6s.etstlib.tool.fluid.fluidEffect.RadiateBlockFluidEffect;
import com.c2h6s.etstlib.tool.fluid.fluidEffect.RadiateEntityFluidEffect;
import com.c2h6s.etstlib.tool.hooks.modifierModules.AddDamageTypeTagArrowModule;
import com.c2h6s.etstlib.tool.hooks.modifierModules.AddDamageTypeTagMeleeModule;
import com.c2h6s.etstlib.tool.hooks.modifierModules.ForceDropModule;
import com.c2h6s.etstlib.tool.hooks.modifierModules.SetCriticalModule;
import com.c2h6s.etstlib.tool.modifiers.capabilityProvider.MekIntegration.RadiationShieldProvider;
import com.c2h6s.etstlib.tool.modifiers.capabilityProvider.PnCIntegration.AirStorageProvider;
import com.c2h6s.etstlib.util.ModListConstants;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;

@Mod(value="etstlib")
public class EtSTLib {
    public static final Random random = new Random();
    public static final String MODID = "etstlib";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"etstlib");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"etstlib");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"etstlib");

    public static ResourceLocation getResourceLocation(String string) {
        return new ResourceLocation(MODID, string);
    }

    public EtSTLib() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerSerializers);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EtstLibClientConfig.ClientConfig, "etstlib-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EtSTLibConfig.COMMON_CONFIG, "etstlib-common.toml");
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        EtSTLibEffects.EFFECTS.register(modEventBus);
        EtSTLibEntityTickers.ENTITY_TICKERS.register(modEventBus);
        EtSTLibModifier.MODIFIERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        forgeEventBus.addListener(PlayerEvents::onLeftClickBlock);
        forgeEventBus.addListener(PlayerEvents::onLeftClick);
        EtSTLibPacketHandler.init();
        if (ModListConstants.MekLoaded) {
            EtSTLibModifier.EtSTLibModifierMek.Mek_MODIFIERS.register(modEventBus);
        }
        if (ModListConstants.PnCLoaded) {
            EtSTLibModifier.EtSTLibModifierPnC.PnC_MODIFIERS.register(modEventBus);
        }
        if (ModListConstants.AE2Loaded) {
            EtSTLibModifier.EtSTLibModifierAE.AE_MODIFIERS.register(modEventBus);
        }
        if (ModListConstants.BOTLoaded) {
            EtSTLibModifier.EtSTLibModifierBOT.BOT_MODIFIERS.register(modEventBus);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (ModListConstants.MekLoaded) {
            ToolCapabilityProvider.register(RadiationShieldProvider::new);
        }
        if (ModListConstants.PnCLoaded) {
            ToolCapabilityProvider.register(AirStorageProvider::new);
        }
    }

    void registerSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            ModifierModule.LOADER.register(EtSTLib.getResourceLocation("set_critical"), SetCriticalModule.LOADER);
            ModifierModule.LOADER.register(EtSTLib.getResourceLocation("force_drop"), ForceDropModule.LOADER);
            ModifierModule.LOADER.register(EtSTLib.getResourceLocation("add_melee_damage_type"), AddDamageTypeTagMeleeModule.LOADER);
            ModifierModule.LOADER.register(EtSTLib.getResourceLocation("add_arrow_damage_type"), AddDamageTypeTagArrowModule.LOADER);
            LivingEntityPredicate.LOADER.register(EtSTLib.getResourceLocation("with_health"), LivingEntityWithHealth.LOADER);
            FluidEffect.ENTITY_EFFECTS.register(EtSTLib.getResourceLocation("add_entity_ticker"), AddEntityTickerFluidEffect.LOADER);
            if (ModListConstants.MekLoaded) {
                FluidEffect.ENTITY_EFFECTS.register(EtSTLib.getResourceLocation("radiate_entity"), RadiateEntityFluidEffect.LOADER);
                FluidEffect.BLOCK_EFFECTS.register(EtSTLib.getResourceLocation("radiate_block"), RadiateBlockFluidEffect.LOADER);
                FluidEffect.BLOCK_EFFECTS.register(EtSTLib.getResourceLocation("clear_radiation"), ClearChunkRadiationFluidEffect.LOADER);
            }
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

