/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.content.misc.entityTicker;

import com.c2h6s.etstlib.EtSTLibConfig;
import com.c2h6s.etstlib.content.misc.entityTicker.EntityTicker;
import com.c2h6s.etstlib.content.misc.entityTicker.EntityTickerInstance;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTickerManager {
    public static final ConcurrentHashMap<Entity, ConcurrentHashMap<EntityTicker, EntityTickerInstance>> TICKER_MAP = new ConcurrentHashMap();

    public static EntityTickerManagerInstance getInstance(Entity entity) {
        return new EntityTickerManagerInstance(entity);
    }

    public static boolean tick(Entity entity) {
        if (entity instanceof Player && !((Boolean)EtSTLibConfig.ALLOW_TICKER_ON_PLAYER.get()).booleanValue()) {
            return true;
        }
        if (entity.getPersistentData().m_128441_("etstlib_tickers")) {
            EntityTickerManager.load(entity);
        }
        if (!TICKER_MAP.containsKey(entity)) {
            return true;
        }
        if (TICKER_MAP.get(entity) == null || TICKER_MAP.get(entity).isEmpty()) {
            TICKER_MAP.remove(entity);
            return true;
        }
        boolean doTick = true;
        EntityTickerManagerInstance managerInstance = new EntityTickerManagerInstance(entity);
        Map<EntityTicker, EntityTickerInstance> instances = managerInstance.instanceMap;
        List<EntityTickerInstance> instancesCopy = List.copyOf(managerInstance.instanceMap.values());
        for (EntityTickerInstance instance : instancesCopy) {
            EntityTicker ticker = instance.ticker;
            if (!ticker.isInfinite()) {
                --instance.duration;
            }
            boolean bl = doTick = doTick && ticker.tick(instance.duration, instance.level, entity);
            if (instance.duration > 0) {
                managerInstance.setTicker(instance);
                continue;
            }
            managerInstance.removeTicker(ticker);
        }
        return doTick;
    }

    public static void saveAll() {
        ((ConcurrentHashMap.KeySetView)TICKER_MAP.keySet()).forEach(EntityTickerManager::save);
    }

    public static void load(Entity entity) {
        CompoundTag nbt = entity.getPersistentData().m_128469_("etstlib_tickers");
        ConcurrentHashMap instances = new ConcurrentHashMap();
        if (!nbt.m_128456_()) {
            nbt.m_128431_().forEach(string -> {
                EntityTickerInstance instance;
                if (nbt.m_128425_(string, 10) && (instance = EntityTickerInstance.readFromNbt(nbt.m_128469_(string), new ResourceLocation(string))) != null) {
                    instances.put(instance.ticker, instance);
                }
            });
        }
        TICKER_MAP.put(entity, instances);
        entity.getPersistentData().m_128473_("etstlib_tickers");
    }

    public static void save(Entity entity) {
        if (entity == null) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        if (TICKER_MAP.get(entity) != null) {
            TICKER_MAP.get(entity).values().forEach(instance -> instance.writeToNbt(nbt));
            entity.getPersistentData().m_128365_("etstlib_tickers", (Tag)nbt);
        }
    }

    public static class EntityTickerManagerInstance {
        @NotNull
        public final Map<EntityTicker, EntityTickerInstance> instanceMap;
        public final Entity entity;

        public EntityTickerManagerInstance(Entity entity) {
            this.entity = entity;
            TICKER_MAP.computeIfAbsent(entity, k -> new ConcurrentHashMap());
            this.instanceMap = TICKER_MAP.get(entity);
        }

        public boolean hasTicker(EntityTicker ticker) {
            return this.instanceMap.containsKey(ticker);
        }

        @NotNull
        public Optional<EntityTickerInstance> getOptional(EntityTicker type) {
            return Optional.ofNullable(this.getTicker(type));
        }

        @Nullable
        public EntityTickerInstance getTicker(EntityTicker type) {
            return this.instanceMap.get(type);
        }

        public void setTicker(EntityTickerInstance instance) {
            if (!this.hasTicker(instance.ticker)) {
                instance.ticker.onTickerStart(instance.duration, instance.level, this.entity);
            }
            this.instanceMap.put(instance.ticker, instance);
        }

        public void addTicker(EntityTickerInstance instance, BiFunction<Integer, Integer, Integer> levelFunction, BiFunction<Integer, Integer, Integer> timeFunction) {
            EntityTickerInstance existing = this.instanceMap.get(instance.ticker);
            int existingLevel = 0;
            int existingTime = 0;
            if (existing != null) {
                existingLevel = existing.level;
                existingTime = existing.duration;
            }
            EntityTickerInstance merged = new EntityTickerInstance(instance.ticker, levelFunction.apply(existingLevel, instance.level), timeFunction.apply(existingTime, instance.duration));
            this.setTicker(merged);
        }

        public void removeTicker(EntityTicker ticker) {
            if (this.hasTicker(ticker)) {
                ticker.onTickerEnd(this.instanceMap.get((Object)ticker).level, this.entity);
                this.instanceMap.remove(ticker);
            }
        }
    }
}

