/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.Harvest;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class GlobalTraveler
extends EtSTBaseModifier
implements ProcessLootModifierHook,
BlockInteractionModifierHook,
TooltipModifierHook {
    public static final ResourceLocation TRAVELER_X = EtSTLib.getResourceLocation("traveler_x");
    public static final ResourceLocation TRAVELER_Y = EtSTLib.getResourceLocation("traveler_y");
    public static final ResourceLocation TRAVELER_Z = EtSTLib.getResourceLocation("traveler_z");
    public static final ResourceLocation TRAVELER_DIM = EtSTLib.getResourceLocation("traveler_dim");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.PROCESS_LOOT, ModifierHooks.BLOCK_INTERACT, ModifierHooks.TOOLTIP);
    }

    @Override
    public boolean isNoLevels() {
        return true;
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public InteractionResult beforeBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            BlockPos blockPos = context.m_8083_();
            ModDataNBT nbt = tool.getPersistentData();
            BlockPos legacyPos = new BlockPos(nbt.getInt(TRAVELER_X), nbt.getInt(TRAVELER_Y), nbt.getInt(TRAVELER_Z));
            BlockEntity be = context.m_43725_().m_7702_(blockPos);
            if (blockPos.equals((Object)legacyPos) && context.m_43725_().m_46472_().m_135782_().toString().equals(nbt.getString(TRAVELER_DIM))) {
                nbt.remove(TRAVELER_X);
                nbt.remove(TRAVELER_Y);
                nbt.remove(TRAVELER_Z);
                nbt.remove(TRAVELER_DIM);
                player.m_213846_((Component)Component.m_237115_((String)"msg.etstlib.global_traveler.container_disbound"));
                return InteractionResult.CONSUME;
            }
            if (!context.m_43725_().f_46443_ && be != null && be.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                tool.getPersistentData().putInt(TRAVELER_X, blockPos.m_123341_());
                tool.getPersistentData().putInt(TRAVELER_Y, blockPos.m_123342_());
                tool.getPersistentData().putInt(TRAVELER_Z, blockPos.m_123343_());
                tool.getPersistentData().putString(TRAVELER_DIM, context.m_43725_().m_46472_().m_135782_().toString());
                player.m_213846_((Component)Component.m_237115_((String)"msg.etstlib.global_traveler.container_bind").m_130946_(" : ").m_130946_(blockPos.m_123344_()).m_130946_(" @ ").m_7220_((Component)Component.m_237115_((String)context.m_43725_().m_46472_().m_135782_().toString())).m_130948_(Style.f_131099_.m_178520_(524177)));
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void processLoot(IToolStackView tool, ModifierEntry entry, List<ItemStack> list, LootContext context) {
        if (tool.getPersistentData().contains(TRAVELER_DIM, 8)) {
            BlockEntity blockEntity;
            ModDataNBT nbt = tool.getPersistentData();
            BlockPos blockPos = new BlockPos(nbt.getInt(TRAVELER_X), nbt.getInt(TRAVELER_Y), nbt.getInt(TRAVELER_Z));
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135822_((String)tool.getPersistentData().getString(TRAVELER_DIM), (char)':'));
            ServerLevel level = context.m_78952_().m_7654_().m_129880_(key);
            if (level != null && (blockEntity = level.m_7702_(blockPos)) != null) {
                LazyOptional optional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
                optional.ifPresent(iItemHandler -> {
                    int i = 0;
                    do {
                        for (int j = 0; j < list.size(); ++j) {
                            ItemStack itemStack = (ItemStack)list.get(j);
                            int count = itemStack.m_41613_();
                            ItemStack leftOver = iItemHandler.insertItem(i, itemStack, false);
                            if (leftOver.m_41613_() >= count) continue;
                            if (leftOver.m_41619_()) {
                                list.remove(j);
                                continue;
                            }
                            list.set(j, leftOver);
                        }
                    } while (++i < iItemHandler.getSlots() && !list.isEmpty());
                });
            }
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (tool.getPersistentData().contains(TRAVELER_DIM, 8)) {
            ModDataNBT nbt = tool.getPersistentData();
            BlockPos blockPos = new BlockPos(nbt.getInt(TRAVELER_X), nbt.getInt(TRAVELER_Y), nbt.getInt(TRAVELER_Z));
            String lang = tool.getPersistentData().getString(TRAVELER_DIM);
            list.add((Component)Component.m_237115_((String)"msg.etstlib.global_traveler.container_bind").m_130946_(" : ").m_130946_(blockPos.m_123344_()).m_130946_(" @ ").m_7220_((Component)Component.m_237115_((String)lang)));
        }
    }
}

