/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.settings.ServuxStringSetting;
import fi.dy.masa.servux.util.StringUtils;
import fi.dy.masa.servux.util.i18nLang;
import java.util.List;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ServuxConfigProvider
extends DataProviderBase {
    public static final ServuxConfigProvider INSTANCE = new ServuxConfigProvider();
    private final ServuxIntSetting basePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    private final ServuxIntSetting adminPermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level_admin", 3, 4, 0);
    private final ServuxIntSetting easyPlacePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level_easy_place", 0, 4, 0);
    private final ServuxStringSetting defaultLanguage = new ServuxStringSetting(this, this, "default_language", "en_us", List.of("en_us", "zh_cn"), false){

        @Override
        public void setValueNoCallback(String value) {
            i18nLang.tryLoadLanguage(value.toLowerCase());
            super.setValueNoCallback(value.toLowerCase());
        }

        @Override
        public void setValue(String value) throws CommandSyntaxException {
            String lowerCase = value.toLowerCase();
            if (!i18nLang.tryLoadLanguage(lowerCase)) {
                throw new SimpleCommandExceptionType((Message)StringUtils.translate("servux.command.config.invalid_language", value)).create();
            }
            String oldValue = (String)this.getValue();
            super.setValueNoCallback(lowerCase);
            this.onValueChanged(oldValue, value);
        }
    };
    private final ServuxBoolSetting debugLog = new ServuxBoolSetting((IDataProvider)this, "debug_log", Component.nullToEmpty((String)"Debug Log"), Component.nullToEmpty((String)"Enable debug logging"), false);
    private final List<IServuxSetting<?>> settings = List.of(this.basePermissionLevel, this.adminPermissionLevel, this.easyPlacePermissionLevel, this.defaultLanguage, this.debugLog);

    protected ServuxConfigProvider() {
        super("servux_main", ResourceLocation.parse((String)"servux:main"), 1, 0, "servux.main", "The Servux Main configuration data provider");
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
    }

    @Override
    public void unregisterHandler() {
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return true;
    }

    public void doReloadConfig(CommandSourceStack source) {
        DataProviderManager.INSTANCE.readFromConfig();
        source.sendSuccess(() -> StringUtils.translate("servux.command.config.reloaded", new Object[0]), true);
    }

    public void doSaveConfig(CommandSourceStack source) {
        DataProviderManager.INSTANCE.writeToConfig();
        source.sendSuccess(() -> StringUtils.translate("servux.command.config.saved", new Object[0]), true);
    }

    public boolean hasDebugMode() {
        return ((Boolean)this.debugLog.getValue()).booleanValue();
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        if (player == null) {
            return false;
        }
        return Permissions.check((Entity)player, (String)"servux.main.admin", (int)((Integer)this.adminPermissionLevel.getValue()));
    }

    public boolean hasPermission_EasyPlace(ServerPlayer player) {
        if (player == null) {
            return false;
        }
        return Permissions.check((Entity)player, (String)"servux.main.easy_place", (int)((Integer)this.easyPlacePermissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public String getDefaultLanguage() {
        return (String)this.defaultLanguage.getValue();
    }
}

