/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.network.IServerPayloadData;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public interface IPluginServerPlayHandler<T extends CustomPacketPayload>
extends ServerPlayNetworking.PlayPayloadHandler<T> {
    public static final int FROM_SERVER = 1;
    public static final int TO_SERVER = 2;
    public static final int BOTH_SERVER = 3;
    public static final int TO_CLIENT = 4;
    public static final int FROM_CLIENT = 5;
    public static final int BOTH_CLIENT = 6;

    public ResourceLocation getPayloadChannel();

    public boolean isPlayRegistered(ResourceLocation var1);

    public void setPlayRegistered(ResourceLocation var1);

    public void reset(ResourceLocation var1);

    default public void registerPlayPayload(@Nonnull CustomPacketPayload.Type<T> id, @Nonnull StreamCodec<? super RegistryFriendlyByteBuf, T> codec, int direction) {
        if (!this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                switch (direction) {
                    case 2: 
                    case 5: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        break;
                    }
                    case 1: 
                    case 4: {
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                    default: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Servux.LOGGER.error("registerPlayPayload: channel ID [{}] is is already registered", (Object)this.getPayloadChannel());
            }
            this.setPlayRegistered(this.getPayloadChannel());
            return;
        }
        Servux.LOGGER.error("registerPlayPayload: channel ID [{}] is invalid, or it is already registered", (Object)this.getPayloadChannel());
    }

    default public boolean registerPlayReceiver(@Nonnull CustomPacketPayload.Type<T> id, @Nullable ServerPlayNetworking.PlayPayloadHandler<T> receiver) {
        if (this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                return ServerPlayNetworking.registerGlobalReceiver(id, (ServerPlayNetworking.PlayPayloadHandler)Objects.requireNonNullElse(receiver, this::receivePlayPayload));
            }
            catch (IllegalArgumentException e) {
                Servux.LOGGER.error("registerPlayReceiver: Channel ID [{}] payload has not been registered", (Object)this.getPayloadChannel());
            }
        }
        Servux.LOGGER.error("registerPlayReceiver: Channel ID [{}] is invalid, or not registered", (Object)this.getPayloadChannel());
        return false;
    }

    default public void unregisterPlayReceiver() {
        ServerPlayNetworking.unregisterGlobalReceiver((ResourceLocation)this.getPayloadChannel());
    }

    public void receivePlayPayload(T var1, ServerPlayNetworking.Context var2);

    default public void receivePlayPayload(T payload, ServerGamePacketListenerImpl handler, CallbackInfo ci) {
    }

    default public void decodeNbtCompound(ResourceLocation channel, ServerPlayer player, CompoundTag data) {
    }

    default public <D> void decodeObject(ResourceLocation channel, ServerPlayer player, D data1) {
    }

    default public <P extends IServerPayloadData> void decodeServerData(ResourceLocation channel, ServerPlayer player, P data) {
    }

    default public void encodeNbtCompound(ServerPlayer player, CompoundTag data) {
    }

    default public <D> void encodeObject(ServerPlayer player, D data1) {
    }

    default public <P extends IServerPayloadData> void encodeServerData(ServerPlayer player, P data) {
    }

    public void encodeWithSplitter(ServerPlayer var1, FriendlyByteBuf var2, ServerGamePacketListenerImpl var3);

    default public boolean sendPlayPayload(@Nonnull ServerPlayer player, @Nonnull T payload) {
        if (payload.type().id().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            if (ServerPlayNetworking.canSend((ServerPlayer)player, (CustomPacketPayload.Type)payload.type())) {
                ServerPlayNetworking.send((ServerPlayer)player, payload);
                return true;
            }
        } else {
            Servux.LOGGER.warn("sendPlayPayload: [Fabric-API] error sending payload for channel: {}, check if channel is registered", (Object)payload.type().id().toString());
        }
        return false;
    }

    default public boolean sendPlayPayload(@Nonnull ServerGamePacketListenerImpl handler, @Nonnull T payload) {
        if (payload.type().id().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
            if (handler.shouldHandleMessage((Packet)packet)) {
                handler.send((Packet)packet);
                return true;
            }
        } else {
            Servux.LOGGER.warn("sendPlayPayload: [NetworkHandler] error sending payload for channel: {}, check if channel is registered", (Object)payload.type().id().toString());
        }
        return false;
    }
}

