/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.IServerPlayHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class ServerPlayHandler<T extends CustomPacketPayload>
implements IServerPlayHandler {
    private static final ServerPlayHandler<CustomPacketPayload> INSTANCE = new ServerPlayHandler();
    private final ArrayListMultimap<ResourceLocation, IPluginServerPlayHandler<T>> handlers = ArrayListMultimap.create();

    public static IServerPlayHandler getInstance() {
        return INSTANCE;
    }

    private ServerPlayHandler() {
    }

    @Override
    public <P extends CustomPacketPayload> void registerServerPlayHandler(IPluginServerPlayHandler<P> handler) {
        ResourceLocation channel = handler.getPayloadChannel();
        if (!this.handlers.containsEntry((Object)channel, handler)) {
            this.handlers.put((Object)channel, handler);
        }
    }

    @Override
    public <P extends CustomPacketPayload> void unregisterServerPlayHandler(IPluginServerPlayHandler<P> handler) {
        ResourceLocation channel = handler.getPayloadChannel();
        if (this.handlers.remove((Object)channel, handler)) {
            handler.reset(channel);
            handler.unregisterPlayReceiver();
        }
    }

    @ApiStatus.Internal
    public void reset(ResourceLocation channel) {
        if (!this.handlers.isEmpty()) {
            for (IPluginServerPlayHandler handler : this.handlers.get((Object)channel)) {
                handler.reset(channel);
            }
        }
    }
}

