/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.mixin.world.IMixinWorldTickScheduler;
import fi.dy.masa.servux.schematic.SchematicMetadata;
import fi.dy.masa.servux.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.servux.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.schematic.selection.AreaSelection;
import fi.dy.masa.servux.schematic.selection.Box;
import fi.dy.masa.servux.util.EntityUtils;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.SchematicPlacingUtils;
import fi.dy.masa.servux.util.WorldUtils;
import fi.dy.masa.servux.util.data.FileType;
import fi.dy.masa.servux.util.position.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int MINECRAFT_DATA_VERSION_1_12 = 1139;
    public static final int MINECRAFT_DATA_VERSION = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    public static final int SCHEMATIC_VERSION = 7;
    public static final int SCHEMATIC_VERSION_SUB = 1;
    public final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    public final Map<String, Map<BlockPos, CompoundTag>> tileEntities = new HashMap<String, Map<BlockPos, CompoundTag>>();
    public final Map<String, Map<BlockPos, ScheduledTick<Block>>> pendingBlockTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Block>>>();
    public final Map<String, Map<BlockPos, ScheduledTick<Fluid>>> pendingFluidTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Fluid>>>();
    public final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    public final Map<String, BlockPos> subRegionPositions = new HashMap<String, BlockPos>();
    public final Map<String, BlockPos> subRegionSizes = new HashMap<String, BlockPos>();
    public final SchematicMetadata metadata = new SchematicMetadata();
    private int totalBlocksReadFromWorld;
    @Nullable
    private final Path schematicFile;
    private final FileType schematicType;

    public LitematicaSchematic(CompoundTag nbtCompound) throws CommandSyntaxException {
        this.readFromNBT(nbtCompound);
        this.schematicFile = Path.of("/", new String[0]);
        this.schematicType = FileType.LITEMATICA_SCHEMATIC;
    }

    private LitematicaSchematic(@Nullable Path file) {
        this(file, FileType.LITEMATICA_SCHEMATIC);
    }

    private LitematicaSchematic(@Nullable Path file, FileType schematicType) {
        this.schematicFile = file;
        this.schematicType = schematicType;
    }

    @Nullable
    public Path getFile() {
        return this.schematicFile;
    }

    public Vec3i getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public BlockPos getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, BlockPos> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, BlockPos> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            BlockPos pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public BlockPos getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.offset((Vec3i)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(Level world, AreaSelection area, SchematicSaveInfo info, String author) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            Servux.LOGGER.warn("createFromWorld: No Selection boxes.");
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(Path.of("/", new String[0]));
        long time = System.currentTimeMillis();
        BlockPos origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes, info);
        if (!info.ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize(PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        schematic.metadata.setSchematicVersion(7);
        schematic.metadata.setMinecraftDataVersion(MINECRAFT_DATA_VERSION);
        schematic.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
        return schematic;
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        return this.placeToWorld(world, schematicPlacement, notifyNeighbors, false);
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors, boolean ignoreEntities) {
        WorldUtils.setShouldPreventBlockUpdates(world, true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Servux.LOGGER.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (ignoreEntities || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventBlockUpdates(world, false);
        return true;
    }

    private boolean placeBlocksToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, CompoundTag> tileMap, @Nullable Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks, @Nullable Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks, boolean notifyNeighbors) {
        BlockPos posEndRelSub = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize);
        BlockPos posEndRel = posEndRelSub.offset((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos regionPosAbs = regionPosTransformed.offset((Vec3i)origin);
        int sizeX = Math.abs(regionSize.getX());
        int sizeY = Math.abs(regionSize.getY());
        int sizeZ = Math.abs(regionSize.getZ());
        BlockState barrier = Blocks.BARRIER.defaultBlockState();
        boolean ignoreInventories = false;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        ReplaceBehavior replace = ReplaceBehavior.ALL;
        Rotation rotationCombined = schematicPlacement.getRotation().getRotated(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        int bottomY = world.getMinY();
        int topY = world.getMaxY() + 1;
        int tmp = posMinRel.getY() - regionPos.getY() + regionPosTransformed.getY() + origin.getY();
        int startY = 0;
        int endY = sizeY;
        if (tmp < bottomY) {
            startY += bottomY - tmp;
        }
        if ((tmp = posMinRel.getY() - regionPos.getY() + regionPosTransformed.getY() + origin.getY() + (endY - 1)) > topY) {
            endY -= tmp - topY;
        }
        for (int y = startY; y < endY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    BlockEntity te;
                    BlockState state = container.get(x, y, z);
                    if (state.getBlock() == Blocks.STRUCTURE_VOID) continue;
                    posMutable.set(x, y, z);
                    CompoundTag teNBT = tileMap.get(posMutable);
                    posMutable.set(posMinRel.getX() + x - regionPos.getX(), posMinRel.getY() + y - regionPos.getY(), posMinRel.getZ() + z - regionPos.getZ());
                    BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.offset((Vec3i)regionPosTransformed).offset((Vec3i)origin);
                    BlockState stateOld = world.getBlockState(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.isAir() || replace == ReplaceBehavior.WITH_NON_AIR && state.isAir()) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.mirror(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.mirror(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.rotate(rotationCombined);
                    }
                    if (stateOld == state && !state.hasBlockEntity()) continue;
                    BlockEntity teOld = world.getBlockEntity(pos);
                    if (teOld != null) {
                        if (teOld instanceof Container) {
                            ((Container)teOld).clearContent();
                        }
                        world.setBlock(pos, barrier, 20);
                    }
                    if (!world.setBlock(pos, state, 18) || teNBT == null || (te = world.getBlockEntity(pos)) == null) continue;
                    teNBT = teNBT.copy();
                    teNBT.putInt("x", pos.getX());
                    teNBT.putInt("y", pos.getY());
                    teNBT.putInt("z", pos.getZ());
                    try {
                        te.loadWithComponents(teNBT, (HolderLookup.Provider)world.registryAccess());
                        continue;
                    }
                    catch (Exception e) {
                        Servux.LOGGER.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.getX() + origin.getX();
        int offY = regionPosRelTransformed.getY() + origin.getY();
        int offZ = regionPosRelTransformed.getZ() + origin.getZ();
        Rotation rotationCombined = schematicPlacement.getRotation().getRotated(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vec3 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.x + (double)offX;
            double y = pos.y + (double)offY;
            double z = pos.z + (double)offZ;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void takeEntitiesFromWorld(Level world, List<Box> boxes, BlockPos origin) {
        for (Box box : boxes) {
            AABB bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            BlockPos regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                CompoundTag tag;
                if (!entity.save(tag = new CompoundTag())) continue;
                Vec3 posVec = new Vec3(entity.getX() - (double)regionPosAbs.getX(), entity.getY() - (double)regionPosAbs.getY(), entity.getZ() - (double)regionPosAbs.getZ());
                fi.dy.masa.servux.util.nbt.NbtUtils.writeEntityPositionToTag(posVec, tag);
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(Level world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, BlockPos origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            AABB bb = PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
            BlockPos regionPosAbs = box.getPos1();
            for (Entity entity : entities) {
                CompoundTag tag;
                UUID uuid = entity.getUUID();
                if (existingEntities.contains(uuid) || !entity.save(tag = new CompoundTag())) continue;
                Vec3 posVec = new Vec3(entity.getX() - (double)regionPosAbs.getX(), entity.getY() - (double)regionPosAbs.getY(), entity.getZ() - (double)regionPosAbs.getZ());
                if (entity instanceof HangingEntity) {
                    HangingEntity decorationEntity = (HangingEntity)entity;
                    BlockPos p = decorationEntity.blockPosition();
                    tag.putInt("TileX", p.getX() - regionPosAbs.getX());
                    tag.putInt("TileY", p.getY() - regionPosAbs.getY());
                    tag.putInt("TileZ", p.getZ() - regionPosAbs.getZ());
                }
                fi.dy.masa.servux.util.nbt.NbtUtils.writeEntityPositionToTag(posVec, tag);
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(Level world, List<Box> boxes, SchematicSaveInfo info) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Box box : boxes) {
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.getX());
            int sizeY = Math.abs(size.getY());
            int sizeZ = Math.abs(size.getZ());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<BlockPos, CompoundTag> tileEntityMap = new HashMap<BlockPos, CompoundTag>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            BlockPos minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.getX();
            int startY = minCorner.getY();
            int startZ = minCorner.getZ();
            boolean visibleOnly = info.visibleOnly;
            boolean includeSupport = info.includeSupportBlocks;
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        BlockEntity te;
                        posMutable.set(x + startX, y + startY, z + startZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable) && (!includeSupport || !LitematicaSchematic.isSupport(world, (BlockPos)posMutable))) continue;
                        BlockState state = world.getBlockState((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.isAir()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.hasBlockEntity() || (te = world.getBlockEntity((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag tag = te.saveWithId((HolderLookup.Provider)world.registryAccess());
                        fi.dy.masa.servux.util.nbt.NbtUtils.writeBlockPosToTag((Vec3i)pos, tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                IntBoundingBox tickBox = IntBoundingBox.createProper(startX, startY, startZ, startX + sizeX, startY + sizeY, startZ + sizeZ);
                long currentTick = world.getGameTime();
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.getBlockTicks()).servux_getChunkTickSchedulers(), blockTickMap, tickBox, minCorner, currentTick);
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.getFluidTicks()).servux_getChunkTickSchedulers(), fluidTickMap, tickBox, minCorner, currentTick);
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getTicksFromScheduler(Long2ObjectMap<LevelChunkTicks<T>> chunkTickSchedulers, Map<BlockPos, ScheduledTick<T>> outputMap, IntBoundingBox box, BlockPos minCorner, long currentTick) {
        int minCX = SectionPos.blockToSectionCoord((int)box.minX);
        int minCZ = SectionPos.blockToSectionCoord((int)box.minZ);
        int maxCX = SectionPos.blockToSectionCoord((int)box.maxX);
        int maxCZ = SectionPos.blockToSectionCoord((int)box.maxZ);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                long cp = ChunkPos.asLong((int)cx, (int)cz);
                LevelChunkTicks chunkTickScheduler = (LevelChunkTicks)chunkTickSchedulers.get(cp);
                if (chunkTickScheduler == null) continue;
                chunkTickScheduler.getAll().filter(t -> box.containsPos((Vec3i)t.pos())).forEach(t -> this.addRelativeTickToMap(outputMap, (ScheduledTick)t, minCorner, currentTick));
            }
        }
    }

    private <T> void addRelativeTickToMap(Map<BlockPos, ScheduledTick<T>> outputMap, ScheduledTick<T> tick, BlockPos minCorner, long currentTick) {
        BlockPos pos = tick.pos();
        BlockPos relativePos = new BlockPos(pos.getX() - minCorner.getX(), pos.getY() - minCorner.getY(), pos.getZ() - minCorner.getZ());
        ScheduledTick newTick = new ScheduledTick(tick.type(), relativePos, tick.triggerTick() - currentTick, tick.priority(), tick.subTickOrder());
        outputMap.put(relativePos, newTick);
    }

    public static boolean isExposed(Level world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos posAdj = pos.relative(dir);
            BlockState stateAdj = world.getBlockState(posAdj);
            if (stateAdj.canOcclude() && stateAdj.isFaceSturdy((BlockGetter)world, posAdj, dir.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGravityBlock(BlockState state) {
        return state.is(BlockTags.SAND) || state.is(BlockTags.CONCRETE_POWDER) || state.getBlock() == Blocks.GRAVEL;
    }

    public static boolean isGravityBlock(Level world, BlockPos pos) {
        return LitematicaSchematic.isGravityBlock(world.getBlockState(pos));
    }

    public static boolean supportsExposedBlocks(Level world, BlockPos pos) {
        BlockPos posUp = pos.relative(Direction.UP);
        BlockState stateUp = world.getBlockState(posUp);
        while (true) {
            if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
                return true;
            }
            if (!LitematicaSchematic.isGravityBlock(stateUp)) break;
            if (LitematicaSchematic.isExposed(world, posUp)) {
                return true;
            }
            if ((posUp = posUp.relative(Direction.UP)).getY() >= world.getMaxY() + 1) break;
            stateUp = world.getBlockState(posUp);
        }
        return false;
    }

    public static boolean needsSupportNonGravity(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.REPEATER || block == Blocks.COMPARATOR || block == Blocks.SNOW || block instanceof CarpetBlock;
    }

    public static boolean isSupport(Level world, BlockPos pos) {
        BlockPos posUp = pos.relative(Direction.UP);
        BlockState stateUp = world.getBlockState(posUp);
        if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
            return true;
        }
        return LitematicaSchematic.isGravityBlock(stateUp) && (LitematicaSchematic.isExposed(world, posUp) || LitematicaSchematic.supportsExposedBlocks(world, posUp));
    }

    private void setSubRegionPositions(List<Box> boxes, BlockPos areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().subtract((Vec3i)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    @Nullable
    public Map<BlockPos, CompoundTag> getBlockEntityMapForRegion(String regionName) {
        return this.tileEntities.get(regionName);
    }

    @Nullable
    public List<EntityInfo> getEntityListForRegion(String regionName) {
        return this.entities.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Block>> getScheduledBlockTicksForRegion(String regionName) {
        return this.pendingBlockTicks.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Fluid>> getScheduledFluidTicksForRegion(String regionName) {
        return this.pendingFluidTicks.get(regionName);
    }

    private CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.putInt("Version", 7);
        nbt.putInt("SubVersion", 1);
        nbt.put("Metadata", (Tag)this.metadata.writeToNBT());
        nbt.put("Regions", (Tag)this.writeSubRegionsToNBT());
        return nbt;
    }

    private CompoundTag writeSubRegionsToNBT() {
        CompoundTag wrapper = new CompoundTag();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                CompoundTag tag = new CompoundTag();
                tag.put("BlockStatePalette", (Tag)blockContainer.getPalette().writeToNBT());
                tag.put("BlockStates", (Tag)new LongArrayTag(blockContainer.getBackingLongArray()));
                tag.put("TileEntities", (Tag)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.put("PendingBlockTicks", (Tag)this.writePendingTicksToNBT(pendingBlockTicks, (Registry)BuiltInRegistries.BLOCK, "Block"));
                }
                if (pendingFluidTicks != null) {
                    tag.put("PendingFluidTicks", (Tag)this.writePendingTicksToNBT(pendingFluidTicks, (Registry)BuiltInRegistries.FLUID, "Fluid"));
                }
                if (entityList != null) {
                    tag.put("Entities", (Tag)this.writeEntitiesToNBT(entityList));
                }
                BlockPos pos = this.subRegionPositions.get(regionName);
                tag.put("Position", (Tag)fi.dy.masa.servux.util.nbt.NbtUtils.createBlockPosTag((Vec3i)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.put("Size", (Tag)fi.dy.masa.servux.util.nbt.NbtUtils.createBlockPosTag((Vec3i)pos));
                wrapper.put(regionName, (Tag)tag);
            }
        }
        return wrapper;
    }

    private ListTag writeEntitiesToNBT(List<EntityInfo> entityList) {
        ListTag tagList = new ListTag();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.add((Object)info.nbt);
            }
        }
        return tagList;
    }

    private <T> ListTag writePendingTicksToNBT(Map<BlockPos, ScheduledTick<T>> tickMap, Registry<T> registry, String tagName) {
        ListTag tagList = new ListTag();
        if (!tickMap.isEmpty()) {
            for (ScheduledTick<T> entry : tickMap.values()) {
                Object target = entry.type();
                ResourceLocation id = registry.getKey(target);
                if (id == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.putString(tagName, id.toString());
                tag.putInt("Priority", entry.priority().getValue());
                tag.putLong("SubTick", entry.subTickOrder());
                tag.putInt("Time", (int)entry.triggerTick());
                tag.putInt("x", entry.pos().getX());
                tag.putInt("y", entry.pos().getY());
                tag.putInt("z", entry.pos().getZ());
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private ListTag writeTileEntitiesToNBT(Map<BlockPos, CompoundTag> tileMap) {
        ListTag tagList = new ListTag();
        if (!tileMap.isEmpty()) {
            tagList.addAll(tileMap.values());
        }
        return tagList;
    }

    private boolean readFromNBT(CompoundTag nbt) throws CommandSyntaxException {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.contains("Version", 3)) {
            int minecraftDataVersion;
            int version = nbt.getInt("Version");
            int n = minecraftDataVersion = nbt.contains("MinecraftDataVersion") ? nbt.getInt("MinecraftDataVersion") : SharedConstants.getCurrentVersion().getDataVersion().getVersion();
            if (version >= 1 && version <= 7) {
                this.metadata.readFromNBT(nbt.getCompound("Metadata"));
                this.metadata.setSchematicVersion(version);
                this.metadata.setMinecraftDataVersion(minecraftDataVersion);
                this.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
                this.readSubRegionsFromNBT(nbt.getCompound("Regions"), version, minecraftDataVersion);
                return true;
            }
            this.error("servux.litematics.error.schematic_load.unsupported_schematic_version");
        } else {
            this.error("servux.litematics.error.schematic_load.no_schematic_version_information");
        }
        return false;
    }

    private void error(String s, Objects ... objects) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)Component.translatable((String)s, (Object[])objects)).create();
    }

    private void error(String s) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)Component.translatable((String)s)).create();
    }

    private void readSubRegionsFromNBT(CompoundTag tag, int version, int minecraftDataVersion) {
        for (String regionName : tag.getAllKeys()) {
            Tag nbtBase;
            ListTag list;
            if (tag.get(regionName).getId() != 10) continue;
            CompoundTag regionTag = tag.getCompound(regionName);
            BlockPos regionPos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(regionTag.getCompound("Position"));
            BlockPos regionSize = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(regionTag.getCompound("Size"));
            Map<BlockPos, CompoundTag> tiles = null;
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                tiles = this.readTileEntitiesFromNBT(regionTag.getList("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                ListTag entities = regionTag.getList("Entities", 10);
                this.entities.put(regionName, this.readEntitiesFromNBT(entities));
            } else if (version == 1) {
                tiles = this.readTileEntitiesFromNBT_v1(regionTag.getList("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.getList("Entities", 10)));
            }
            if (version >= 3) {
                list = regionTag.getList("PendingBlockTicks", 10);
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.BLOCK, "Block", (Object)Blocks.AIR));
            }
            if (version >= 5) {
                list = regionTag.getList("PendingFluidTicks", 10);
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.FLUID, "Fluid", (Object)Fluids.EMPTY));
            }
            if ((nbtBase = regionTag.get("BlockStates")) == null || nbtBase.getId() != 12) continue;
            ListTag palette = regionTag.getList("BlockStatePalette", 10);
            long[] blockStateArr = ((LongArrayTag)nbtBase).getAsLongArray();
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).offset((Vec3i)regionPos);
            BlockPos posMin = PositionUtils.getMinCorner(regionPos, posEndRel);
            BlockPos posMax = PositionUtils.getMaxCorner(regionPos, posEndRel);
            BlockPos size = posMax.subtract((Vec3i)posMin).offset(1, 1, 1);
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                this.postProcessContainerIfNeeded(palette, container, tiles);
            }
            this.blockContainers.put(regionName, container);
        }
    }

    public static boolean isSizeValid(@Nullable Vec3i size) {
        return size != null && size.getX() > 0 && size.getY() > 0 && size.getZ() > 0;
    }

    protected boolean readPaletteFromLitematicaFormatTag(ListTag tagList, ILitematicaBlockStatePalette palette) {
        int size = tagList.size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
        for (int id = 0; id < size; ++id) {
            CompoundTag tag = tagList.getCompound(id);
            BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag);
            list.add(state);
        }
        return palette.setMapping(list);
    }

    private void postProcessContainerIfNeeded(ListTag palette, LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundTag> tiles) {
        List<BlockState> states = LitematicaSchematic.getStatesFromPaletteTag(palette);
    }

    public static List<BlockState> getStatesFromPaletteTag(ListTag palette) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
        int size = palette.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = palette.getCompound(i);
            BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            states.add(state);
        }
        return states;
    }

    private List<EntityInfo> readEntitiesFromNBT(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityData = tagList.getCompound(i);
            Vec3 posVec = fi.dy.masa.servux.util.nbt.NbtUtils.readEntityPositionFromTag(entityData);
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompound(i);
            BlockPos pos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(tag);
            if (pos == null || tag.isEmpty()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<BlockPos, ScheduledTick<T>> readPendingTicksFromNBT(ListTag tagList, Registry<T> registry, String tagName, T emptyValue) {
        HashMap<BlockPos, ScheduledTick<T>> tickMap = new HashMap<BlockPos, ScheduledTick<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompound(i);
            if (!tag.contains("Time", 99)) continue;
            Object target = null;
            try {
                target = registry.getValue(ResourceLocation.tryParse((String)tag.getString(tagName)));
                if (target == null || target == emptyValue) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            TickPriority priority = TickPriority.byValue((int)tag.getInt("Priority"));
            int scheduledTime = tag.getInt("Time");
            long subTick = tag.getLong("SubTick");
            tickMap.put(pos, new ScheduledTick(target, pos, (long)scheduledTime, priority, subTick));
        }
        return tickMap;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompound(i);
            Vec3 posVec = fi.dy.masa.servux.util.nbt.NbtUtils.readVec3d(tag);
            CompoundTag entityData = tag.getCompound("EntityData");
            if (posVec == null || entityData.isEmpty()) continue;
            fi.dy.masa.servux.util.nbt.NbtUtils.writeEntityPositionToTag(posVec, entityData);
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT_v1(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompound(i);
            CompoundTag tileNbt = tag.getCompound("TileNBT");
            BlockPos pos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(tag);
            if (pos == null || tileNbt.isEmpty()) continue;
            fi.dy.masa.servux.util.nbt.NbtUtils.writeBlockPosToTag((Vec3i)pos, tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override) {
        return this.writeToFile(dir, fileNameIn, override, false);
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override, boolean downgrade) {
        Object fileName = fileNameIn;
        if (!((String)fileName).endsWith(FILE_EXTENSION)) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        Path fileSchematic = dir.resolve((String)fileName);
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return false;
            }
            if (!override && Files.exists(fileSchematic, new LinkOption[0])) {
                return false;
            }
            fi.dy.masa.servux.util.nbt.NbtUtils.writeCompressed(this.writeToNBT(), fileSchematic);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean readFromFile() {
        return this.readFromFile(this.schematicType);
    }

    private boolean readFromFile(FileType schematicType) {
        try {
            CompoundTag nbt = LitematicaSchematic.readNbtFromFile(this.schematicFile);
            if (nbt != null && schematicType == FileType.LITEMATICA_SCHEMATIC) {
                return this.readFromNBT(nbt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static CompoundTag readNbtFromFile(Path file) {
        if (file == null) {
            return null;
        }
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        return fi.dy.masa.servux.util.nbt.NbtUtils.readNbtFromFileAsPath(file);
    }

    public static Path fileFromDirAndName(Path dir, String fileName, FileType schematicType) {
        if (!((String)fileName).endsWith(FILE_EXTENSION) && schematicType == FileType.LITEMATICA_SCHEMATIC) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        return dir.resolve((String)fileName);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName) {
        return LitematicaSchematic.createFromFile(dir, fileName, FileType.LITEMATICA_SCHEMATIC);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName, FileType schematicType) {
        Path file = LitematicaSchematic.fileFromDirAndName(dir, fileName, schematicType);
        LitematicaSchematic schematic = new LitematicaSchematic(file, schematicType);
        return schematic.readFromFile(schematicType) ? schematic : null;
    }

    public static class SchematicSaveInfo {
        public final boolean visibleOnly;
        public final boolean includeSupportBlocks;
        public final boolean ignoreEntities;
        public final boolean fromSchematicWorld;

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities) {
            this(visibleOnly, false, ignoreEntities, false);
        }

        public SchematicSaveInfo(boolean visibleOnly, boolean includeSupportBlocks, boolean ignoreEntities, boolean fromSchematicWorld) {
            this.visibleOnly = visibleOnly;
            this.includeSupportBlocks = includeSupportBlocks;
            this.ignoreEntities = ignoreEntities;
            this.fromSchematicWorld = fromSchematicWorld;
        }
    }

    public static class EntityInfo {
        public final Vec3 posVec;
        public final CompoundTag nbt;

        public EntityInfo(Vec3 posVec, CompoundTag nbt) {
            this.posVec = posVec;
            if (nbt.contains("SleepingX", 3)) {
                nbt.putInt("SleepingX", Mth.floor((double)posVec.x));
            }
            if (nbt.contains("SleepingY", 3)) {
                nbt.putInt("SleepingY", Mth.floor((double)posVec.y));
            }
            if (nbt.contains("SleepingZ", 3)) {
                nbt.putInt("SleepingZ", Mth.floor((double)posVec.z));
            }
            this.nbt = nbt;
        }
    }
}

