/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.google.common.collect.Lists;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.mixin.debug.IMixinMobEntity;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxDebugHandler;
import fi.dy.masa.servux.network.packet.ServuxDebugPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.BreezeDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DebugDataProvider
extends DataProviderBase {
    public static final DebugDataProvider INSTANCE = new DebugDataProvider();
    protected static final ServuxDebugHandler<ServuxDebugPacket.Payload> HANDLER = ServuxDebugHandler.getInstance();
    protected final HashMap<UUID, CompoundTag> registeredPlayers = new HashMap();
    protected final CompoundTag metadata = new CompoundTag();
    private final ServuxIntSetting basePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 2, 4, 0);
    private final List<IServuxSetting<?>> settings = List.of(this.basePermissionLevel);

    protected DebugDataProvider() {
        super("debug_data", ServuxDebugHandler.CHANNEL_ID, 1, 2, "servux.provider.debug_data", "Vanilla Debug Data provider.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxDebugPacket.Payload.ID, ServuxDebugPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxDebugPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxDebugPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    public IPluginServerPlayHandler<ServuxDebugPacket.Payload> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return this.registeredPlayers.containsKey(player.getUUID());
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        if (player == null) {
            return false;
        }
        return Permissions.check((Entity)player, (String)"servux.debug_data", (int)((Integer)this.basePermissionLevel.getValue()));
    }

    public boolean register(ServerPlayer player) {
        return this.register(player, null);
    }

    public boolean register(ServerPlayer player, @Nullable CompoundTag data) {
        if (this.isEnabled()) {
            boolean registered = false;
            MinecraftServer server = player.getServer();
            UUID uuid = player.getUUID();
            if (!this.hasPermission(player)) {
                Servux.debugLog("debug_data: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
                return registered;
            }
            if (!this.registeredPlayers.containsKey(uuid)) {
                this.registeredPlayers.put(uuid, data != null ? data.copy() : new CompoundTag());
                this.sendMetadata(player);
                registered = true;
            }
            return registered;
        }
        return false;
    }

    public boolean unregister(ServerPlayer player) {
        return this.unregister(player, null);
    }

    public boolean unregister(ServerPlayer player, @Nullable CompoundTag nbt) {
        HANDLER.resetFailures(this.getNetworkChannel(), player);
        return this.registeredPlayers.remove(player.getUUID()) != null;
    }

    public void onPacketFailure(ServerPlayer player) {
    }

    public void sendMetadata(ServerPlayer player) {
        if (this.isEnabled()) {
            if (!this.hasPermission(player)) {
                Servux.debugLog("debug_data: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.merge(this.metadata);
            Servux.debugLog("debugDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
            if (player.connection != null) {
                HANDLER.sendPlayPayload(player.connection, new ServuxDebugPacket.Payload(ServuxDebugPacket.MetadataResponse(this.metadata)));
            } else {
                HANDLER.sendPlayPayload(player, new ServuxDebugPacket.Payload(ServuxDebugPacket.MetadataResponse(this.metadata)));
            }
        }
    }

    public void confirmMetadata(ServerPlayer player, CompoundTag data) {
        if (this.isEnabled()) {
            UUID uuid = player.getUUID();
            if (this.registeredPlayers.containsKey(uuid)) {
                this.registeredPlayers.replace(uuid, data.copy());
            } else {
                this.registeredPlayers.put(uuid, data.copy());
            }
            Servux.debugLog("debugDataChannel: received confirm from player {}", player.getName().tryCollapseToString());
        }
    }

    private void sendDebugData(ServerLevel world, CustomPacketPayload payload) {
        if (this.isEnabled()) {
            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
            for (ServerPlayer player : world.players()) {
                if (!this.registeredPlayers.containsKey(player.getUUID()) || !player.connection.shouldHandleMessage((Packet)packet)) continue;
                player.connection.send((Packet)packet);
            }
        }
    }

    public void sendChunkWatchingChange(ServerLevel world, ChunkPos pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new WorldGenAttemptDebugPayload(pos.getWorldPosition().above(100), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    public void sendPoiAdditions(ServerLevel world, BlockPos pos) {
        if (this.isEnabled()) {
            world.getPoiManager().getType(pos).ifPresent(registryEntry -> {
                int tickets = world.getPoiManager().getFreeTickets(pos);
                String name = registryEntry.getRegisteredName();
                this.sendDebugData(world, (CustomPacketPayload)new PoiAddedDebugPayload(pos, name, tickets));
            });
        }
    }

    public void sendPoiRemoval(ServerLevel world, BlockPos pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new PoiRemovedDebugPayload(pos));
        }
    }

    public void sendPointOfInterest(ServerLevel world, BlockPos pos) {
        if (this.isEnabled()) {
            int tickets = world.getPoiManager().getFreeTickets(pos);
            this.sendDebugData(world, (CustomPacketPayload)new PoiTicketCountDebugPayload(pos, tickets));
        }
    }

    public void sendPoi(ServerLevel world, BlockPos pos) {
        if (this.isEnabled()) {
            Holder entry;
            Registry registry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
            SectionPos chunkSectionPos = SectionPos.of((BlockPos)pos);
            Iterator iterator = registry.getTagOrEmpty(StructureTags.VILLAGE).iterator();
            do {
                if (!iterator.hasNext()) {
                    this.sendDebugData(world, (CustomPacketPayload)new VillageSectionsDebugPayload(Set.of(), Set.of(chunkSectionPos)));
                    return;
                }
                entry = (Holder)iterator.next();
            } while (world.structureManager().startsForStructure(chunkSectionPos, (Structure)entry.value()).isEmpty());
            this.sendDebugData(world, (CustomPacketPayload)new VillageSectionsDebugPayload(Set.of(chunkSectionPos), Set.of()));
        }
    }

    public void sendPathfindingData(ServerLevel world, Mob mob, @Nullable Path path, float nodeReachProximity) {
        if (this.isEnabled() && path != null) {
            this.sendDebugData(world, (CustomPacketPayload)new PathfindingDebugPayload(mob.getId(), path, nodeReachProximity));
        }
    }

    public void sendNeighborUpdate(ServerLevel world, BlockPos pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new NeighborUpdatesDebugPayload(world.getGameTime(), pos));
        }
    }

    public void sendStructureStart(WorldGenLevel world, StructureStart structureStart) {
        if (this.isEnabled()) {
            ArrayList<StructuresDebugPayload.PieceInfo> pieces = new ArrayList<StructuresDebugPayload.PieceInfo>();
            for (int i = 0; i < structureStart.getPieces().size(); ++i) {
                pieces.add(new StructuresDebugPayload.PieceInfo(((StructurePiece)structureStart.getPieces().get(i)).getBoundingBox(), i == 0));
            }
            ServerLevel serverWorld = world.getLevel();
            this.sendDebugData(serverWorld, (CustomPacketPayload)new StructuresDebugPayload(serverWorld.dimension(), structureStart.getBoundingBox(), pieces));
        }
    }

    public void sendGoalSelector(ServerLevel world, Mob mob, GoalSelector goalSelector) {
        if (this.isEnabled()) {
            List<GoalDebugPayload.DebugGoal> goals = ((IMixinMobEntity)mob).servux_getGoalSelector().getAvailableGoals().stream().map(goal -> new GoalDebugPayload.DebugGoal(goal.getPriority(), goal.isRunning(), goal.getGoal().toString())).toList();
            this.sendDebugData(world, (CustomPacketPayload)new GoalDebugPayload(mob.getId(), mob.blockPosition(), goals));
        }
    }

    public void sendRaids(ServerLevel world, Collection<Raid> raids) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new RaidsDebugPayload(raids.stream().map(Raid::getCenter).toList()));
        }
    }

    public void sendBrainDebugData(ServerLevel serverWorld, LivingEntity livingEntity) {
        if (this.isEnabled()) {
            boolean wantsGolem;
            String inventory;
            int xp;
            String profession;
            int angerLevel;
            Mob entity = (Mob)livingEntity;
            if (entity instanceof Warden) {
                Warden wardenEntity = (Warden)entity;
                angerLevel = wardenEntity.getClientAngerLevel();
            } else {
                angerLevel = -1;
            }
            ArrayList gossips = new ArrayList();
            HashSet<BlockPos> pois = new HashSet<BlockPos>();
            HashSet<BlockPos> potentialPois = new HashSet<BlockPos>();
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                profession = villager.getVillagerData().getProfession().toString();
                xp = villager.getVillagerXp();
                inventory = villager.getInventory().toString();
                wantsGolem = villager.wantsToSpawnGolem(serverWorld.getGameTime());
                villager.getGossips().getGossipEntries().forEach((uuid, associatedGossip) -> {
                    Entity gossipEntity = serverWorld.getEntity(uuid);
                    if (gossipEntity != null) {
                        String name = DebugEntityNameGenerator.getEntityName((Entity)gossipEntity);
                        ObjectIterator objectIterator = associatedGossip.object2IntEntrySet().iterator();
                        while (objectIterator.hasNext()) {
                            Object2IntMap.Entry typeEntry;
                            Object2IntMap.Entry entry = typeEntry = (Object2IntMap.Entry)objectIterator.next();
                            gossips.add(name + ": " + ((GossipType)entry.getKey()).getSerializedName() + " " + String.valueOf(entry.getValue()));
                        }
                    }
                });
                Brain brain = villager.getBrain();
                this.addPoi(brain, (MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, pois);
                this.addPoi(brain, (MemoryModuleType<GlobalPos>)MemoryModuleType.JOB_SITE, pois);
                this.addPoi(brain, (MemoryModuleType<GlobalPos>)MemoryModuleType.MEETING_POINT, pois);
                this.addPoi(brain, (MemoryModuleType<GlobalPos>)MemoryModuleType.HIDING_PLACE, pois);
                this.addPoi(brain, (MemoryModuleType<GlobalPos>)MemoryModuleType.POTENTIAL_JOB_SITE, potentialPois);
            } else {
                profession = "";
                xp = 0;
                inventory = "";
                wantsGolem = false;
            }
            this.sendDebugData(serverWorld, (CustomPacketPayload)new BrainDebugPayload(new BrainDebugPayload.BrainDump(entity.getUUID(), entity.getId(), entity.getName().getString(), profession, xp, entity.getHealth(), entity.getMaxHealth(), entity.position(), inventory, entity.getNavigation().getPath(), wantsGolem, angerLevel, entity.getBrain().getActiveActivities().stream().map(Activity::toString).toList(), entity.getBrain().getRunningBehaviors().stream().map(BehaviorControl::debugString).toList(), this.listMemories((LivingEntity)entity, serverWorld.getGameTime()), gossips, pois, potentialPois)));
        }
    }

    public void sendBeeDebugData(ServerLevel world, Bee bee) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new BeeDebugPayload(new BeeDebugPayload.BeeInfo(bee.getUUID(), bee.getId(), bee.position(), bee.getNavigation().getPath(), bee.getHivePos(), bee.getSavedFlowerPos(), bee.getTravellingTicks(), bee.getGoalSelector().getAvailableGoals().stream().map(prioritizedGoal -> prioritizedGoal.getGoal().toString()).collect(Collectors.toSet()), bee.getBlacklistedHives())));
        }
    }

    public void sendBreezeDebugData(ServerLevel world, Breeze breeze) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new BreezeDebugPayload(new BreezeDebugPayload.BreezeInfo(breeze.getUUID(), breeze.getId(), breeze.getTarget() == null ? null : Integer.valueOf(breeze.getTarget().getId()), (BlockPos)breeze.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).orElse(null))));
        }
    }

    public void sendGameEvent(ServerLevel world, Holder<GameEvent> event, Vec3 pos) {
        if (this.isEnabled()) {
            event.unwrapKey().ifPresent(key -> this.sendDebugData(world, (CustomPacketPayload)new GameEventDebugPayload(key, pos)));
        }
    }

    public void sendGameEventListener(ServerLevel world, GameEventListener eventListener) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (CustomPacketPayload)new GameEventListenerDebugPayload(eventListener.getListenerSource(), eventListener.getListenerRadius()));
        }
    }

    private void addPoi(Brain<?> brain, MemoryModuleType<GlobalPos> memoryModuleType, Set<BlockPos> set) {
        if (this.isEnabled()) {
            Optional<BlockPos> opt = brain.getMemory(memoryModuleType).map(GlobalPos::pos);
            Objects.requireNonNull(set);
            opt.ifPresent(set::add);
        }
    }

    private List<String> listMemories(LivingEntity entity, long currentTime) {
        if (this.isEnabled()) {
            Map map = entity.getBrain().getMemories();
            ArrayList list = Lists.newArrayList();
            for (Map.Entry memoryModuleTypeOptionalEntry : map.entrySet()) {
                Object string;
                MemoryModuleType memoryModuleType = (MemoryModuleType)memoryModuleTypeOptionalEntry.getKey();
                Optional optional = (Optional)memoryModuleTypeOptionalEntry.getValue();
                if (optional.isPresent()) {
                    ExpirableValue memory = (ExpirableValue)optional.get();
                    Object object = memory.getValue();
                    if (memoryModuleType == MemoryModuleType.HEARD_BELL_TIME) {
                        long l = currentTime - (Long)object;
                        string = l + " ticks ago";
                    } else if (memory.canExpire()) {
                        String var10000 = this.format((ServerLevel)entity.level(), object);
                        string = var10000 + " (ttl: " + memory.getTimeToLive() + ")";
                    } else {
                        string = this.format((ServerLevel)entity.level(), object);
                    }
                } else {
                    string = "-";
                }
                String type = BuiltInRegistries.MEMORY_MODULE_TYPE.getKey((Object)memoryModuleType).getPath();
                list.add(type + ": " + (String)string);
            }
            list.sort(String::compareTo);
            return list;
        }
        return List.of();
    }

    private String format(ServerLevel world, @Nullable Object object) {
        if (this.isEnabled()) {
            if (object == null) {
                return "-";
            }
            if (object instanceof UUID) {
                return this.format(world, world.getEntity((UUID)object));
            }
            if (object instanceof LivingEntity) {
                Entity entity = (Entity)object;
                return DebugEntityNameGenerator.getEntityName((Entity)entity);
            }
            if (object instanceof Nameable) {
                return ((Nameable)object).getName().getString();
            }
            if (object instanceof WalkTarget) {
                return this.format(world, ((WalkTarget)object).getTarget());
            }
            if (object instanceof EntityTracker) {
                return this.format(world, ((EntityTracker)object).getEntity());
            }
            if (object instanceof GlobalPos) {
                return this.format(world, ((GlobalPos)object).pos());
            }
            if (object instanceof BlockPosTracker) {
                return this.format(world, ((BlockPosTracker)object).currentBlockPosition());
            }
            if (object instanceof DamageSource) {
                Entity entity = ((DamageSource)object).getEntity();
                return entity == null ? object.toString() : this.format(world, entity);
            }
            if (!(object instanceof Collection)) {
                return object.toString();
            }
            ArrayList list = Lists.newArrayList();
            for (Object object2 : (Iterable)object) {
                list.add(this.format(world, object2));
            }
            return ((Object)list).toString();
        }
        return "";
    }
}

